/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.icons.AllIcons;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Predicates;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HighlightingLevel {
    INSPECTIONS("option.highlighting.level.inspections", AllIcons.Ide.HectorOn, Predicates.alwaysTrue()),
    ADVANCED("option.highlighting.level.syntax", AllIcons.Ide.HectorSyntax, rangeHighlighter -> {
        if (rangeHighlighter.getLayer() > 3000) {
            return false;
        }
        HighlightInfo info = HighlightInfo.fromRangeHighlighter((RangeHighlighter)rangeHighlighter);
        return info == null || info.getSeverity().compareTo(HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) < 0 && info.type != HighlightInfoType.TODO;
    }),
    SIMPLE("option.highlighting.level.none", AllIcons.Ide.HectorOff, rangeHighlighter -> rangeHighlighter.getLayer() <= 1000);

    @NotNull
    private final String myTextKey;
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final Predicate<? super RangeHighlighter> myCondition;

    private HighlightingLevel(@NotNull String textKey, Icon icon, Predicate<? super RangeHighlighter> condition) {
        if (textKey == null) {
            HighlightingLevel.$$$reportNull$$$0(0);
        }
        if (condition == null) {
            HighlightingLevel.$$$reportNull$$$0(1);
        }
        this.myTextKey = textKey;
        this.myIcon = icon;
        this.myCondition = condition;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = DiffBundle.message((String)this.myTextKey, (Object[])new Object[0]);
        if (string == null) {
            HighlightingLevel.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Predicate<? super RangeHighlighter> getCondition() {
        Predicate<? super RangeHighlighter> predicate = this.myCondition;
        if (predicate == null) {
            HighlightingLevel.$$$reportNull$$$0(3);
        }
        return predicate;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textKey";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/tools/util/base/HighlightingLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/tools/util/base/HighlightingLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCondition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

