/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir.actions;

import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.actions.ChangeCompareModeGroup;
import com.intellij.openapi.diff.impl.dir.actions.EnableEqual;
import com.intellij.openapi.diff.impl.dir.actions.EnableLeft;
import com.intellij.openapi.diff.impl.dir.actions.EnableNotEqual;
import com.intellij.openapi.diff.impl.dir.actions.EnableRight;
import com.intellij.openapi.diff.impl.dir.actions.RefreshDirDiffAction;
import com.intellij.openapi.diff.impl.dir.actions.SynchronizeDiff;
import com.intellij.openapi.project.DumbAware;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DirDiffToolbarActions
extends ActionGroup
implements DumbAware {
    private final AnAction[] myActions;

    public DirDiffToolbarActions(DirDiffTableModel model) {
        super(DiffBundle.message((String)"directory.diff.actions", (Object[])new Object[0]), false);
        ArrayList<AnAction> actions = new ArrayList<AnAction>(Arrays.asList(new AnAction[]{new RefreshDirDiffAction(model), Separator.getInstance(), new EnableLeft(model), new EnableNotEqual(model), new EnableEqual(model), new EnableRight(model), Separator.getInstance(), ActionManager.getInstance().getAction("DirDiffMenu.CompareNewFilesWithEachOtherAction"), Separator.getInstance(), new ChangeCompareModeGroup(model), Separator.getInstance()}));
        if (model.getSettings().enableSyncActions && model.isOperationsEnabled()) {
            actions.add((AnAction)new SynchronizeDiff(model, true));
            actions.add((AnAction)new SynchronizeDiff(model, false));
        }
        actions.addAll(model.getSettings().getExtraActions());
        actions.add((AnAction)Separator.getInstance());
        actions.add(ActionManager.getInstance().getAction("Diff.ViewerToolbar"));
        this.myActions = actions.toArray(AnAction.EMPTY_ARRAY);
    }

    public void setUp(DirDiffTableModel model, JComponent panel) {
        for (AnAction action2 : this.myActions) {
            DirDiffToolbarActions.setUp(model, panel, action2);
        }
    }

    private static void setUp(DirDiffTableModel model, JComponent panel, AnAction action2) {
        ShortcutSet shortcut;
        if (action2 instanceof ShortcutProvider && (shortcut = ((ShortcutProvider)action2).getShortcut()) != null) {
            action2.registerCustomShortcutSet(shortcut, panel);
        }
        if (action2 instanceof DirDiffModelHolder) {
            ((DirDiffModelHolder)action2).setModel((DirDiffModel)model);
        }
        if (action2 instanceof ActionGroup) {
            AnAction[] actionChildren;
            AnAction[] anActionArray;
            ActionGroup actionGroup = (ActionGroup)action2;
            if (actionGroup instanceof DefaultActionGroup) {
                DefaultActionGroup defaultActionGroup = (DefaultActionGroup)actionGroup;
                anActionArray = defaultActionGroup.getChildren(ActionManager.getInstance());
            } else {
                anActionArray = actionGroup.getChildren(null);
            }
            for (AnAction child : actionChildren = anActionArray) {
                DirDiffToolbarActions.setUp(model, panel, child);
            }
        }
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (this.myActions == null) {
            DirDiffToolbarActions.$$$reportNull$$$0(0);
        }
        return this.myActions;
    }

    public AnAction @NotNull [] getActions() {
        if (this.myActions == null) {
            DirDiffToolbarActions.$$$reportNull$$$0(1);
        }
        return this.myActions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/diff/impl/dir/actions/DirDiffToolbarActions";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

