/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.DataGridBundle;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DatabaseObjectFormatterConfig;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.util.Out;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class PythonDataFrameExtractorFactory
implements DataExtractorFactory {
    @Override
    @NotNull
    public String getName() {
        String string = DataGridBundle.message("python.pandas.dataframe", new Object[0]);
        if (string == null) {
            PythonDataFrameExtractorFactory.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean supportsText() {
        return true;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "py";
    }

    @Override
    @NotNull
    public DataExtractor createExtractor(@NotNull ExtractorConfig config) {
        if (config == null) {
            PythonDataFrameExtractorFactory.$$$reportNull$$$0(1);
        }
        return new PythonDataFrameExtractor(config.getObjectFormatter());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/PythonDataFrameExtractorFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/PythonDataFrameExtractorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createExtractor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    private static class PythonDataFrameExtractor
    implements DataExtractor {
        private final ObjectFormatter myFormatter;

        private PythonDataFrameExtractor(@NotNull ObjectFormatter formatter) {
            if (formatter == null) {
                PythonDataFrameExtractor.$$$reportNull$$$0(0);
            }
            this.myFormatter = formatter;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            return "py";
        }

        @Override
        public boolean supportsText() {
            return true;
        }

        @Override
        public DataExtractor.Extraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int[] selectedColumns) {
            if (out == null) {
                PythonDataFrameExtractor.$$$reportNull$$$0(1);
            }
            if (allColumns == null) {
                PythonDataFrameExtractor.$$$reportNull$$$0(2);
            }
            if (query == null) {
                PythonDataFrameExtractor.$$$reportNull$$$0(3);
            }
            if (config == null) {
                PythonDataFrameExtractor.$$$reportNull$$$0(4);
            }
            return new ExtractionImpl(out, allColumns, selectedColumns, this.myFormatter);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allColumns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extractors/PythonDataFrameExtractorFactory$PythonDataFrameExtractor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startExtraction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class ExtractionImpl
        implements DataExtractor.Extraction {
            private final Out myOut;
            private final ObjectFormatter myFormatter;
            private List<? extends GridColumn> myAllColumns;
            private final int[] mySelectedColumnIndices;
            private final List<GridRow> myRows;

            ExtractionImpl(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, int @NotNull [] selectedColumns, @NotNull ObjectFormatter formatter) {
                if (out == null) {
                    ExtractionImpl.$$$reportNull$$$0(0);
                }
                if (allColumns == null) {
                    ExtractionImpl.$$$reportNull$$$0(1);
                }
                if (formatter == null) {
                    ExtractionImpl.$$$reportNull$$$0(2);
                }
                if (selectedColumns == null) {
                    ExtractionImpl.$$$reportNull$$$0(3);
                }
                this.myRows = new ArrayList<GridRow>();
                this.myOut = out;
                this.myAllColumns = allColumns;
                this.mySelectedColumnIndices = selectedColumns;
                this.myFormatter = formatter;
            }

            @Override
            public void updateColumns(GridColumn @NotNull [] columns) {
                if (columns == null) {
                    ExtractionImpl.$$$reportNull$$$0(4);
                }
                this.myAllColumns = Arrays.asList(columns);
            }

            @Override
            public void addData(List<? extends GridRow> rows) {
                this.myRows.addAll(rows);
            }

            @Override
            public void complete() {
                int[] selection = GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
                Int2ObjectMap<? extends GridColumn> columnMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
                List<GridColumn> columns = IntStream.of(selection).skip(ExtractionImpl.hasDummyName(selection, columnMap) ? 1L : 0L).mapToObj(arg_0 -> columnMap.get(arg_0)).filter(Objects::nonNull).toList();
                StringBuilder sb = new StringBuilder("import pandas as pd\n\ndata = {");
                for (int colIndex = 0; colIndex < columns.size(); ++colIndex) {
                    GridColumn column = columns.get(colIndex);
                    sb.append("'").append(ExtractionImpl.safePyString(column.getName())).append("': [");
                    for (int rowIndex = 0; rowIndex < this.myRows.size(); ++rowIndex) {
                        sb.append(this.toPythonLiteral(column.getValue(this.myRows.get(rowIndex)), column));
                        if (rowIndex >= this.myRows.size() - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(']');
                    if (colIndex >= columns.size() - 1) continue;
                    sb.append(", ");
                }
                sb.append("}\ndf = pd.DataFrame(data)\n");
                this.myOut.appendText(sb.toString());
            }

            private static boolean hasDummyName(int[] selection, Int2ObjectMap<? extends GridColumn> colMap) {
                if (selection.length == 0) {
                    return false;
                }
                GridColumn firstColumn = (GridColumn)colMap.get(selection[0]);
                if (firstColumn == null) {
                    return true;
                }
                String name = firstColumn.getName();
                return name == null || name.isEmpty();
            }

            @NotNull
            private String toPythonLiteral(Object value, GridColumn column) {
                if (value == null) {
                    return "None";
                }
                String s = this.myFormatter.objectToString(value, column, new DatabaseObjectFormatterConfig(ObjectFormatterMode.DEFAULT));
                if (s == null) {
                    return "None";
                }
                int columnType = column.getType();
                if ((ExtractionImpl.isNumericValueType(columnType) || columnType == 1111) && s.matches("-?\\d+(\\.\\d+)?") || columnType == 16) {
                    String string = s;
                    if (string == null) {
                        ExtractionImpl.$$$reportNull$$$0(5);
                    }
                    return string;
                }
                String string = "'" + s.replace("\\", "\\\\").replace("'", "\\'") + "'";
                if (string == null) {
                    ExtractionImpl.$$$reportNull$$$0(6);
                }
                return string;
            }

            private static boolean isNumericValueType(int valueType) {
                return switch (valueType) {
                    case -6, -5, 2, 3, 4, 5, 6, 7, 8 -> true;
                    default -> false;
                };
            }

            @NotNull
            private static String safePyString(@NotNull String s) {
                if (s == null) {
                    ExtractionImpl.$$$reportNull$$$0(7);
                }
                String string = s.replace("\\", "\\\\").replace("'", "\\'");
                if (string == null) {
                    ExtractionImpl.$$$reportNull$$$0(8);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 5, 6, 8 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "allColumns";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "formatter";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "selectedColumns";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "columns";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/extractors/PythonDataFrameExtractorFactory$PythonDataFrameExtractor$ExtractionImpl";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/extractors/PythonDataFrameExtractorFactory$PythonDataFrameExtractor$ExtractionImpl";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toPythonLiteral";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "safePyString";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateColumns";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: {
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "safePyString";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 5, 6, 8 -> new IllegalStateException(string);
                };
            }
        }
    }
}

