/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\u000b"}, d2={"fitsIntoXlsxNumber", "", "value", "", "trimAndCountDigits", "", "(Ljava/lang/Number;)Ljava/lang/Integer;", "trimRightZeros", "Ljava/math/BigInteger;", "bigInteger", "countDigits", "intellij.grid.core.impl"})
public final class XlsxValuesExtractorKt {
    private static final boolean fitsIntoXlsxNumber(Number value) {
        Integer count = XlsxValuesExtractorKt.trimAndCountDigits(value);
        return count != null && count <= 15;
    }

    private static final Integer trimAndCountDigits(Number value) {
        try {
            BigDecimal bigDecimal = new BigDecimal(value.toString()).stripTrailingZeros();
            try {
                BigInteger bigInteger = bigDecimal.toBigIntegerExact();
                Intrinsics.checkNotNull((Object)bigInteger);
                return XlsxValuesExtractorKt.countDigits(XlsxValuesExtractorKt.trimRightZeros(bigInteger));
            }
            catch (ArithmeticException bigInteger) {
                return bigDecimal.precision();
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static final BigInteger trimRightZeros(BigInteger bigInteger) {
        BigInteger num = bigInteger;
        while (Intrinsics.areEqual((Object)num.remainder(BigInteger.TEN), (Object)BigInteger.ZERO) && !Intrinsics.areEqual((Object)num, (Object)BigInteger.ZERO)) {
            Intrinsics.checkNotNullExpressionValue((Object)num.divide(BigInteger.TEN), (String)"divide(...)");
        }
        return num;
    }

    private static final int countDigits(BigInteger bigInteger) {
        BigInteger num = bigInteger;
        int count = 0;
        while (!Intrinsics.areEqual((Object)num, (Object)BigInteger.ZERO)) {
            Intrinsics.checkNotNullExpressionValue((Object)num.divide(BigInteger.TEN), (String)"divide(...)");
            ++count;
        }
        return count;
    }

    public static final /* synthetic */ boolean access$fitsIntoXlsxNumber(Number value) {
        return XlsxValuesExtractorKt.fitsIntoXlsxNumber(value);
    }
}

