/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.InstrumentationStrategy;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.data.ProjectContext;
import com.intellij.rt.coverage.instrumentation.dataAccess.CondyCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.CoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.FieldCoverageDataAccess;
import com.intellij.rt.coverage.instrumentation.dataAccess.NameCoverageDataAccess;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

public class CoverageTransformer
extends AbstractIntellijClassfileTransformer {
    private final ProjectData myProjectData;
    protected final ProjectContext myProjectContext;
    private boolean myStop;

    /*
     * WARNING - void declaration
     */
    public CoverageTransformer(ProjectData projectData, ProjectContext projectContext) {
        void var2_2;
        void var1_1;
        this.myProjectData = var1_1;
        this.myProjectContext = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassVisitor cw) {
        void var3_3;
        void var1_1;
        return InstrumentationStrategy.createInstrumenter(this.myProjectData, className, cr, cw, this.myProjectContext, this.createDataAccess((String)var1_1, (ClassReader)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private CoverageDataAccess createDataAccess(String className, ClassReader cr) {
        void var2_2;
        void var1_1;
        if (OptionsUtil.FIELD_INSTRUMENTATION_ENABLED) {
            if (InstrumentationUtils.isCondyEnabled(cr)) {
                return new CondyCoverageDataAccess(this.createCondyInit(className, cr));
            }
            return new FieldCoverageDataAccess(cr, className, this.createInit(className, cr, false));
        }
        return new NameCoverageDataAccess(this.createInit((String)var1_1, (ClassReader)var2_2, true));
    }

    /*
     * WARNING - void declaration
     */
    protected CoverageDataAccess.Init createInit(String className, ClassReader cr, boolean needCache) {
        void var1_1;
        void var2_4;
        void var3_5;
        String arrayType;
        boolean calculateHits = this.myProjectContext.getOptions().isCalculateHits;
        String string = arrayType = calculateHits ? "[I" : "[Z";
        String methodName = calculateHits ? (needCache ? "getHitsCached" : "getHits") : (var3_5 != false ? "getHitsMaskCached" : "getHitsMask");
        return new CoverageDataAccess.Init("__$hits$__", arrayType, "com/intellij/rt/coverage/instrumentation/CoverageRuntime", (String)var2_4, "(Ljava/lang/String;)" + arrayType, new Object[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    protected CoverageDataAccess.Init createCondyInit(String className, ClassReader cr) {
        void var1_1;
        void var3_5;
        void var2_4;
        boolean calculateHits = this.myProjectContext.getOptions().isCalculateHits;
        String arrayType = calculateHits ? "[I" : "[Z";
        String methodName = calculateHits ? "getHits" : "getHitsMask";
        return new CoverageDataAccess.Init("__$hits$__", arrayType, "com/intellij/rt/coverage/util/CondyUtils", (String)var2_4, "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/String;)" + (String)var3_5, new Object[]{var1_1});
    }

    @Override
    protected boolean shouldExclude(String className) {
        return ClassNameUtil.matchesPatterns(className, this.myProjectContext.getOptions().excludePatterns);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected AbstractIntellijClassfileTransformer.InclusionPattern getInclusionPattern() {
        void var1_1;
        List<Pattern> includes = this.myProjectContext.getOptions().includePatterns;
        if (includes == null || includes.isEmpty()) {
            return null;
        }
        return new AbstractIntellijClassfileTransformer.InclusionPattern(this, (List)var1_1){
            final /* synthetic */ List val$includes;
            final /* synthetic */ CoverageTransformer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$includes = list;
            }

            @Override
            public boolean accept(String className) {
                return ClassNameUtil.matchesPatterns(className, this.val$includes);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void visitClassLoader(ClassLoader classLoader) {
        ClassFinder classFinder = this.myProjectContext.getClassFinder();
        if (classFinder != null) {
            void var1_1;
            void var2_2;
            var2_2.addClassLoader((ClassLoader)var1_1);
        }
    }

    @Override
    protected boolean isStopped() {
        return this.myStop;
    }

    public void stop() {
        this.myStop = true;
    }
}

