/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.git.branch.tree;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.vcs.impl.shared.VcsUpdatesDebouncer;
import com.intellij.vcs.git.branch.tree.GitBranchesTreeUpdate;
import com.intellij.vcs.git.repo.GitRepositoriesHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeUpdatesService;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "updatesDebouncer", "Lcom/intellij/platform/vcs/impl/shared/VcsUpdatesDebouncer;", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeUpdate;", "updates", "Lkotlinx/coroutines/flow/Flow;", "getUpdates", "()Lkotlinx/coroutines/flow/Flow;", "refresh", "", "refresh$intellij_vcs_git_shared", "Companion", "intellij.vcs.git.shared"})
@SourceDebugExtension(value={"SMAP\nGitBranchesTreeUpdatesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBranchesTreeUpdatesService.kt\ncom/intellij/vcs/git/branch/tree/GitBranchesTreeUpdatesService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1915#2,2:78\n*S KotlinDebug\n*F\n+ 1 GitBranchesTreeUpdatesService.kt\ncom/intellij/vcs/git/branch/tree/GitBranchesTreeUpdatesService\n*L\n24#1:78,2\n*E\n"})
public final class GitBranchesTreeUpdatesService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsUpdatesDebouncer<GitBranchesTreeUpdate> updatesDebouncer;
    @NotNull
    private final Flow<GitBranchesTreeUpdate> updates;
    @NotNull
    private static final Logger LOG;

    public GitBranchesTreeUpdatesService(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.updatesDebouncer = new VcsUpdatesDebouncer(GitBranchesTreeUpdatesService::updatesDebouncer$lambda$0);
        this.updates = this.updatesDebouncer.getUpdates();
        project.getMessageBus().connect(cs).subscribe(GitRepositoriesHolder.Companion.getUPDATES(), arg_0 -> GitBranchesTreeUpdatesService._init_$lambda$0(this, arg_0));
    }

    @NotNull
    public final Flow<GitBranchesTreeUpdate> getUpdates() {
        return this.updates;
    }

    public final void refresh$intellij_vcs_git_shared() {
        this.updatesDebouncer.tryEmit((Object)GitBranchesTreeUpdate.REFRESH);
    }

    private static final Unit updatesDebouncer$lambda$0(ProducerScope $this$VcsUpdatesDebouncer, List batchUpdate) {
        List distinctEvents;
        Intrinsics.checkNotNullParameter((Object)$this$VcsUpdatesDebouncer, (String)"$this$VcsUpdatesDebouncer");
        Intrinsics.checkNotNullParameter((Object)batchUpdate, (String)"batchUpdate");
        if (LOG.isTraceEnabled()) {
            LOG.trace("Handling batch " + batchUpdate);
        }
        if ((distinctEvents = CollectionsKt.distinct((Iterable)batchUpdate)).contains((Object)GitBranchesTreeUpdate.REFRESH)) {
            ChannelResult.box-impl((Object)$this$VcsUpdatesDebouncer.trySend-JP2dKIU((Object)GitBranchesTreeUpdate.REFRESH));
        } else {
            Iterable $this$forEach$iv = distinctEvents;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GitBranchesTreeUpdate it = (GitBranchesTreeUpdate)((Object)element$iv);
                boolean bl = false;
                $this$VcsUpdatesDebouncer.trySend-JP2dKIU((Object)it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(GitBranchesTreeUpdatesService this$0, GitRepositoriesHolder.UpdateType event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        GitBranchesTreeUpdate update2 = switch (WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1 -> GitBranchesTreeUpdate.REPAINT;
            case 2 -> GitBranchesTreeUpdate.REFRESH;
            case 3 -> GitBranchesTreeUpdate.REFRESH;
            case 4 -> GitBranchesTreeUpdate.REFRESH;
            case 5 -> GitBranchesTreeUpdate.REFRESH_TAGS;
            case 6 -> GitBranchesTreeUpdate.REFRESH;
            case 7 -> GitBranchesTreeUpdate.REFRESH;
            case 8 -> GitBranchesTreeUpdate.REFRESH;
            default -> throw new NoWhenBranchMatchedException();
        };
        if (LOG.isDebugEnabled()) {
            LOG.debug("Transformed " + event + " to " + update2);
        }
        this$0.updatesDebouncer.tryEmit((Object)update2);
    }

    static {
        Logger logger = Logger.getInstance(GitBranchesTreeUpdatesService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeUpdatesService$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lcom/intellij/vcs/git/branch/tree/GitBranchesTreeUpdatesService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git.shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitBranchesTreeUpdatesService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(GitBranchesTreeUpdatesService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (GitBranchesTreeUpdatesService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GitRepositoriesHolder.UpdateType.values().length];
            try {
                nArray[GitRepositoriesHolder.UpdateType.FAVORITE_REFS_UPDATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRepositoriesHolder.UpdateType.REPOSITORY_CREATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRepositoriesHolder.UpdateType.REPOSITORY_DELETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRepositoriesHolder.UpdateType.REPOSITORY_STATE_UPDATED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRepositoriesHolder.UpdateType.TAGS_LOADED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRepositoriesHolder.UpdateType.TAGS_HIDDEN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRepositoriesHolder.UpdateType.WORKING_TREES_LOADED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRepositoriesHolder.UpdateType.RELOAD_STATE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

