/*
 * Decompiled with CFR 0.152.
 */
package git4idea.fetch;

import com.intellij.openapi.ui.UiUtils;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0007\u001a\u00020\b2\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bJ\u0018\u0010\f\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bJ\u001c\u0010\r\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/fetch/GitFetchErrorFormatter;", "", "<init>", "()V", "BRANCH_CHECKED_OUT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isCheckedOutBranchError", "", "errorMessage", "", "Lorg/jetbrains/annotations/Nls;", "format", "tryFormatCheckedOutBranchError", "intellij.vcs.git"})
public final class GitFetchErrorFormatter {
    @NotNull
    public static final GitFetchErrorFormatter INSTANCE = new GitFetchErrorFormatter();
    private static final Pattern BRANCH_CHECKED_OUT_PATTERN = Pattern.compile("refusing to fetch into branch '(.*)' checked out at '(.*)'");

    private GitFetchErrorFormatter() {
    }

    public final boolean isCheckedOutBranchError(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return BRANCH_CHECKED_OUT_PATTERN.matcher(errorMessage).matches();
    }

    @NotNull
    public final String format(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        String string = this.tryFormatCheckedOutBranchError(errorMessage);
        if (string == null) {
            string = errorMessage;
        }
        return string;
    }

    private final String tryFormatCheckedOutBranchError(String errorMessage) {
        Matcher matcher = BRANCH_CHECKED_OUT_PATTERN.matcher(errorMessage);
        if (!matcher.matches()) {
            return null;
        }
        String branchRef = matcher.group(1);
        String path = matcher.group(2);
        String string = GitBranchUtil.stripRefsPrefix(branchRef);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stripRefsPrefix(...)");
        String shortBranchName = string;
        Intrinsics.checkNotNull((Object)path);
        String shortPath = UiUtils.getPresentablePath((String)path);
        Object[] objectArray = new Object[]{shortBranchName, shortPath};
        return GitBundle.message("branches.update.error.branch.checked.out", objectArray);
    }
}

