/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview;

import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J?\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u000bJ\u0011\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006*\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/collaboration/ui/codereview/CodeReviewTitleUIUtil;", "", "<init>", "()V", "createTitleText", "", "Lcom/intellij/openapi/util/NlsSafe;", "title", "reviewNumber", "url", "tooltip", "Lorg/jetbrains/annotations/Nls;", "unwrap", "intellij.platform.collaborationTools"})
public final class CodeReviewTitleUIUtil {
    @NotNull
    public static final CodeReviewTitleUIUtil INSTANCE = new CodeReviewTitleUIUtil();

    private CodeReviewTitleUIUtil() {
    }

    @NotNull
    public final String createTitleText(@NotNull String title, @NotNull String reviewNumber, @NotNull String url, @NotNull String tooltip) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)reviewNumber, (String)"reviewNumber");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        HtmlChunk.Element element = HtmlChunk.link((String)url, (String)reviewNumber).attr("title", tooltip).wrapWith(HtmlChunk.font((String)ColorUtil.toHex((Color)NamedColorUtil.getInactiveTextColor())));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"wrapWith(...)");
        HtmlChunk.Element reviewNumberLink = element;
        String string = new HtmlBuilder().appendRaw(this.unwrap(title)).nbsp().append((HtmlChunk)reviewNumberLink).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String unwrap(String $this$unwrap) {
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$this$unwrap, (CharSequence)"<body>"), (CharSequence)"</body>"), (CharSequence)"<p>"), (CharSequence)"</p>");
    }
}

