/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class InlineDebugRendererBase
implements EditorCustomElementRenderer {
    private static final ExecutorService inExecutionPointRepainterExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"InlineDebugRenderer in Execution Point Repainter", (int)1);
    public boolean isInExecutionPointCached;
    protected int myRemoveXCoordinate = Integer.MAX_VALUE;
    protected int myTextStartXCoordinate;
    protected boolean isHovered = false;
    protected String specialRenderId = "";
    private static final float BACKGROUND_ALPHA = 0.55f;

    public void onClick(Inlay inlay, @NotNull EditorMouseEvent event) {
        if (event == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(0);
        }
    }

    public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        if (inlay == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(1);
        }
        if (g == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(2);
        }
        if (r == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(3);
        }
        if (textAttributes == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(4);
        }
        EditorImpl editor = (EditorImpl)inlay.getEditor();
        ReadAction.nonBlocking(this::calculateIsInExecutionPoint).finishOnUiThread(ModalityState.stateForComponent((Component)editor.getComponent()), freshValue -> {
            if (freshValue != this.isInExecutionPointCached) {
                this.isInExecutionPointCached = freshValue;
                inlay.repaint();
            }
        }).coalesceBy(new Object[]{inlay}).expireWith((Disposable)inlay).submit((Executor)inExecutionPointRepainterExecutor);
        TextAttributes inlineAttributes = this.getAttributes((Editor)editor);
        if (inlineAttributes == null || inlineAttributes.getForegroundColor() == null) {
            return;
        }
        Font font = InlineDebugRendererBase.getFont((Editor)editor);
        g.setFont(font);
        FontMetrics metrics = InlineDebugRendererBase.getFontMetrics(font, (Editor)editor);
        int gap = 1;
        int margin = metrics.charWidth(' ') / 4;
        Color backgroundColor = inlineAttributes.getBackgroundColor();
        int curX = r.x + metrics.charWidth(' ');
        if (backgroundColor != null) {
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
            GraphicsUtil.paintWithAlpha((Graphics)g, (float)0.55f);
            g.setColor(backgroundColor);
            g.fillRoundRect(curX + margin, r.y + gap, r.width - 2 * margin - metrics.charWidth(' '), r.height - gap * 2, 6, 6);
            config.restore();
        }
        curX += 2 * margin;
        Icon nodeIcon = this.getIcon();
        if (nodeIcon != null) {
            nodeIcon.paintIcon(inlay.getEditor().getComponent(), g, curX, InlineDebugRendererBase.getIconY(nodeIcon, r));
            curX += nodeIcon.getIconWidth() + margin * 2;
        }
        this.myTextStartXCoordinate = curX;
        for (int i = 0; i < this.getPresentation().getTexts().size(); ++i) {
            Object curText = (String)this.getPresentation().getTexts().get(i);
            if (i == 0 && !this.isErrorMessage()) {
                curText = (String)curText + ": ";
            }
            SimpleTextAttributes attr = (SimpleTextAttributes)this.getPresentation().getAttributes().get(i);
            Color fgColor = this.isHovered ? inlineAttributes.getForegroundColor() : attr.getFgColor();
            g.setColor(fgColor);
            g.drawString((String)curText, curX, r.y + inlay.getEditor().getAscent());
            curX += metrics.stringWidth((String)curText);
            if (this.isErrorMessage()) break;
        }
        if (this.isHovered) {
            Icon icon;
            if (this.isCustomNode()) {
                icon = AllIcons.Actions.Close;
                this.myRemoveXCoordinate = curX;
            } else {
                icon = AllIcons.General.LinkDropTriangle;
            }
            icon.paintIcon(inlay.getEditor().getComponent(), g, curX, InlineDebugRendererBase.getIconY(icon, r));
        }
        InlineDebugRendererBase.paintEffects(g, r, editor, inlineAttributes, font, metrics);
    }

    @Nullable
    protected Icon getIcon() {
        return this.isCustomNode() ? AllIcons.Debugger.Watch : null;
    }

    public int calcWidthInPixels(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(5);
        }
        int width = this.getInlayTextWidth(inlay);
        width += this.isCustomNode() ? AllIcons.Actions.Close.getIconWidth() : AllIcons.General.LinkDropTriangle.getIconWidth();
        Icon icon = this.getIcon();
        if (icon != null) {
            width += icon.getIconWidth();
        }
        return width;
    }

    private int getInlayTextWidth(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(6);
        }
        Font font = InlineDebugRendererBase.getFont(inlay.getEditor());
        Object text = this.isErrorMessage() ? (String)this.getPresentation().getTexts().get(0) : this.getPresentation().toString() + ": ";
        return InlineDebugRendererBase.getFontMetrics(font, inlay.getEditor()).stringWidth((String)text + "  ");
    }

    private static Font getFont(@NotNull Editor editor) {
        if (editor == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(7);
        }
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
        int fontStyle = attributes == null ? 0 : attributes.getFontType();
        return UIUtil.getFontWithFallback((Font)colorsScheme.getFont(EditorFontType.forJavaStyle((int)fontStyle)));
    }

    @NotNull
    private static FontMetrics getFontMetrics(Font font, @NotNull Editor editor) {
        if (editor == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(8);
        }
        FontMetrics fontMetrics = FontInfo.getFontMetrics((Font)font, (FontRenderContext)FontInfo.getFontRenderContext((Component)editor.getContentComponent()));
        if (fontMetrics == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(9);
        }
        return fontMetrics;
    }

    private static int getIconY(Icon icon, Rectangle r) {
        return r.y + r.height / 2 - icon.getIconHeight() / 2;
    }

    private static void paintEffects(@NotNull Graphics g, @NotNull Rectangle r, EditorImpl editor, TextAttributes inlineAttributes, Font font, FontMetrics metrics) {
        if (g == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(10);
        }
        if (r == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(11);
        }
        Color effectColor = inlineAttributes.getEffectColor();
        EffectType effectType = inlineAttributes.getEffectType();
        if (effectColor != null) {
            g.setColor(effectColor);
            Graphics2D g2d = (Graphics2D)g;
            int xStart = r.x;
            int xEnd = r.x + r.width;
            int y = r.y + metrics.getAscent();
            if (effectType == EffectType.LINE_UNDERSCORE) {
                EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.BOLD_LINE_UNDERSCORE) {
                EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.STRIKEOUT) {
                EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, editor.getCharHeight(), (Object)font);
            } else if (effectType == EffectType.WAVE_UNDERSCORE) {
                EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            } else if (effectType == EffectType.BOLD_DOTTED_LINE) {
                EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, metrics.getDescent(), (Object)font);
            }
        }
    }

    public void onMouseExit(@NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(12);
        }
        this.setHovered(false, inlay);
    }

    public void onMouseMove(@NotNull Inlay inlay, @NotNull EditorMouseEvent event) {
        if (inlay == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(13);
        }
        if (event == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(14);
        }
        this.setHovered(event.getMouseEvent().getX() >= this.myTextStartXCoordinate, inlay);
    }

    private void setHovered(boolean active, @NotNull Inlay inlay) {
        if (inlay == null) {
            InlineDebugRendererBase.$$$reportNull$$$0(15);
        }
        boolean oldState = this.isHovered;
        this.isHovered = active;
        Cursor cursor = active ? Cursor.getPredefinedCursor(12) : null;
        ((EditorEx)inlay.getEditor()).setCustomCursor(InlineDebugRendererBase.class, cursor);
        if (oldState != active) {
            inlay.update();
        }
    }

    @NotNull
    public abstract SimpleColoredText getPresentation();

    private TextAttributes getAttributes(Editor editor) {
        TextAttributesKey key = this.isInExecutionPointCached ? DebuggerColors.INLINED_VALUES_EXECUTION_LINE : DebuggerColors.INLINED_VALUES;
        EditorColorsScheme scheme = editor.getColorsScheme();
        TextAttributes inlinedAttributes = scheme.getAttributes(key);
        if (this.isHovered) {
            Color foregroundColor;
            TextAttributes hoveredInlineAttr = new TextAttributes();
            hoveredInlineAttr.copyFrom(inlinedAttributes);
            Color hoveredAndSelectedColor = scheme.getAttributes(DebuggerColors.EXECUTIONPOINT_ATTRIBUTES).getForegroundColor();
            Color color = foregroundColor = this.isInExecutionPointCached ? hoveredAndSelectedColor : scheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR).getForegroundColor();
            if (foregroundColor == null) {
                foregroundColor = scheme.getDefaultForeground();
            }
            hoveredInlineAttr.setForegroundColor(foregroundColor);
            return hoveredInlineAttr;
        }
        return inlinedAttributes;
    }

    public int getRemoveXCoordinate() {
        return this.myRemoveXCoordinate;
    }

    public int getTextStartXCoordinate() {
        return this.myTextStartXCoordinate;
    }

    public abstract boolean isCustomNode();

    public abstract boolean isErrorMessage();

    @RequiresBackgroundThread
    protected abstract boolean calculateIsInExecutionPoint();

    @ApiStatus.Internal
    public String getSpecialRenderId() {
        return this.specialRenderId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlay";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/InlineDebugRendererBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/InlineDebugRendererBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onClick";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthInPixels";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInlayTextWidth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFont";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFontMetrics";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "paintEffects";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onMouseExit";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMove";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setHovered";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

