/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.beans;

import com.intellij.internal.statistic.eventLog.EventLogSystemEvents;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.intellij.internal.statistic.eventLog.validator.IDataValidationRules;
import com.intellij.internal.statistic.eventLog.validator.IEventContext;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventDataValidationError;
import com.intellij.internal.statistic.eventLog.validator.rules.FUSRule;
import com.intellij.internal.statistic.eventLog.validator.rules.beans.EventGroupContextData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import com.intellij.internal.statistic.eventLog.validator.rules.utils.ValidationSimpleRuleFactory;
import com.intellij.internal.statistic.eventLog.validator.storage.GlobalRulesHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataValidationRules
implements IDataValidationRules {
    public static final DataValidationRules EMPTY = new DataValidationRules(new ValidationSimpleRuleFactory(ValidationSimpleRuleFactory.REJECTING_UTIL_URL_PRODUCER), Collections.emptyMap(), EventGroupContextData.EMPTY, Collections.emptyList());
    protected final Map<String, FUSRule[]> eventDataRules;
    protected final List<String> myExcludedFields;
    private static final FUSRule[] ALWAYS_TRUE_RULES = new FUSRule[]{FUSRule.TRUE};

    protected DataValidationRules(@NotNull ValidationSimpleRuleFactory factory, Map<String, ? extends Set<String>> eventDataRules, @NotNull EventGroupContextData contextData, @NotNull List<String> excludedFields) {
        this.myExcludedFields = excludedFields;
        if (eventDataRules != null && !eventDataRules.isEmpty()) {
            HashMap<String, FUSRule[]> rules = new HashMap<String, FUSRule[]>();
            for (Map.Entry<String, ? extends Set<String>> entry : eventDataRules.entrySet()) {
                if (this.myExcludedFields.contains(entry.getKey())) {
                    rules.put(entry.getKey(), ALWAYS_TRUE_RULES);
                    continue;
                }
                rules.put(entry.getKey(), factory.getRules(entry.getValue(), contextData));
            }
            this.eventDataRules = rules.size() == 1 ? DataValidationRules.toSingletonMap(rules) : Collections.unmodifiableMap(rules);
        } else {
            this.eventDataRules = Collections.emptyMap();
        }
    }

    @NotNull
    public static DataValidationRules create(@Nullable Map<String, Set<String>> eventDataRules, @NotNull GlobalRulesHolder globalRulesHolder, @NotNull ValidationSimpleRuleFactory factory, @NotNull List<String> excludedFields, @Nullable DictionaryStorage dictionaryStorage) {
        return eventDataRules == null ? EMPTY : new DataValidationRules(factory, eventDataRules, new EventGroupContextData(Collections.emptyMap(), Collections.emptyMap(), globalRulesHolder, Collections.emptyMap(), dictionaryStorage), excludedFields);
    }

    @NotNull
    private static Map<String, FUSRule[]> toSingletonMap(Map<String, FUSRule[]> rules) {
        Map.Entry<String, FUSRule[]> entry = rules.entrySet().iterator().next();
        return Collections.singletonMap(entry.getKey(), entry.getValue());
    }

    private static Object validateEventDataValue(@NotNull Object data, IEventContext context, FUSRule @NotNull [] rules, @NotNull String jsonPath) {
        String value = data.toString();
        ValidationResultType resultType = DataValidationRules.acceptRule(value, context, rules);
        if (resultType == ValidationResultType.ACCEPTED) {
            return data;
        }
        context.addError(new EventDataValidationError(resultType, jsonPath, value));
        return resultType.getDescription();
    }

    private static ValidationResultType acceptRule(@NotNull String ruleData, IEventContext context, FUSRule ... rules) {
        if (rules == null) {
            return ValidationResultType.UNDEFINED_RULE;
        }
        ValidationResultType prevResult = null;
        for (FUSRule rule : rules) {
            ValidationResultType resultType = rule.validate(ruleData, context);
            if (resultType.isFinal()) {
                return resultType;
            }
            prevResult = resultType;
        }
        return prevResult != null ? prevResult : ValidationResultType.REJECTED;
    }

    @Override
    @NotNull
    public EventDataField validateEventData(@NotNull String key, @Nullable Object data, @NotNull IEventContext context) {
        return this.validateData(key, data, context, "event.data");
    }

    @Override
    @NotNull
    public EventDataField validateData(@NotNull String key, @Nullable Object data, @NotNull IEventContext context, @NotNull String jsonPath) {
        return this.validateEventData(key, data, context, key, jsonPath + "." + key);
    }

    private EventDataField validateEventData(@NotNull String key, @Nullable Object data, IEventContext context, @NotNull String fieldName, @NotNull String jsonPath) {
        if (data == null) {
            context.addError(new EventDataValidationError(ValidationResultType.REJECTED, jsonPath, "Data is null"));
            return new EventDataField(fieldName, ValidationResultType.REJECTED.getDescription());
        }
        if (data instanceof String && (ValidationResultType.VALIDATION_TYPES.contains(data) || EventLogSystemEvents.SYSTEM_EVENTS.contains(data))) {
            return new EventDataField(fieldName, data);
        }
        if (this.myExcludedFields.contains(key)) {
            return new EventDataField(fieldName, data);
        }
        if (data instanceof Map) {
            HashMap<String, Object> validatedData = new HashMap<String, Object>();
            for (Map.Entry entry : ((Map)data).entrySet()) {
                Object entryKey = entry.getKey();
                if (entryKey instanceof String) {
                    EventDataField field = this.validateEventData(key + "." + String.valueOf(entryKey), entry.getValue(), context, (String)entryKey, jsonPath + "." + String.valueOf(entryKey));
                    validatedData.put(field.getName(), field.getValue());
                    continue;
                }
                context.addError(new EventDataValidationError(ValidationResultType.REJECTED, jsonPath + "." + entryKey.toString(), "Entry key should be String, actual=" + String.valueOf(entryKey)));
                validatedData.put((String)entryKey, ValidationResultType.REJECTED.getDescription());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && validatedData.keySet().stream().allMatch(value -> value instanceof String && ValidationResultType.UNDEFINED_RULE.getDescription().equals(value))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        if (data instanceof List) {
            ArrayList<Object> validatedData = new ArrayList<Object>();
            ArrayList<String> fieldNames = new ArrayList<String>();
            List objects = (List)data;
            for (int i = 0; i < objects.size(); ++i) {
                Object value2 = objects.get(i);
                EventDataField validatedField = this.validateEventData(key, value2, context, fieldName, jsonPath + "[" + i + "]");
                validatedData.add(validatedField.getValue());
                fieldNames.add(validatedField.getName());
            }
            String validatedFieldName = fieldName;
            if (!validatedData.isEmpty() && fieldNames.stream().allMatch(value -> ValidationResultType.UNDEFINED_RULE.getDescription().equals(value))) {
                validatedFieldName = ValidationResultType.UNDEFINED_RULE.getDescription();
            }
            return new EventDataField(validatedFieldName, validatedData);
        }
        FUSRule[] rules = this.eventDataRules.get(key);
        if (rules == null || rules.length == 0) {
            context.addError(new EventDataValidationError(ValidationResultType.UNDEFINED_RULE, jsonPath, "Undefined rule"));
            return new EventDataField(ValidationResultType.UNDEFINED_RULE.getDescription(), ValidationResultType.UNDEFINED_RULE.getDescription());
        }
        return new EventDataField(fieldName, DataValidationRules.validateEventDataValue(data, context, rules, jsonPath));
    }

    public boolean areEventDataRulesDefined() {
        return !this.eventDataRules.isEmpty();
    }

    @Override
    @NotNull
    public Map<String, FUSRule[]> getEventDataRules() {
        return this.eventDataRules;
    }
}

