/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.theoryinpractice.testng.TestngBundle;
import com.theoryinpractice.testng.configuration.browser.SuiteBrowser;
import com.theoryinpractice.testng.inspection.TestNGSearchScope;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UndeclaredTestInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(UndeclaredTestInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return "TestNG";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "UndeclaredTests";
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            UndeclaredTestInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            UndeclaredTestInspection.$$$reportNull$$$0(1);
        }
        if (TestNGUtil.hasTest((PsiModifierListOwner)aClass) && PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true)) {
            Project project = aClass.getProject();
            String qName = aClass.getQualifiedName();
            if (qName == null) {
                return null;
            }
            String packageQName = StringUtil.getPackageName((String)qName);
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 0; i < qName.length(); ++i) {
                if (qName.charAt(i) != '.') continue;
                names.add(qName.substring(0, i));
            }
            names.add(qName);
            Collections.reverse(names);
            for (String name : names) {
                boolean isFullName = qName.equals(name);
                AtomicBoolean found = new AtomicBoolean();
                PsiSearchHelper.getInstance((Project)project).processUsagesInNonJavaFiles(name, (file, startOffset, endOffset) -> {
                    if (file.findReferenceAt(startOffset) != null) {
                        if (!isFullName) {
                            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), XmlTag.class);
                            if (tag == null || !tag.getName().equals("package")) {
                                return true;
                            }
                            XmlAttribute attribute = tag.getAttribute("name");
                            if (attribute == null) {
                                return true;
                            }
                            String value = attribute.getValue();
                            if (value == null) {
                                return true;
                            }
                            if (!value.endsWith(".*") && !value.equals(packageQName)) {
                                return true;
                            }
                        }
                        found.set(true);
                        return false;
                    }
                    return true;
                }, (GlobalSearchScope)new TestNGSearchScope(project));
                if (!found.get()) continue;
                return null;
            }
            PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
            LOG.assertTrue(nameIdentifier != null);
            return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)nameIdentifier, TestngBundle.message("inspection.undeclared.test.problem.descriptor", aClass.getName()), isOnTheFly, new LocalQuickFix[]{new RegisterClassFix(aClass), new CreateTestngFix()}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        }
        return null;
    }

    public static void patchTestngXml(XmlFile testngXML, PsiClass psiClass) {
        XmlTag rootTag = testngXML.getDocument().getRootTag();
        if (rootTag != null && rootTag.getName().equals("suite")) {
            try {
                XmlTag classesTag;
                XmlTag testTag = rootTag.findFirstSubTag("test");
                if (testTag == null) {
                    testTag = (XmlTag)rootTag.add((PsiElement)rootTag.createChildTag("test", rootTag.getNamespace(), null, false));
                    testTag.setAttribute("name", psiClass.getName());
                }
                if ((classesTag = testTag.findFirstSubTag("classes")) == null) {
                    classesTag = (XmlTag)testTag.add((PsiElement)testTag.createChildTag("classes", testTag.getNamespace(), null, false));
                }
                XmlTag classTag = (XmlTag)classesTag.add((PsiElement)classesTag.createChildTag("class", classesTag.getNamespace(), null, false));
                String qualifiedName = psiClass.getQualifiedName();
                LOG.assertTrue(qualifiedName != null);
                classTag.setAttribute("name", qualifiedName);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "aClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
        }
        objectArray[1] = "com/theoryinpractice/testng/inspection/UndeclaredTestInspection";
        objectArray[2] = "checkClass";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RegisterClassFix
    implements LocalQuickFix {
        private final String myClassName;

        RegisterClassFix(PsiClass aClass) {
            this.myClassName = aClass.getName();
        }

        @NotNull
        public String getName() {
            String string = TestngBundle.message("inspection.undeclared.test.register", this.myClassName);
            if (string == null) {
                RegisterClassFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = TestngBundle.message("inspection.undeclared.test.register.test", new Object[0]);
            if (string == null) {
                RegisterClassFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiClass psiClass;
            if (project == null) {
                RegisterClassFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                RegisterClassFix.$$$reportNull$$$0(3);
            }
            LOG.assertTrue((psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class)) != null);
            String testngXmlPath = new SuiteBrowser(project).showDialog();
            if (testngXmlPath == null) {
                return;
            }
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(testngXmlPath);
            LOG.assertTrue(virtualFile != null);
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
            LOG.assertTrue(psiFile instanceof XmlFile);
            XmlFile testngXML = (XmlFile)psiFile;
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{testngXML}).withName(this.getName()).run(() -> UndeclaredTestInspection.patchTestngXml(testngXML, psiClass));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$RegisterClassFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class CreateTestngFix
    implements LocalQuickFix {
        private CreateTestngFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = TestngBundle.message("inspection.undeclared.test.create.suite.fix", new Object[0]);
            if (string == null) {
                CreateTestngFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                CreateTestngFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                CreateTestngFix.$$$reportNull$$$0(2);
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiClass.class);
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (Project)project, null);
            if (file != null) {
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                PsiDirectory directory = psiManager.findDirectory(file);
                LOG.assertTrue(directory != null);
                WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])PsiFile.EMPTY_ARRAY).withName(this.getName()).run(() -> {
                    XmlFile testngXml = (XmlFile)PsiFileFactory.getInstance((Project)psiManager.getProject()).createFileFromText("testng.xml", "<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\">\n<suite></suite>");
                    try {
                        testngXml = (XmlFile)directory.add((PsiElement)testngXml);
                    }
                    catch (IncorrectOperationException e) {
                        return;
                    }
                    UndeclaredTestInspection.patchTestngXml(testngXml, psiClass);
                });
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/theoryinpractice/testng/inspection/UndeclaredTestInspection$CreateTestngFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }
}

