/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.headers;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.headers.HeaderLevelInferenceTypedHandler$Companion$findPreviousHeader$;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "<init>", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "char", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nHeaderLevelInferenceTypedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderLevelInferenceTypedHandler.kt\norg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler\n+ 2 actions.kt\ncom/intellij/openapi/command/ActionsKt\n*L\n1#1,153:1\n7#2,6:154\n*S KotlinDebug\n*F\n+ 1 HeaderLevelInferenceTypedHandler.kt\norg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler\n*L\n45#1:154,6\n*E\n"})
public final class HeaderLevelInferenceTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull FileType fileType2) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        if (!Registry.Companion.is("markdown.experimental.header.level.inference.enable", false)) {
            TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor2, file, fileType2);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"beforeCharTyped(...)");
            return result;
        }
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)MarkdownFileType.INSTANCE)) || !(file instanceof MarkdownFile) || c != '#') {
            TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor2, file, fileType2);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"beforeCharTyped(...)");
            return result;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project).commitDocument(document2);
        if (HeaderLevelInferenceTypedHandler.Companion.shouldIgnore((MarkdownFile)file, editor2)) {
            TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor2, file, fileType2);
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"beforeCharTyped(...)");
            return result;
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        MarkdownHeader markdownHeader = HeaderLevelInferenceTypedHandler.Companion.findPreviousHeader((MarkdownFile)file, document2, caretOffset);
        int level = markdownHeader != null ? markdownHeader.getLevel() : 1;
        StringBuilder $this$beforeCharTyped_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = 0;
        while (n < level) {
            int it = n++;
            boolean bl2 = false;
            $this$beforeCharTyped_u24lambda_u240.append('#');
        }
        $this$beforeCharTyped_u24lambda_u240.append(' ');
        String header = stringBuilder.toString();
        Project project$iv = project;
        String name$iv = null;
        Object groupId$iv = null;
        boolean $i$f$executeCommand = false;
        CommandProcessor.getInstance().executeCommand(project$iv, new Runnable(editor2, header){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ String $header$inlined;
            {
                this.$editor$inlined = editor2;
                this.$header$inlined = string;
            }

            public final void run() {
                boolean bl = false;
                EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)this.$header$inlined);
            }
        }, name$iv, groupId$iv);
        return TypedHandlerDelegate.Result.STOP;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J#\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\"\u0010\u001d\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler$Companion;", "", "<init>", "()V", "shouldIgnore", "", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "obtainContentStartOffset", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "document", "Lcom/intellij/openapi/editor/Document;", "line", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;Lcom/intellij/openapi/editor/Document;I)Ljava/lang/Integer;", "isValidLinePrefix", "prefix", "", "obtainLinePrefix", "offset", "walkTreeUp", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiElement;", "withSelf", "findPreviousHeader", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "findStartElement", "findListItemForOffset", "findPossibleListItemForOffset", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nHeaderLevelInferenceTypedHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderLevelInferenceTypedHandler.kt\norg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,153:1\n479#2:154\n*S KotlinDebug\n*F\n+ 1 HeaderLevelInferenceTypedHandler.kt\norg/intellij/plugins/markdown/editor/headers/HeaderLevelInferenceTypedHandler$Companion\n*L\n119#1:154\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean shouldIgnore(MarkdownFile file, Editor editor2) {
            int currentLine;
            Integer itemContentStartOffset;
            int offset = editor2.getCaretModel().getOffset();
            Document document = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            MarkdownListItem listItem = this.findListItemForOffset(file, offset, document2);
            if (listItem != null && (itemContentStartOffset = this.obtainContentStartOffset(listItem, document2, currentLine = document2.getLineNumber(offset))) != null && itemContentStartOffset <= offset) {
                CharSequence prefix = document2.getCharsSequence().subSequence(itemContentStartOffset, offset);
                return !this.isValidLinePrefix(file, prefix);
            }
            CharSequence prefix = this.obtainLinePrefix(document2, offset);
            return !this.isValidLinePrefix(file, prefix);
        }

        private final Integer obtainContentStartOffset(MarkdownListItem $this$obtainContentStartOffset, Document document, int line) {
            PsiElement psiElement = $this$obtainContentStartOffset.getMarkerElement();
            if (psiElement == null) {
                return null;
            }
            PsiElement marker = psiElement;
            int markerEndOffset = PsiTreeUtilKt.getEndOffset((PsiElement)marker);
            int markerLineStartOffset = DocumentUtil.getLineStartOffset((int)markerEndOffset, (Document)document);
            int contentOffsetInsideLine = markerEndOffset - markerLineStartOffset;
            int lineStartOffset = document.getLineStartOffset(line);
            return lineStartOffset + contentOffsetInsideLine;
        }

        private final boolean isValidLinePrefix(MarkdownFile file, CharSequence prefix) {
            if (!StringsKt.isBlank((CharSequence)prefix)) {
                return false;
            }
            int tabSize = CodeStyle.getFacade((PsiFile)((PsiFile)file)).getTabSize();
            String tabReplacement = StringsKt.repeat((CharSequence)" ", (int)tabSize);
            String actualPrefix = StringsKt.replace$default((String)((Object)prefix).toString(), (String)"\t", (String)tabReplacement, (boolean)false, (int)4, null);
            return actualPrefix.length() < 4;
        }

        private final CharSequence obtainLinePrefix(Document document, int offset) {
            int lineStart = DocumentUtil.getLineStartOffset((int)offset, (Document)document);
            return document.getCharsSequence().subSequence(lineStart, offset);
        }

        private final Sequence<PsiElement> walkTreeUp(PsiElement $this$walkTreeUp, boolean withSelf) {
            return SequencesKt.flatMap((Sequence)PsiTreeUtilKt.parents((PsiElement)$this$walkTreeUp, (boolean)true), arg_0 -> Companion.walkTreeUp$lambda$0(withSelf, arg_0));
        }

        private final MarkdownHeader findPreviousHeader(MarkdownFile file, Document document, int offset) {
            Sequence<PsiElement> elements2;
            PsiElement startElement = this.findStartElement(file, document, offset);
            Sequence<PsiElement> $this$filterIsInstance$iv = elements2 = this.walkTreeUp(startElement, true);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)Companion$findPreviousHeader$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            return (MarkdownHeader)SequencesKt.firstOrNull((Sequence)sequence);
        }

        private final PsiElement findStartElement(MarkdownFile file, Document document, int offset) {
            MarkdownListItem markdownListItem = this.findListItemForOffset(file, offset, document);
            Object listItemBefore = markdownListItem != null ? markdownListItem.getLastChild() : null;
            PsiElement psiElement = listItemBefore;
            if (psiElement == null) {
                PsiElement psiElement2 = PsiUtilCore.getElementAtOffset((PsiFile)((PsiFile)file), (int)offset);
                psiElement = psiElement2;
                Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElementAtOffset(...)");
            }
            return psiElement;
        }

        private final MarkdownListItem findListItemForOffset(MarkdownFile file, int offset, Document document) {
            MarkdownListItem markdownListItem = this.findPossibleListItemForOffset(file, offset, document);
            if (markdownListItem == null) {
                return null;
            }
            MarkdownListItem item = markdownListItem;
            int itemLine = document.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)item)));
            String string = ListUtils.INSTANCE.getLineIndentSpaces(document, itemLine, (PsiFile)file);
            if (string == null) {
                return null;
            }
            String itemIndent = string;
            int line = document.getLineNumber(offset);
            String string2 = ListUtils.INSTANCE.getLineIndentSpaces(document, line, (PsiFile)file);
            if (string2 == null) {
                return null;
            }
            String currentIndent = string2;
            if (StringsKt.startsWith$default((String)currentIndent, (String)itemIndent, (boolean)false, (int)2, null)) {
                return item;
            }
            return null;
        }

        private final MarkdownListItem findPossibleListItemForOffset(MarkdownFile file, int offset, Document document) {
            int line;
            int currentLine = document.getLineNumber(offset);
            int minPossibleStartLine = RangesKt.coerceAtLeast((int)(currentLine - 2), (int)0);
            if (minPossibleStartLine <= (line = currentLine)) {
                while (true) {
                    int searchOffset;
                    MarkdownListItem listItem;
                    if ((listItem = ListUtils.INSTANCE.getListItemAt((PsiFile)file, searchOffset = document.getLineEndOffset(line), document)) != null) {
                        return listItem;
                    }
                    if (line == minPossibleStartLine) break;
                    --line;
                }
            }
            return null;
        }

        private static final Sequence walkTreeUp$lambda$0(boolean $withSelf, PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return PsiTreeUtilKt.siblings((PsiElement)it, (boolean)false, (boolean)$withSelf);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

