/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.webTypes;

import com.intellij.diagnostic.PluginException;
import com.intellij.model.Pointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.polySymbols.impl.StaticPolySymbolScope;
import com.intellij.polySymbols.webTypes.WebTypesEmbeddedIconLoader;
import com.intellij.polySymbols.webTypes.WebTypesScopeBase;
import com.intellij.polySymbols.webTypes.WebTypesSymbolTypeSupportFactory;
import com.intellij.polySymbols.webTypes.WebTypesVersionsRegistry;
import com.intellij.polySymbols.webTypes.impl.WebTypesDefinitionsEP;
import com.intellij.polySymbols.webTypes.json.WebTypes;
import com.intellij.util.text.SemVer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0003!\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "state", "Lcom/intellij/openapi/util/ClearableLazyValue;", "Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "webTypesEnabledPackages", "", "", "getWebTypesEnabledPackages", "()Ljava/util/Set;", "packagesEnabledByDefault", "", "Lcom/intellij/util/text/SemVer;", "getPackagesEnabledByDefault", "()Ljava/util/Map;", "defaultWebTypesScope", "Lcom/intellij/polySymbols/webTypes/WebTypesScopeBase;", "getDefaultWebTypesScope", "()Lcom/intellij/polySymbols/webTypes/WebTypesScopeBase;", "getWebTypes", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "Lcom/intellij/polySymbols/webTypes/json/WebTypes;", "packageName", "packageVersion", "dispose", "", "Companion", "State", "DefaultWebTypesScope", "intellij.platform.polySymbols"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nWebTypesEmbeddedDefinitionsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n13#2:133\n*S KotlinDebug\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader\n*L\n37#1:133\n*E\n"})
public final class WebTypesEmbeddedDefinitionsLoader
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ClearableLazyValue<State> state;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public WebTypesEmbeddedDefinitionsLoader(@NotNull Project project) {
        void it;
        ClearableLazyValue clearableLazyValue;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ClearableLazyValue clearableLazyValue2 = clearableLazyValue = ClearableLazyValue.create(() -> WebTypesEmbeddedDefinitionsLoader.state$lambda$0(this));
        WebTypesEmbeddedDefinitionsLoader webTypesEmbeddedDefinitionsLoader = this;
        boolean bl = false;
        WebTypesDefinitionsEP.Companion.getEP_NAME().addChangeListener(() -> WebTypesEmbeddedDefinitionsLoader.state$lambda$1$0((ClearableLazyValue)it), (Disposable)this);
        ClearableLazyValue clearableLazyValue3 = clearableLazyValue;
        Intrinsics.checkNotNullExpressionValue((Object)clearableLazyValue3, (String)"also(...)");
        webTypesEmbeddedDefinitionsLoader.state = clearableLazyValue3;
    }

    private final Set<String> getWebTypesEnabledPackages() {
        return ((State)this.state.getValue()).getVersionsRegistry().getPackages();
    }

    private final Map<String, SemVer> getPackagesEnabledByDefault() {
        return ((State)this.state.getValue()).getPackagesEnabledByDefault();
    }

    private final WebTypesScopeBase getDefaultWebTypesScope() {
        return ((State)this.state.getValue()).getDefaultWebTypesScope();
    }

    private final Pair<PluginDescriptor, WebTypes> getWebTypes(String packageName, SemVer packageVersion) {
        return ((State)this.state.getValue()).getVersionsRegistry().get(packageName, packageVersion);
    }

    public void dispose() {
    }

    private static final void state$lambda$1$0(ClearableLazyValue $it) {
        $it.drop();
    }

    private static final State state$lambda$0(WebTypesEmbeddedDefinitionsLoader this$0) {
        return new State(this$0.project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WebTypesEmbeddedDefinitionsLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J.\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00132\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader;", "project", "Lcom/intellij/openapi/project/Project;", "forPackage", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "Lcom/intellij/polySymbols/webTypes/json/WebTypes;", "packageName", "", "packageVersion", "Lcom/intellij/util/text/SemVer;", "getWebTypesEnabledPackages", "", "getPackagesEnabledByDefault", "", "getDefaultWebTypesScope", "Lcom/intellij/polySymbols/impl/StaticPolySymbolScope;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.polySymbols"})
    @SourceDebugExtension(value={"SMAP\nWebTypesEmbeddedDefinitionsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n30#2,2:133\n*S KotlinDebug\n*F\n+ 1 WebTypesEmbeddedDefinitionsLoader.kt\ncom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$Companion\n*L\n23#1:133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebTypesEmbeddedDefinitionsLoader getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<WebTypesEmbeddedDefinitionsLoader> serviceClass$iv = WebTypesEmbeddedDefinitionsLoader.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (WebTypesEmbeddedDefinitionsLoader)object;
        }

        @Nullable
        public final Pair<PluginDescriptor, WebTypes> forPackage(@NotNull Project project, @NotNull String packageName, @Nullable SemVer packageVersion) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            return this.getInstance(project).getWebTypes(packageName, packageVersion);
        }

        @NotNull
        public final Set<String> getWebTypesEnabledPackages(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(project).getWebTypesEnabledPackages();
        }

        @NotNull
        public final Map<String, SemVer> getPackagesEnabledByDefault(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(project).getPackagesEnabledByDefault();
        }

        @NotNull
        public final StaticPolySymbolScope getDefaultWebTypesScope(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return this.getInstance(project).getDefaultWebTypesScope();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0096\u0082\u0004J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004J\u0010\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$DefaultWebTypesScope;", "Lcom/intellij/polySymbols/webTypes/WebTypesScopeBase;", "state", "Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;Lcom/intellij/openapi/project/Project;)V", "equals", "", "other", "", "hashCode", "", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.platform.polySymbols"})
    private static final class DefaultWebTypesScope
    extends WebTypesScopeBase {
        @NotNull
        private final State state;
        @NotNull
        private final Project project;

        public DefaultWebTypesScope(@NotNull State state, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.state = state;
            this.project = project;
            for (Map.Entry<String, SemVer> entry : this.state.getPackagesEnabledByDefault().entrySet()) {
                Pair<PluginDescriptor, WebTypes> pair;
                if (this.state.getVersionsRegistry().get(entry.getKey(), entry.getValue()) == null) continue;
                boolean bl = false;
                PluginDescriptor pluginDescriptor = (PluginDescriptor)pair.component1();
                WebTypes webTypes = (WebTypes)pair.component2();
                this.addWebTypes(webTypes, new WebTypesScopeBase.WebTypesJsonOriginImpl(webTypes, WebTypesSymbolTypeSupportFactory.Companion.get$default(WebTypesSymbolTypeSupportFactory.Companion, webTypes, null, null, 6, null), this.project, null, null, (Function1)new Function1<String, Icon>((Object)new WebTypesEmbeddedIconLoader(pluginDescriptor)){

                    public final Icon invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((WebTypesEmbeddedIconLoader)this.receiver).loadIcon(p0);
                    }
                }, null, 24, null));
            }
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof DefaultWebTypesScope && Intrinsics.areEqual((Object)((DefaultWebTypesScope)other).state, (Object)this.state);
        }

        public int hashCode() {
            return this.state.hashCode();
        }

        @Override
        @NotNull
        public Pointer<? extends WebTypesScopeBase> createPointer() {
            Project project = this.state.getProject();
            return () -> DefaultWebTypesScope.createPointer$lambda$0(project);
        }

        private static final WebTypesScopeBase createPointer$lambda$0(Project $project) {
            if ($project.isDisposed()) {
                return null;
            }
            return ((State)Companion.getInstance($project).state.getValue()).getDefaultWebTypesScope();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004J\n\u0010\u001e\u001a\u00020\u0011H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lcom/intellij/polySymbols/webTypes/WebTypesEmbeddedDefinitionsLoader$State;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "versionsRegistry", "Lcom/intellij/polySymbols/webTypes/WebTypesVersionsRegistry;", "Lkotlin/Pair;", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "Lcom/intellij/polySymbols/webTypes/json/WebTypes;", "getVersionsRegistry", "()Lcom/intellij/polySymbols/webTypes/WebTypesVersionsRegistry;", "packagesEnabledByDefault", "", "", "Lcom/intellij/util/text/SemVer;", "getPackagesEnabledByDefault", "()Ljava/util/Map;", "defaultWebTypesScope", "Lcom/intellij/polySymbols/webTypes/WebTypesScopeBase;", "getDefaultWebTypesScope", "()Lcom/intellij/polySymbols/webTypes/WebTypesScopeBase;", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.polySymbols"})
    private static final class State {
        @NotNull
        private final Project project;
        @NotNull
        private final WebTypesVersionsRegistry<Pair<PluginDescriptor, WebTypes>> versionsRegistry;
        @NotNull
        private final Map<String, SemVer> packagesEnabledByDefault;
        @NotNull
        private final WebTypesScopeBase defaultWebTypesScope;

        public State(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.versionsRegistry = new WebTypesVersionsRegistry();
            HashMap<String, SemVer> packagesEnabledByDefault = new HashMap<String, SemVer>();
            for (WebTypesDefinitionsEP ep : WebTypesDefinitionsEP.Companion.getEP_NAME().getExtensionList()) {
                try {
                    SemVer semVer;
                    Object object = ep.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getInstance(...)");
                    WebTypes webTypes = (WebTypes)object;
                    Intrinsics.checkNotNull((Object)SemVer.parseFromText((String)webTypes.getVersion()));
                    if (Intrinsics.areEqual((Object)ep.enableByDefault, (Object)true)) {
                        packagesEnabledByDefault.merge(webTypes.getName(), semVer, (arg_0, arg_1) -> State._init_$lambda$1(State::_init_$lambda$0, arg_0, arg_1));
                    }
                    String string = webTypes.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    this.versionsRegistry.put(string, semVer, (Pair<PluginDescriptor, WebTypes>)new Pair((Object)ep.getPluginDescriptor(), (Object)webTypes));
                }
                catch (PluginException e) {
                    LOG.error((Throwable)e);
                }
            }
            this.packagesEnabledByDefault = packagesEnabledByDefault;
            this.defaultWebTypesScope = new DefaultWebTypesScope(this, this.project);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final WebTypesVersionsRegistry<Pair<PluginDescriptor, WebTypes>> getVersionsRegistry() {
            return this.versionsRegistry;
        }

        @NotNull
        public final Map<String, SemVer> getPackagesEnabledByDefault() {
            return this.packagesEnabledByDefault;
        }

        @NotNull
        public final WebTypesScopeBase getDefaultWebTypesScope() {
            return this.defaultWebTypesScope;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof State && Intrinsics.areEqual((Object)this.project, (Object)((State)other).project) && Intrinsics.areEqual(this.versionsRegistry, ((State)other).versionsRegistry) && Intrinsics.areEqual(this.packagesEnabledByDefault, ((State)other).packagesEnabledByDefault);
        }

        public int hashCode() {
            return this.project.hashCode();
        }

        @NotNull
        public String toString() {
            return "WebTypesEmbeddedDefinitionsLoaderState: project=" + this.project + "; versionsRegistry=" + this.versionsRegistry + "; packagesEnabledByDefault=" + this.packagesEnabledByDefault;
        }

        private static final SemVer _init_$lambda$0(SemVer a, SemVer b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return a.isGreaterOrEqualThan(b) ? a : b;
        }

        private static final SemVer _init_$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return (SemVer)$tmp0.invoke(p0, p1);
        }
    }
}

