/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinModificationHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.vcs.commit.UnknownCommitProblem;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/commit/ProxyCommitCheck;", "Lcom/intellij/openapi/vcs/checkin/CommitCheck;", "checkinHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "executor", "Lcom/intellij/openapi/vcs/changes/CommitExecutor;", "<init>", "(Lcom/intellij/openapi/vcs/checkin/CheckinHandler;Lcom/intellij/openapi/vcs/changes/CommitExecutor;)V", "getCheckinHandler", "()Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isDumbAware", "", "isEnabled", "runCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "", "intellij.platform.vcs.impl"})
final class ProxyCommitCheck
implements CommitCheck {
    @NotNull
    private final CheckinHandler checkinHandler;
    @Nullable
    private final CommitExecutor executor;

    public ProxyCommitCheck(@NotNull CheckinHandler checkinHandler, @Nullable CommitExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)checkinHandler, (String)"checkinHandler");
        this.checkinHandler = checkinHandler;
        this.executor = executor;
    }

    @NotNull
    public final CheckinHandler getCheckinHandler() {
        return this.checkinHandler;
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        if (this.checkinHandler instanceof CheckinModificationHandler) {
            return CommitCheck.ExecutionOrder.MODIFICATION;
        }
        return CommitCheck.ExecutionOrder.LATE;
    }

    public boolean isDumbAware() {
        return DumbService.Companion.isDumbAware((Object)this.checkinHandler);
    }

    public boolean isEnabled() {
        return true;
    }

    @Nullable
    public Object runCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        CheckinHandler.ReturnResult result2 = this.checkinHandler.beforeCheckin(commitInfo.getExecutor(), commitInfo.getCommitContext().getAdditionalDataConsumer());
        if (result2 == null || result2 == CheckinHandler.ReturnResult.COMMIT) {
            return null;
        }
        return new UnknownCommitProblem(result2);
    }

    @NotNull
    public String toString() {
        return "ProxyCommitCheck: " + this.checkinHandler;
    }
}

