/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiFile;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AnnotationSessionImpl
extends AnnotationSession {
    private final UserDataHolder myDataHolder;
    private volatile TextRange myPriorityRange;
    private volatile TextRange myHighlightRange;
    private volatile HighlightSeverity myMinimumSeverity;

    private AnnotationSessionImpl(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(0);
        }
        super(psiFile);
        this.myDataHolder = new UserDataHolderBase();
    }

    @ApiStatus.Internal
    @NotNull
    public static AnnotationSession create(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(1);
        }
        return new AnnotationSessionImpl(psiFile);
    }

    @NotNull
    public TextRange getPriorityRange() {
        TextRange textRange = Objects.requireNonNullElseGet(this.myPriorityRange, () -> this.getFile().getTextRange());
        if (textRange == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public TextRange getHighlightRange() {
        TextRange textRange = Objects.requireNonNullElseGet(this.myHighlightRange, () -> this.getFile().getTextRange());
        if (textRange == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @ApiStatus.Internal
    void setVR(@NotNull TextRange priorityRange, @NotNull TextRange highlightRange) {
        if (priorityRange == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(4);
        }
        if (highlightRange == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(5);
        }
        this.myPriorityRange = priorityRange;
        this.myHighlightRange = highlightRange;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(6);
        }
        return (T)this.myDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(7);
        }
        this.myDataHolder.putUserData(key, value);
    }

    void setMinimumSeverity(@Nullable HighlightSeverity severity) {
        this.myMinimumSeverity = severity;
    }

    public HighlightSeverity getMinimumSeverity() {
        return this.myMinimumSeverity;
    }

    @ApiStatus.Internal
    public static <T> T computeWithSession(@NotNull PsiFile psiFile, boolean batchMode, @NotNull Annotator annotator, @NotNull Function<? super AnnotationHolder, T> runnable) {
        if (psiFile == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(8);
        }
        if (annotator == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(9);
        }
        if (runnable == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(10);
        }
        return AnnotationSessionImpl.computeWithSession(batchMode, annotator, new AnnotationSessionImpl(psiFile), runnable);
    }

    @ApiStatus.Internal
    public static <T> T computeWithSession(@NotNull PsiFile psiFile, boolean batchMode, @NotNull ExternalAnnotator<?, ?> annotator, @NotNull Function<? super AnnotationHolder, T> runnable) {
        if (psiFile == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(11);
        }
        if (annotator == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(12);
        }
        if (runnable == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(13);
        }
        return AnnotationSessionImpl.computeWithSession(batchMode, annotator, new AnnotationSessionImpl(psiFile), runnable);
    }

    static <T> T computeWithSession(boolean batchMode, @NotNull Object annotator, @NotNull AnnotationSession session, @NotNull Function<? super AnnotationHolderImpl, T> runnable) {
        if (annotator == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(14);
        }
        if (session == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(15);
        }
        if (runnable == null) {
            AnnotationSessionImpl.$$$reportNull$$$0(16);
        }
        AnnotationHolderImpl holder = new AnnotationHolderImpl(annotator, session, batchMode);
        return runnable.apply(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/AnnotationSessionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityRange";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/AnnotationSessionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriorityRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setVR";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "computeWithSession";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

