/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.LookupUtil;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.RecalculatableResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TemplateManagerListener;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerUtilBase;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.TemplatePreprocessor;
import com.intellij.codeInsight.template.impl.TemplateSegments;
import com.intellij.codeInsight.template.impl.TemplateStateBase;
import com.intellij.codeInsight.template.impl.TemplateStateProcessor;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInsight.template.macro.TemplateCompletionProcessor;
import com.intellij.diagnostic.CoreAttachmentFactory;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHint;
import com.intellij.openapi.editor.ex.util.EditorActionAvailabilityHintKt;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TemplateState
extends TemplateStateBase
implements Disposable {
    private static final Logger LOG = Logger.getInstance(TemplateState.class);
    @NotNull
    private final TemplateStateProcessor myLiveTemplateProcessor;
    private Project myProject;
    private TemplateImpl myPrevTemplate;
    private RangeMarker myTemplateRange;
    private final List<RangeHighlighter> myTabStopHighlighters;
    private int myCurrentVariableNumber;
    private int myCurrentSegmentNumber;
    private boolean myDocumentChangesTerminateTemplate;
    private boolean myDocumentChanged;
    @Nullable
    private LookupListener myLookupListener;
    private final List<TemplateEditingListener> myListeners;
    private DocumentListener myEditorDocumentListener;
    private boolean myTemplateIndented;
    @Nullable
    private PairProcessor<? super String, ? super String> myProcessor;
    private boolean mySelectionCalculated;
    private boolean myStarted;
    private final TemplateManagerListener myEventPublisher;
    public static final Key<Boolean> TEMPLATE_RANGE_HIGHLIGHTER_KEY = Key.create((String)"TemplateState.rangeHighlighterKey");
    public static final Key<Boolean> FORCE_TEMPLATE_RUNNING = Key.create((String)"TemplateState.forTemplateRunning");

    @ApiStatus.Internal
    public TemplateState(@NotNull Project project, @Nullable Editor editor, @NotNull Document document, @NotNull TemplateStateProcessor processor) {
        if (project == null) {
            TemplateState.$$$reportNull$$$0(0);
        }
        if (document == null) {
            TemplateState.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            TemplateState.$$$reportNull$$$0(2);
        }
        super(editor, document);
        this.myTabStopHighlighters = new ArrayList<RangeHighlighter>();
        this.myCurrentVariableNumber = -1;
        this.myCurrentSegmentNumber = -1;
        this.myDocumentChangesTerminateTemplate = true;
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myLiveTemplateProcessor = processor;
        this.myEventPublisher = (TemplateManagerListener)project.getMessageBus().syncPublisher(TemplateManager.TEMPLATE_STARTED_TOPIC);
    }

    public Project getProject() {
        return this.myProject;
    }

    private void initListeners() {
        if (this.isDisposed()) {
            return;
        }
        this.myEditorDocumentListener = new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CommandProcessor.getInstance().isCommandInProgress() && !TemplateState.this.isUndoOrRedoInProgress()) {
                    TemplateState.this.myDocumentChanged = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/impl/TemplateState$1", "beforeDocumentChange"));
            }
        };
        this.myLookupListener = new LookupListener(){

            public void itemSelected(@NotNull LookupEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (TemplateState.this.isCaretOutsideCurrentSegment(null)) {
                    if (TemplateState.this.isCaretInsideOrBeforeNextVariable()) {
                        TemplateState.this.nextTab();
                    } else {
                        TemplateState.this.gotoEnd(true);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/codeInsight/template/impl/TemplateState$2", "itemSelected"));
            }
        };
        LookupManager.getInstance((Project)this.myProject).addPropertyChangeListener(evt -> {
            Lookup lookup;
            if ("activeLookup".equals(evt.getPropertyName()) && (lookup = (Lookup)evt.getNewValue()) != null) {
                lookup.addLookupListener(this.myLookupListener);
            }
        }, (Disposable)this);
        if (this.getEditor() != null) {
            this.installCaretListener(this.getEditor());
        }
        this.getDocument().addDocumentListener(this.myEditorDocumentListener, (Disposable)this);
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(CommandListener.TOPIC, (Object)new CommandListener(){
            boolean started;

            public void commandStarted(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!TemplateState.this.isUndoOrRedoInProgress()) {
                    TemplateState.this.myDocumentChangesTerminateTemplate = TemplateState.this.isCaretOutsideCurrentSegment(event.getCommandName());
                    this.started = true;
                }
            }

            public void beforeCommandFinished(@NotNull CommandEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (this.started && !TemplateState.this.isDisposed() && !TemplateState.this.isUndoOrRedoInProgress()) {
                    LookupUtil.performGuardedChange(TemplateState.this.getEditor(), () -> TemplateState.this.afterChangedUpdate());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateState$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "commandStarted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommandFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean isUndoOrRedoInProgress() {
        return this.myLiveTemplateProcessor.isUndoOrRedoInProgress(this.myProject);
    }

    private void installCaretListener(@NotNull Editor editor) {
        if (editor == null) {
            TemplateState.$$$reportNull$$$0(3);
        }
        CaretListener listener2 = new CaretListener(){

            public void caretAdded(@NotNull CaretEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (!TemplateState.this.isInteractiveModeSupported()) {
                    TemplateState.this.finishTemplate(false);
                }
            }

            public void caretRemoved(@NotNull CaretEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (!TemplateState.this.isInteractiveModeSupported()) {
                    TemplateState.this.finishTemplate(false);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateState$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        editor.getCaretModel().addCaretListener(listener2, (Disposable)this);
    }

    private boolean isCaretInsideOrBeforeNextVariable() {
        if (this.getEditor() != null && this.myCurrentVariableNumber >= 0) {
            TextRange nextVarRange;
            int nextVar = this.getNextVariableNumber(this.myCurrentVariableNumber);
            TextRange textRange = nextVarRange = nextVar < 0 ? null : this.getVariableRange(this.getTemplate().getVariableNameAt(nextVar));
            if (nextVarRange == null) {
                return false;
            }
            int caretOffset = this.getEditor().getCaretModel().getOffset();
            if (nextVarRange.containsOffset(caretOffset)) {
                return true;
            }
            TextRange currentVarRange = this.getVariableRange(this.getTemplate().getVariableNameAt(this.myCurrentVariableNumber));
            return currentVarRange != null && currentVarRange.getEndOffset() < caretOffset && caretOffset < nextVarRange.getStartOffset();
        }
        return false;
    }

    private boolean isCaretOutsideCurrentSegment(String commandName) {
        return this.myLiveTemplateProcessor.isCaretOutsideCurrentSegment(this.getEditor(), this.getSegments(), this.myCurrentSegmentNumber, commandName);
    }

    private boolean isInteractiveModeSupported() {
        return this.getEditor() != null && this.getEditor().getCaretModel().getCaretCount() <= 1 && !(this.getEditor() instanceof ImaginaryEditor);
    }

    public synchronized void dispose() {
        if (this.myLookupListener != null) {
            LookupEx lookup;
            LookupEx lookupEx = lookup = this.getEditor() != null ? LookupManager.getActiveLookup((Editor)this.getEditor()) : null;
            if (lookup != null) {
                lookup.removeLookupListener(this.myLookupListener);
            }
            this.myLookupListener = null;
        }
        this.myEditorDocumentListener = null;
        this.myProcessor = null;
        this.getProperties().clear();
        this.myListeners.clear();
        this.releaseAll();
        this.setDocument(null);
    }

    public boolean isToProcessTab() {
        LookupEx lookup;
        if (this.isCaretOutsideCurrentSegment(null)) {
            return false;
        }
        if (this.myLiveTemplateProcessor.isLookupShown() && (lookup = LookupManager.getActiveLookup((Editor)this.getEditor())) != null && !lookup.isFocused()) {
            return true;
        }
        return !this.myLiveTemplateProcessor.isLookupShown();
    }

    private void setCurrentVariableNumber(int variableNumber) {
        this.myCurrentVariableNumber = variableNumber;
        boolean isFinished = this.isFinished();
        if (this.getDocument() != null) {
            ((DocumentEx)this.getDocument()).setStripTrailingSpacesEnabled(isFinished);
        }
        this.myCurrentSegmentNumber = isFinished ? -1 : this.getCurrentSegmentNumber();
    }

    @Nullable
    public TextRange getCurrentVariableRange() {
        int number = this.getCurrentSegmentNumber();
        if (number == -1) {
            return null;
        }
        return new TextRange(this.getSegments().getSegmentStart(number), this.getSegments().getSegmentEnd(number));
    }

    @Nullable
    public TextRange getVariableRange(String variableName) {
        int segment = this.getTemplate().getVariableSegmentNumber(variableName);
        if (segment < 0) {
            return null;
        }
        return new TextRange(this.getSegments().getSegmentStart(segment), this.getSegments().getSegmentEnd(segment));
    }

    public int getSegmentsCount() {
        return this.getSegments().getSegmentsCount();
    }

    public TextRange getSegmentRange(int segment) {
        return new TextRange(this.getSegments().getSegmentStart(segment), this.getSegments().getSegmentEnd(segment));
    }

    public boolean isFinished() {
        return this.myCurrentVariableNumber < 0;
    }

    private void releaseAll() {
        if (this.getSegments() != null) {
            this.getSegments().removeAll();
            this.setSegments(null);
        }
        if (this.myTemplateRange != null) {
            this.myTemplateRange.dispose();
            this.myTemplateRange = null;
        }
        this.myPrevTemplate = this.getTemplate();
        this.setTemplate(null);
        this.myProject = null;
        this.releaseEditor();
    }

    private void releaseEditor() {
        if (this.getEditor() != null) {
            for (RangeHighlighter segmentHighlighter : this.myTabStopHighlighters) {
                segmentHighlighter.dispose();
            }
            this.myTabStopHighlighters.clear();
            this.setEditor(null);
        }
    }

    @ApiStatus.Internal
    public void start(@NotNull TemplateImpl template, @Nullable PairProcessor<? super String, ? super String> processor, @Nullable Map<String, String> predefinedVarValues) {
        if (template == null) {
            TemplateState.$$$reportNull$$$0(4);
        }
        this.start(template, processor, predefinedVarValues, this.getEditor().getCaretModel().getOffset());
    }

    void start(@NotNull TemplateImpl template, @Nullable PairProcessor<? super String, ? super String> processor, @Nullable Map<String, String> predefinedVarValues, int startCaretOffset) {
        if (template == null) {
            TemplateState.$$$reportNull$$$0(5);
        }
        LOG.assertTrue(!this.myStarted, (Object)"Already started");
        this.myStarted = true;
        PsiFile file = this.getPsiFile();
        this.setTemplate(template);
        this.myProcessor = processor;
        if (this.requiresWriteAction()) {
            this.myLiveTemplateProcessor.registerUndoableAction(this, this.myProject, this.getDocument());
        }
        this.myTemplateIndented = false;
        this.myCurrentVariableNumber = -1;
        this.setSegments(new TemplateSegments(this.getDocument()));
        this.myPrevTemplate = this.getTemplate();
        this.setPredefinedVariableValues(predefinedVarValues);
        if (this.getTemplate().isInline()) {
            int caretOffset = this.getCurrentCaretOffset(startCaretOffset);
            this.myTemplateRange = this.getDocument().createRangeMarker(caretOffset, caretOffset + this.getTemplate().getTemplateText().length());
        } else {
            this.preprocessTemplate(file, this.getCurrentCaretOffset(startCaretOffset), this.getTemplate().getTemplateText());
            int caretOffset = this.getCurrentCaretOffset(startCaretOffset);
            this.myTemplateRange = this.getDocument().createRangeMarker(caretOffset, caretOffset);
        }
        this.myTemplateRange.setGreedyToLeft(true);
        this.myTemplateRange.setGreedyToRight(true);
        this.myLiveTemplateProcessor.logTemplate(this.myProject, template, file.getLanguage());
        this.processAllExpressions(this.getTemplate());
    }

    private int getCurrentCaretOffset(int caretOffset) {
        Editor editor = this.getEditor();
        return editor != null ? editor.getCaretModel().getOffset() : caretOffset;
    }

    private void preprocessTemplate(PsiFile file, int caretOffset, String textToInsert) {
        for (TemplatePreprocessor preprocessor : TemplatePreprocessor.EP_NAME.getExtensionList()) {
            preprocessor.preprocessTemplate(this.getEditor(), file, caretOffset, textToInsert, this.getTemplate().getTemplateText());
        }
    }

    private void processAllExpressions(@NotNull TemplateImpl template) {
        if (template == null) {
            TemplateState.$$$reportNull$$$0(6);
        }
        Runnable action = () -> {
            if (!template.isInline()) {
                this.getDocument().insertString(this.myTemplateRange.getStartOffset(), (CharSequence)template.getTemplateText());
            }
            for (int i = 0; i < template.getSegmentsCount(); ++i) {
                int segmentOffset = this.myTemplateRange.getStartOffset() + template.getSegmentOffset(i);
                this.getSegments().addSegment(segmentOffset, segmentOffset);
            }
            LOG.assertTrue(this.myTemplateRange.isValid(), (Object)this.getRangesDebugInfo());
            this.calcResults(false);
            LOG.assertTrue(this.myTemplateRange.isValid(), (Object)this.getRangesDebugInfo());
            this.calcResults(false);
            LOG.assertTrue(this.myTemplateRange.isValid(), (Object)this.getRangesDebugInfo());
            this.doReformat();
            int nextVariableNumber = this.getNextVariableNumber(-1);
            if (nextVariableNumber >= 0) {
                this.fireWaitingForInput();
            }
            if (nextVariableNumber == -1) {
                if (this.requiresWriteAction()) {
                    this.myEventPublisher.templateStarted(this);
                }
                this.finishTemplate(false);
            } else {
                this.setCurrentVariableNumber(nextVariableNumber);
                if (this.isInteractiveModeSupported()) {
                    this.initTabStopHighlighters();
                    this.initListeners();
                }
                if (this.requiresWriteAction()) {
                    this.myEventPublisher.templateStarted(this);
                }
                this.focusCurrentExpression();
                this.fireCurrentVariableChanged(-1);
                if (!this.isInteractiveModeSupported()) {
                    this.finishTemplate(false);
                }
            }
        };
        this.performWrite(action);
    }

    private String getRangesDebugInfo() {
        return String.valueOf(this.myTemplateRange) + "\ntemplateKey: " + this.getTemplate().getKey() + "\ntemplateText: " + this.getTemplate().getTemplateText() + "\ntemplateString: " + String.valueOf(this.getTemplate());
    }

    private void doReformat() {
        Runnable action = () -> {
            IntList indices = this.initEmptyVariables();
            this.getSegments().setSegmentsGreedy(false);
            LOG.assertTrue(this.myTemplateRange.isValid(), (Object)("template key: " + this.getTemplate().getKey() + "; template text: " + this.getTemplate().getTemplateText() + "; variable number: " + this.getCurrentVariableNumber()));
            this.reformat();
            this.getSegments().setSegmentsGreedy(true);
            this.restoreEmptyVariables((List<Integer>)indices);
        };
        this.performWrite(action);
    }

    @ApiStatus.Internal
    public void performWrite(Runnable action) {
        if (this.requiresWriteAction()) {
            ApplicationManager.getApplication().runWriteAction(action);
        } else {
            action.run();
        }
    }

    public void setSegmentsGreedy(boolean greedy) {
        this.getSegments().setSegmentsGreedy(greedy);
    }

    public void setTabStopHighlightersGreedy(boolean greedy) {
        for (RangeHighlighter highlighter : this.myTabStopHighlighters) {
            highlighter.setGreedyToLeft(greedy);
            highlighter.setGreedyToRight(greedy);
        }
    }

    private void shortenReferences() {
        this.performWrite(() -> {
            PsiFile file = this.getPsiFile();
            if (file != null) {
                IntList indices = this.initEmptyVariables();
                this.getSegments().setSegmentsGreedy(false);
                for (TemplateOptionalProcessor processor : TemplateOptionalProcessor.EP_NAME.getExtensionList()) {
                    processor.processText(this.myProject, this.getTemplate(), this.getDocument(), this.myTemplateRange, this.getEditor());
                }
                this.getSegments().setSegmentsGreedy(true);
                this.restoreEmptyVariables((List<Integer>)indices);
            }
        });
    }

    private void afterChangedUpdate() {
        if (this.isFinished()) {
            return;
        }
        LOG.assertTrue(this.getTemplate() != null, (Object)TemplateState.presentTemplate(this.myPrevTemplate));
        if (this.myDocumentChanged) {
            if (this.myDocumentChangesTerminateTemplate || this.getSegments().isInvalid()) {
                this.cancelTemplate();
            } else {
                this.calcResults(true);
            }
            this.myDocumentChanged = false;
        }
    }

    private static String presentTemplate(@Nullable TemplateImpl template) {
        if (template == null) {
            return "no template";
        }
        Object message = StringUtil.notNullize((String)template.getKey());
        message = (String)message + "\n\nTemplate#name: " + StringUtil.notNullize((String)template.toString());
        message = (String)message + "\n\nTemplate#string: " + StringUtil.notNullize((String)template.getString());
        message = (String)message + "\n\nTemplate#text: " + StringUtil.notNullize((String)template.getTemplateText());
        return message;
    }

    private String getExpressionString(int index) {
        CharSequence text = this.getDocument().getCharsSequence();
        if (!this.getSegments().isValid(index)) {
            return "";
        }
        int start = this.getSegments().getSegmentStart(index);
        int end = this.getSegments().getSegmentEnd(index);
        return text.subSequence(start, end).toString();
    }

    private int getCurrentSegmentNumber() {
        int varNumber = this.myCurrentVariableNumber;
        if (varNumber == -1) {
            return -1;
        }
        String variableName = this.getTemplate().getVariableNameAt(varNumber);
        int segmentNumber = this.getTemplate().getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            Throwable trace = this.getTemplate().getBuildingTemplateTrace();
            LOG.error("No segment for variable: var=" + varNumber + "; name=" + variableName + "; " + TemplateState.presentTemplate(this.getTemplate()) + "; offset: " + this.getEditor().getCaretModel().getOffset(), new Attachment[]{CoreAttachmentFactory.createAttachment((Document)this.getDocument()), new Attachment("trace.txt", trace != null ? ExceptionUtil.getThrowableText((Throwable)trace) : "<empty>")});
        }
        return segmentNumber;
    }

    private void focusCurrentExpression() {
        if (this.isFinished() || this.isDisposed()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.getDocument());
        int currentSegmentNumber = this.getCurrentSegmentNumber();
        this.lockSegmentAtTheSameOffsetIfAny();
        if (currentSegmentNumber < 0) {
            return;
        }
        int start = this.getSegments().getSegmentStart(currentSegmentNumber);
        int end = this.getSegments().getSegmentEnd(currentSegmentNumber);
        if (end >= 0 && this.getEditor() != null) {
            if (this.getTemplate().isScrollToTemplate()) {
                this.getEditor().getCaretModel().moveToOffset(end);
                this.getEditor().getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
            this.getEditor().getSelectionModel().removeSelection();
            this.getEditor().getSelectionModel().setSelection(start, end);
        }
        DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> {
            Expression expressionNode = this.getCurrentExpression();
            LookupElement[] lookupItems = this.getCurrentExpressionLookupItems();
            PsiFile psiFile = this.getPsiFile();
            if (lookupItems.length != 0) {
                this.myLiveTemplateProcessor.runLookup(this, this.myProject, this.getEditor(), lookupItems, expressionNode);
            } else {
                try {
                    Result result = expressionNode.calculateResult(this.getCurrentExpressionContext());
                    if (result != null) {
                        result.handleFocused(psiFile, this.getDocument(), this.getSegments().getSegmentStart(currentSegmentNumber), this.getSegments().getSegmentEnd(currentSegmentNumber));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        });
        this.focusCurrentHighlighter(true);
    }

    @Nullable
    @ApiStatus.Internal
    public PsiFile getPsiFile() {
        return !this.isDisposed() ? PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getDocument()) : null;
    }

    @ApiStatus.Internal
    public boolean requiresWriteAction() {
        PsiFile file = this.getPsiFile();
        return file == null || file.isPhysical() || FORCE_TEMPLATE_RUNNING.isIn((UserDataHolder)file);
    }

    private LookupElement @NotNull [] getCurrentExpressionLookupItems() {
        LookupElement[] elements = null;
        try {
            elements = this.getCurrentExpression().calculateLookupItems(this.getCurrentExpressionContext());
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        if (elements == null) {
            if (LookupElement.EMPTY_ARRAY == null) {
                TemplateState.$$$reportNull$$$0(7);
            }
            return LookupElement.EMPTY_ARRAY;
        }
        if (elements == null) {
            TemplateState.$$$reportNull$$$0(8);
        }
        return elements;
    }

    public ExpressionContext getCurrentExpressionContext() {
        return this.createExpressionContext(this.getSegments().getSegmentStart(this.getCurrentSegmentNumber()));
    }

    public ExpressionContext getExpressionContextForSegment(int segmentNumber) {
        return this.createExpressionContext(this.getSegments().getSegmentStart(segmentNumber));
    }

    @NotNull
    private Expression getCurrentExpression() {
        Expression expression = this.getTemplate().getExpressionAt(this.myCurrentVariableNumber);
        if (expression == null) {
            TemplateState.$$$reportNull$$$0(9);
        }
        return expression;
    }

    private void unblockDocument() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.getDocument());
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.getDocument());
    }

    @ApiStatus.Internal
    public void update() {
        this.calcResults(false);
    }

    @ApiStatus.Internal
    public void calcResults(boolean isQuick) {
        String variableName;
        TextResult value;
        if (this.getSegments().isInvalid()) {
            this.gotoEnd(true);
        }
        if (this.myProcessor != null && this.myCurrentVariableNumber >= 0 && (value = this.getVariableValue(variableName = this.getTemplate().getVariableNameAt(this.myCurrentVariableNumber))) != null && !value.getText().isEmpty() && !this.myProcessor.process((Object)variableName, (Object)value.getText())) {
            this.finishTemplate(false);
            return;
        }
        this.fixOverlappedSegments(this.myCurrentSegmentNumber);
        Runnable action = () -> {
            if (this.isDisposed()) {
                return;
            }
            BitSet calcedSegments = new BitSet();
            int maxAttempts = (this.getTemplate().getVariableCount() + 1) * 3;
            do {
                --maxAttempts;
                calcedSegments.clear();
                for (int i = this.myCurrentVariableNumber + 1; i < this.getTemplate().getVariableCount(); ++i) {
                    String variableName = this.getTemplate().getVariableNameAt(i);
                    int segmentNumber = this.getTemplate().getVariableSegmentNumber(variableName);
                    if (segmentNumber < 0) continue;
                    Expression expression = this.getTemplate().getExpressionAt(i);
                    Expression defaultValue = this.getTemplate().getDefaultValueAt(i);
                    String oldValue = this.getVariableValueText(variableName);
                    DumbService.getInstance((Project)this.myProject).withAlternativeResolveEnabled(() -> this.recalcSegment(segmentNumber, isQuick, expression, defaultValue));
                    TextResult value = this.getVariableValue(variableName);
                    assert (value != null) : "name=" + variableName + "\ntext=" + this.getTemplate().getTemplateText();
                    String newValue = value.getText();
                    if (newValue.equals(oldValue)) continue;
                    calcedSegments.set(segmentNumber);
                }
                ArrayList<TemplateDocumentChange> changes = new ArrayList<TemplateDocumentChange>();
                boolean selectionCalculated = false;
                for (int i = 0; i < this.getTemplate().getSegmentsCount(); ++i) {
                    if (calcedSegments.get(i)) continue;
                    String variableName = this.getTemplate().getSegmentName(i);
                    if (variableName.equals("SELECTION")) {
                        if (this.mySelectionCalculated) continue;
                        selectionCalculated = true;
                    }
                    if ("END".equals(variableName)) continue;
                    String newValue = this.getVariableValueText(variableName);
                    int start = this.getSegments().getSegmentStart(i);
                    int end = this.getSegments().getSegmentEnd(i);
                    changes.add(new TemplateDocumentChange(newValue, start, end, i));
                }
                this.executeChanges(changes);
                if (!selectionCalculated) continue;
                this.mySelectionCalculated = true;
            } while (!calcedSegments.isEmpty() && maxAttempts >= 0);
        };
        if (this.requiresWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, null, null, (Runnable)action, (PsiFile[])new PsiFile[0]);
        } else {
            action.run();
        }
    }

    private void executeChanges(@NotNull List<TemplateDocumentChange> changes) {
        if (changes == null) {
            TemplateState.$$$reportNull$$$0(10);
        }
        if (this.isDisposed() || changes.isEmpty()) {
            return;
        }
        if (changes.size() > 1) {
            ContainerUtil.sort(changes, (o1, o2) -> {
                int startDiff = o2.startOffset - o1.startOffset;
                return startDiff != 0 ? startDiff : o2.segmentNumber - o1.segmentNumber;
            });
        }
        DocumentUtil.executeInBulk((Document)this.getDocument(), () -> {
            for (TemplateDocumentChange change : changes) {
                this.replaceString(change.newValue, change.startOffset, change.endOffset, change.segmentNumber);
            }
        });
    }

    private void fixOverlappedSegments(int currentSegment) {
        if (currentSegment >= 0) {
            int currentSegmentStart = this.getSegments().getSegmentStart(currentSegment);
            int currentSegmentEnd = this.getSegments().getSegmentEnd(currentSegment);
            for (int i = 0; i < this.getSegments().getSegmentsCount(); ++i) {
                int endOffset;
                if (i > currentSegment) {
                    int startOffset = this.getSegments().getSegmentStart(i);
                    if (currentSegmentStart > startOffset || startOffset >= currentSegmentEnd) continue;
                    this.getSegments().replaceSegmentAt(i, currentSegmentEnd, Math.max(this.getSegments().getSegmentEnd(i), currentSegmentEnd), true);
                    continue;
                }
                if (i >= currentSegment || currentSegmentStart >= (endOffset = this.getSegments().getSegmentEnd(i)) || endOffset > currentSegmentEnd) continue;
                this.getSegments().replaceSegmentAt(i, Math.min(this.getSegments().getSegmentStart(i), currentSegmentStart), currentSegmentStart, true);
            }
        }
    }

    @NotNull
    private String getVariableValueText(String variableName) {
        TextResult value = this.getVariableValue(variableName);
        return value != null ? value.getText() : "";
    }

    private void recalcSegment(int segmentNumber, boolean isQuick, Expression expressionNode, Expression defaultValue) {
        boolean resultIsNullOrEmpty;
        Result result;
        PsiFile psiFile;
        PsiElement element;
        boolean commitDocument;
        if (this.isDisposed()) {
            return;
        }
        String oldValue = this.getExpressionString(segmentNumber);
        int start = this.getSegments().getSegmentStart(segmentNumber);
        int end = this.getSegments().getSegmentEnd(segmentNumber);
        boolean bl = commitDocument = !isQuick || expressionNode.requiresCommittedPSI();
        if (commitDocument) {
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.getDocument());
        }
        PsiElement psiElement = element = (psiFile = this.getPsiFile()) != null ? psiFile.findElementAt(start) : null;
        if (element != null && commitDocument) {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
        ExpressionContext context = this.createExpressionContext(start);
        Result result2 = result = isQuick ? expressionNode.calculateQuickResult(context) : expressionNode.calculateResult(context);
        if (isQuick && result == null && !oldValue.isEmpty()) {
            return;
        }
        boolean bl2 = resultIsNullOrEmpty = result == null || result.equalsToText("", element);
        if (resultIsNullOrEmpty && this.myCurrentSegmentNumber >= 0 && (this.getSegments().getSegmentStart(segmentNumber) == this.getSegments().getSegmentEnd(this.myCurrentSegmentNumber) || this.getSegments().getSegmentEnd(segmentNumber) == this.getSegments().getSegmentStart(this.myCurrentSegmentNumber))) {
            return;
        }
        if (defaultValue != null && resultIsNullOrEmpty) {
            result = defaultValue.calculateResult(context);
        }
        if (element != null && commitDocument) {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
        if (result == null || result.equalsToText(oldValue, element)) {
            return;
        }
        this.replaceString(StringUtil.notNullize((String)result.toString()), start, end, segmentNumber);
        if (result instanceof RecalculatableResult) {
            RecalculatableResult recalc = (RecalculatableResult)result;
            IntList indices = this.initEmptyVariables();
            this.shortenReferences();
            PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.getDocument());
            recalc.handleRecalc(psiFile, this.getDocument(), this.getSegments().getSegmentStart(segmentNumber), this.getSegments().getSegmentEnd(segmentNumber));
            this.restoreEmptyVariables((List<Integer>)indices);
        }
    }

    private void replaceString(String newValue, int start, int end, int segmentNumber) {
        String oldText;
        TextRange range = TextRange.create((int)start, (int)end);
        if (!TextRange.from((int)0, (int)this.getDocument().getCharsSequence().length()).contains(range)) {
            LOG.error("Diagnostic for EA-54980. Can't extract " + String.valueOf(range) + " range. " + TemplateState.presentTemplate(this.getTemplate()), new Attachment[]{CoreAttachmentFactory.createAttachment((Document)this.getDocument())});
        }
        if (!(oldText = range.subSequence(this.getDocument().getCharsSequence()).toString()).equals(newValue)) {
            this.getSegments().setNeighboursGreedy(segmentNumber, false);
            this.getDocument().replaceString(start, end, (CharSequence)newValue);
            int newEnd = start + newValue.length();
            this.getSegments().replaceSegmentAt(segmentNumber, start, newEnd);
            this.getSegments().setNeighboursGreedy(segmentNumber, true);
            this.fixOverlappedSegments(segmentNumber);
        }
    }

    public int getCurrentVariableNumber() {
        return this.myCurrentVariableNumber;
    }

    public void previousTab() {
        if (this.isFinished()) {
            return;
        }
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int previousVariableNumber = this.getPreviousVariableNumber(oldVar);
        if (previousVariableNumber >= 0) {
            this.focusCurrentHighlighter(false);
            this.calcResults(false);
            this.doReformat();
            this.setCurrentVariableNumber(previousVariableNumber);
            this.focusCurrentExpression();
            this.fireCurrentVariableChanged(oldVar);
        }
    }

    public void nextTab() {
        if (this.isFinished()) {
            return;
        }
        if (this.getTemplate() == null) {
            LOG.error("Template disposed: " + String.valueOf(this.myPrevTemplate));
            return;
        }
        this.unblockDocument();
        this.myDocumentChangesTerminateTemplate = false;
        int oldVar = this.myCurrentVariableNumber;
        int nextVariableNumber = this.getNextVariableNumber(oldVar);
        if (nextVariableNumber == -1) {
            this.calcResults(false);
            ApplicationManager.getApplication().runWriteAction(() -> this.reformat());
            this.finishTemplate(false);
            return;
        }
        this.focusCurrentHighlighter(false);
        this.calcResults(false);
        this.doReformat();
        this.setCurrentVariableNumber(nextVariableNumber);
        this.focusCurrentExpression();
        this.fireCurrentVariableChanged(oldVar);
    }

    public void considerNextTabOnLookupItemSelected(LookupElement item) {
        TextRange range;
        if (this.isFinished()) {
            return;
        }
        if (item != null) {
            ExpressionContext context = this.getCurrentExpressionContext();
            for (TemplateCompletionProcessor processor : TemplateCompletionProcessor.EP_NAME.getExtensionList()) {
                if (processor.nextTabOnItemSelected(context, item)) continue;
                return;
            }
        }
        if ((range = this.getCurrentVariableRange()) != null && range.getLength() > 0) {
            int caret = this.getEditor().getCaretModel().getOffset();
            if (caret == range.getEndOffset() || this.isCaretInsideOrBeforeNextVariable()) {
                this.nextTab();
            } else if (caret > range.getEndOffset()) {
                this.gotoEnd(true);
            }
        }
    }

    private void lockSegmentAtTheSameOffsetIfAny() {
        this.getSegments().lockSegmentAtTheSameOffsetIfAny(this.getCurrentSegmentNumber());
    }

    private ExpressionContext createExpressionContext(final int start) {
        return new ExpressionContext(){

            public Project getProject() {
                return TemplateState.this.myProject;
            }

            public Editor getEditor() {
                return TemplateState.this.getEditor();
            }

            public int getStartOffset() {
                return start;
            }

            public int getTemplateStartOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getStartOffset();
            }

            public int getTemplateEndOffset() {
                if (TemplateState.this.myTemplateRange == null) {
                    return -1;
                }
                return TemplateState.this.myTemplateRange.getEndOffset();
            }

            public <T> T getProperty(Key<T> key) {
                return (T)TemplateState.this.getProperties().get(key);
            }

            @Nullable
            public PsiElement getPsiElementAtStartOffset() {
                Project project = this.getProject();
                int templateStartOffset = this.getTemplateStartOffset();
                int offset = templateStartOffset > 0 ? this.getTemplateStartOffset() - 1 : this.getTemplateStartOffset();
                Editor editor = this.getEditor();
                if (editor == null) {
                    return null;
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                return file == null ? null : file.findElementAt(offset);
            }

            public TextResult getVariableValue(String variableName) {
                return TemplateState.this.getVariableValue(variableName);
            }
        };
    }

    public void gotoEnd(boolean brokenOff) {
        if (this.isDisposed()) {
            return;
        }
        if (!this.getSegments().isInvalid()) {
            this.calcResults(false);
        }
        if (!brokenOff) {
            this.doReformat();
        }
        this.finishTemplate(brokenOff);
    }

    public void gotoEnd() {
        this.gotoEnd(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTemplate(boolean broken) {
        if (this.isDisposed()) {
            return;
        }
        Editor editor = this.getEditor();
        LookupManager instance = LookupManager.getInstance((Project)this.myProject);
        if (instance != null && !TemplateState.isPreviewEditor(editor)) {
            instance.hideActiveLookup();
        }
        this.setFinalEditorState(broken);
        try {
            this.fireBeforeTemplateFinished(broken);
        }
        finally {
            try {
                this.cleanupTemplateState();
                if (editor != null) {
                    TemplateManagerUtilBase.clearTemplateState(editor);
                }
                this.fireTemplateFinished(broken);
            }
            finally {
                Disposer.dispose((Disposable)this);
            }
        }
    }

    private static boolean isPreviewEditor(@Nullable Editor editor) {
        return IntentionPreviewUtils.getPreviewEditor() == editor;
    }

    private void setFinalEditorState(boolean brokenOff) {
        if (this.isDisposed()) {
            return;
        }
        if (this.getEditor() != null) {
            this.getEditor().getSelectionModel().removeSelection();
        }
        if (brokenOff && this.skipSettingFinalEditorState()) {
            return;
        }
        int endSegmentNumber = this.getFinalSegmentNumber();
        int offset = -1;
        if (endSegmentNumber >= 0) {
            offset = this.getSegments().getSegmentStart(endSegmentNumber);
        } else if (!this.getTemplate().isSelectionTemplate() && !this.getTemplate().isInline()) {
            offset = this.myTemplateRange.getEndOffset();
        }
        if (!this.isInteractiveModeSupported() && this.getCurrentVariableNumber() > -1) {
            offset = -1;
        }
        if (offset >= 0 && this.getTemplate().isScrollToTemplate()) {
            this.getEditor().getCaretModel().moveToOffset(offset);
            this.getEditor().getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        int selStart = this.getTemplate().getSelectionStartSegmentNumber();
        int selEnd = this.getTemplate().getSelectionEndSegmentNumber();
        if (selStart >= 0 && selEnd >= 0) {
            this.getEditor().getSelectionModel().setSelection(this.getSegments().getSegmentStart(selStart), this.getSegments().getSegmentStart(selEnd));
        }
    }

    private boolean skipSettingFinalEditorState() {
        return this.myLiveTemplateProcessor.skipSettingFinalEditorState(this.myProject);
    }

    @ApiStatus.Internal
    public void cancelTemplate() {
        if (this.isDisposed()) {
            return;
        }
        try {
            this.fireTemplateCancelled();
            this.cleanupTemplateState();
        }
        finally {
            Disposer.dispose((Disposable)this);
        }
    }

    private void cleanupTemplateState() {
        int oldVar = this.myCurrentVariableNumber;
        this.setCurrentVariableNumber(-1);
        this.fireCurrentVariableChanged(oldVar);
    }

    public boolean isLastVariable() {
        return this.getNextVariableNumber(this.getCurrentVariableNumber()) < 0;
    }

    private int getNextVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber + 1; i < this.getTemplate().getVariableCount(); ++i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private int getPreviousVariableNumber(int currentVariableNumber) {
        for (int i = currentVariableNumber - 1; i >= 0; --i) {
            if (!this.checkIfTabStop(i)) continue;
            return i;
        }
        return -1;
    }

    private boolean checkIfTabStop(int currentVariableNumber) {
        Expression expression = this.getTemplate().getExpressionAt(currentVariableNumber);
        if (this.myCurrentVariableNumber == -1 && this.getTemplate().skipOnStart(currentVariableNumber)) {
            return false;
        }
        String variableName = this.getTemplate().getVariableNameAt(currentVariableNumber);
        if ((this.getPredefinedVariableValues() == null || !this.getPredefinedVariableValues().containsKey(variableName)) && this.getTemplate().isAlwaysStopAt(currentVariableNumber)) {
            return true;
        }
        int segmentNumber = this.getTemplate().getVariableSegmentNumber(variableName);
        if (segmentNumber < 0) {
            return false;
        }
        int start = this.getSegments().getSegmentStart(segmentNumber);
        ExpressionContext context = this.createExpressionContext(start);
        Result result = expression.calculateResult(context);
        if (result == null) {
            return true;
        }
        LookupElement[] items = expression.calculateLookupItems(context);
        return items != null && items.length > 1;
    }

    private IntList initEmptyVariables() {
        int endSegmentNumber = this.getTemplate().getEndSegmentNumber();
        int selStart = this.getTemplate().getSelectionStartSegmentNumber();
        int selEnd = this.getTemplate().getSelectionEndSegmentNumber();
        IntArrayList indices = new IntArrayList();
        ArrayList<TemplateDocumentChange> changes = new ArrayList<TemplateDocumentChange>();
        block0: for (int i = 0; i < this.getTemplate().getSegmentsCount(); ++i) {
            int length = this.getSegments().getSegmentEnd(i) - this.getSegments().getSegmentStart(i);
            if (length != 0 || i == endSegmentNumber || i == selStart || i == selEnd) continue;
            String name = this.getTemplate().getSegmentName(i);
            for (int j = 0; j < this.getTemplate().getVariableCount(); ++j) {
                if (!this.getTemplate().getVariableNameAt(j).equals(name)) continue;
                Expression e = this.getTemplate().getExpressionAt(j);
                String marker = "a";
                if (e instanceof MacroCallNode) {
                    MacroCallNode macro = (MacroCallNode)e;
                    marker = macro.getMacro().getDefaultValue();
                }
                changes.add(new TemplateDocumentChange(marker, this.getSegments().getSegmentStart(i), this.getSegments().getSegmentEnd(i), i));
                indices.add(i);
                continue block0;
            }
        }
        this.executeChanges(changes);
        return indices;
    }

    private void initTabStopHighlighters() {
        HashSet<String> vars = new HashSet<String>();
        for (Variable variable : this.getTemplate().getVariables()) {
            int segmentNumber;
            String variableName = variable.getName();
            if (!vars.add(variableName) || (segmentNumber = this.getTemplate().getVariableSegmentNumber(variableName)) < 0) continue;
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(segmentNumber, variable, false, false);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
        int endSegmentNumber = this.getTemplate().getEndSegmentNumber();
        if (endSegmentNumber >= 0) {
            RangeHighlighter segmentHighlighter = this.getSegmentHighlighter(endSegmentNumber, null, false, true);
            this.myTabStopHighlighters.add(segmentHighlighter);
        }
    }

    private RangeHighlighter getSegmentHighlighter(int segmentNumber, @Nullable Variable var, boolean isSelected, boolean isEnd) {
        boolean newStyle = Registry.is((String)"live.templates.highlight.all.variables");
        boolean mightStop = this.mightStopAtVariable(var, segmentNumber);
        TextAttributesKey attributesKey = isEnd ? null : (isSelected ? EditorColors.LIVE_TEMPLATE_ATTRIBUTES : (newStyle && mightStop ? EditorColors.LIVE_TEMPLATE_INACTIVE_SEGMENT : null));
        int start = this.getSegments().getSegmentStart(segmentNumber);
        int end = this.getSegments().getSegmentEnd(segmentNumber);
        MarkupModelEx markupModel = (MarkupModelEx)this.getEditor().getMarkupModel();
        RangeHighlighterEx highlighter = markupModel.addRangeHighlighterAndChangeAttributes(attributesKey, start, end, 5499, HighlighterTargetArea.EXACT_RANGE, false, segmentHighlighter -> {
            segmentHighlighter.setGreedyToLeft(true);
            segmentHighlighter.setGreedyToRight(true);
            EditorColorsScheme scheme = this.getEditor().getColorsScheme();
            TextAttributes attributes = scheme.getAttributes(attributesKey);
            if (attributes != null && attributes.getEffectType() == EffectType.BOXED && newStyle) {
                TextAttributes clone = attributes.clone();
                clone.setEffectType(EffectType.SLIGHTLY_WIDER_BOX);
                clone.setBackgroundColor(scheme.getDefaultBackground());
                segmentHighlighter.setTextAttributes(clone);
            }
        });
        EditorActionAvailabilityHintKt.addActionAvailabilityHint((RangeHighlighter)highlighter, (EditorActionAvailabilityHint[])new EditorActionAvailabilityHint[]{new EditorActionAvailabilityHint("NextTemplateVariable", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside), new EditorActionAvailabilityHint("PreviousTemplateVariable", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside), new EditorActionAvailabilityHint("EditorEscape", EditorActionAvailabilityHint.AvailabilityCondition.CaretInside)});
        highlighter.putUserData(TEMPLATE_RANGE_HIGHLIGHTER_KEY, (Object)mightStop);
        return highlighter;
    }

    private boolean mightStopAtVariable(@Nullable Variable var, int segmentNumber) {
        if (var == null) {
            return false;
        }
        if (var.isAlwaysStopAt()) {
            return true;
        }
        return var.getDefaultValueExpression().calculateQuickResult(this.getExpressionContextForSegment(segmentNumber)) == null;
    }

    public void focusCurrentHighlighter(boolean toSelect) {
        if (this.isFinished()) {
            return;
        }
        if (this.myCurrentVariableNumber >= this.myTabStopHighlighters.size()) {
            return;
        }
        RangeHighlighter segmentHighlighter = this.myTabStopHighlighters.get(this.myCurrentVariableNumber);
        if (segmentHighlighter != null) {
            int segmentNumber = this.getCurrentSegmentNumber();
            RangeHighlighter newSegmentHighlighter = this.getSegmentHighlighter(segmentNumber, (Variable)((ArrayList)this.getTemplate().getVariables()).get(this.myCurrentVariableNumber), toSelect, false);
            segmentHighlighter.dispose();
            this.myTabStopHighlighters.set(this.myCurrentVariableNumber, newSegmentHighlighter);
        }
    }

    private void reformat() {
        PsiFile file = this.getPsiFile();
        if (file != null) {
            CodeStyleManager style = CodeStyleManager.getInstance((Project)this.myProject);
            for (TemplateOptionalProcessor processor : DumbService.getDumbAwareExtensions((Project)this.myProject, TemplateOptionalProcessor.EP_NAME)) {
                try {
                    processor.processText(this.myProject, this.getTemplate(), this.getDocument(), this.myTemplateRange, this.getEditor());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.getDocument());
            if (this.getTemplate().isToIndent() && !this.myTemplateIndented) {
                LOG.assertTrue(this.myTemplateRange.isValid(), (Object)TemplateState.presentTemplate(this.getTemplate()));
                this.smartIndent(this.myTemplateRange.getStartOffset(), this.myTemplateRange.getEndOffset());
                this.myTemplateIndented = true;
            }
            if (this.getTemplate().isToReformat()) {
                try {
                    PsiElement whiteSpaceElement;
                    int endSegmentNumber = this.getFinalSegmentNumber();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.getDocument());
                    RangeMarker dummyAdjustLineMarkerRange = null;
                    int endVarOffset = -1;
                    if (endSegmentNumber >= 0) {
                        endVarOffset = this.getSegments().getSegmentStart(endSegmentNumber);
                        TextRange range = this.myLiveTemplateProcessor.insertNewLineIndentMarker(file, this.getDocument(), endVarOffset);
                        if (range != null) {
                            dummyAdjustLineMarkerRange = this.getDocument().createRangeMarker(range);
                        }
                    }
                    int reformatStartOffset = this.myTemplateRange.getStartOffset();
                    int reformatEndOffset = this.myTemplateRange.getEndOffset();
                    if (dummyAdjustLineMarkerRange == null && endVarOffset >= 0 && (whiteSpaceElement = this.myLiveTemplateProcessor.findWhiteSpaceNode(file, endVarOffset)) != null) {
                        TextRange whiteSpaceRange = whiteSpaceElement.getTextRange();
                        if (whiteSpaceElement.getContainingFile() != null) {
                            whiteSpaceRange = InjectedLanguageManager.getInstance((Project)file.getProject()).injectedToHost(whiteSpaceElement, whiteSpaceRange);
                        }
                        reformatStartOffset = Math.min(reformatStartOffset, whiteSpaceRange.getStartOffset());
                        reformatEndOffset = Math.max(reformatEndOffset, whiteSpaceRange.getEndOffset());
                    }
                    style.reformatText(file, reformatStartOffset, reformatEndOffset);
                    this.unblockDocument();
                    if (dummyAdjustLineMarkerRange != null && dummyAdjustLineMarkerRange.isValid()) {
                        this.getSegments().replaceSegmentAt(endSegmentNumber, dummyAdjustLineMarkerRange.getStartOffset(), dummyAdjustLineMarkerRange.getEndOffset());
                        this.getDocument().deleteString(dummyAdjustLineMarkerRange.getStartOffset(), dummyAdjustLineMarkerRange.getEndOffset());
                        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.getDocument());
                    }
                    if (endSegmentNumber >= 0) {
                        int offset = this.getSegments().getSegmentStart(endSegmentNumber);
                        int lineStart = this.getDocument().getLineStartOffset(this.getDocument().getLineNumber(offset));
                        if (this.getDocument().getCharsSequence().subSequence(lineStart, offset).toString().trim().isEmpty()) {
                            int adjustedOffset = style.adjustLineIndent(file, offset);
                            this.getSegments().replaceSegmentAt(endSegmentNumber, adjustedOffset, adjustedOffset);
                        }
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    private int getFinalSegmentNumber() {
        int endSegmentNumber = this.getTemplate().getEndSegmentNumber();
        if (endSegmentNumber < 0 && this.getSelectionBeforeTemplate() == null) {
            endSegmentNumber = this.getTemplate().getVariableSegmentNumber("SELECTION");
        }
        return endSegmentNumber;
    }

    private void smartIndent(int startOffset, int endOffset) {
        char ch;
        int indentLineNum;
        int startLineNum = this.getDocument().getLineNumber(startOffset);
        int endLineNum = this.getDocument().getLineNumber(endOffset);
        if (endLineNum == startLineNum) {
            return;
        }
        int selectionIndent = -1;
        int selectionStartLine = -1;
        int selectionEndLine = -1;
        int selectionSegment = this.getTemplate().getVariableSegmentNumber("SELECTION");
        if (selectionSegment >= 0) {
            selectionIndent = 0;
            String templateText = this.getTemplate().getTemplateText();
            for (int selectionStart = this.getTemplate().getSegmentOffset(selectionSegment); selectionStart > 0 && templateText.charAt(selectionStart - 1) == ' '; --selectionStart) {
                ++selectionIndent;
            }
            selectionStartLine = this.getDocument().getLineNumber(this.getSegments().getSegmentStart(selectionSegment));
            selectionEndLine = this.getDocument().getLineNumber(this.getSegments().getSegmentEnd(selectionSegment));
        }
        int lineLength = 0;
        for (indentLineNum = startLineNum; indentLineNum >= 0 && (lineLength = this.getDocument().getLineEndOffset(indentLineNum) - this.getDocument().getLineStartOffset(indentLineNum)) <= 0; --indentLineNum) {
        }
        if (indentLineNum < 0) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        CharSequence text = this.getDocument().getCharsSequence();
        for (int i = 0; i < lineLength && ((ch = text.charAt(this.getDocument().getLineStartOffset(indentLineNum) + i)) == ' ' || ch == '\t'); ++i) {
            buffer.append(ch);
        }
        if (buffer.isEmpty() && selectionIndent <= 0 || startLineNum >= endLineNum) {
            return;
        }
        String stringToInsert = buffer.toString();
        int finalSelectionStartLine = selectionStartLine;
        int finalSelectionEndLine = selectionEndLine;
        int finalSelectionIndent = selectionIndent;
        DocumentUtil.executeInBulk((Document)this.getDocument(), () -> {
            for (int i = startLineNum + 1; i <= endLineNum; ++i) {
                if (i > finalSelectionStartLine && i <= finalSelectionEndLine) {
                    this.getDocument().insertString(this.getDocument().getLineStartOffset(i), (CharSequence)StringUtil.repeatSymbol((char)' ', (int)finalSelectionIndent));
                    continue;
                }
                this.getDocument().insertString(this.getDocument().getLineStartOffset(i), (CharSequence)stringToInsert);
            }
        });
    }

    public void addTemplateStateListener(TemplateEditingListener listener2) {
        this.myListeners.add(listener2);
    }

    private void fireTemplateFinished(boolean brokenOff) {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.templateFinished((Template)ObjectUtils.chooseNotNull((Object)this.getTemplate(), (Object)this.myPrevTemplate), brokenOff);
        }
    }

    private void fireBeforeTemplateFinished(boolean brokenOff) {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.beforeTemplateFinished(this, this.getTemplate(), brokenOff);
        }
    }

    private void fireWaitingForInput() {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.waitingForInput(this.getTemplate());
        }
    }

    private void fireTemplateCancelled() {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.templateCancelled(this.getTemplate());
        }
    }

    private void fireCurrentVariableChanged(int oldIndex) {
        for (TemplateEditingListener listener2 : this.myListeners) {
            listener2.currentVariableChanged(this, this.getTemplate(), oldIndex, this.myCurrentVariableNumber);
        }
        if (this.myCurrentSegmentNumber < 0 && this.myCurrentVariableNumber >= 0) {
            LOG.error("A variable with no segment: " + this.myCurrentVariableNumber + "; " + TemplateState.presentTemplate(this.getTemplate()));
        }
    }

    @Override
    public TemplateImpl getTemplate() {
        return (TemplateImpl)super.getTemplate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExpressionLookupItems";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installCaretListener";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processAllExpressions";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executeChanges";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private record TemplateDocumentChange(String newValue, int startOffset, int endOffset, int segmentNumber) {
    }
}

