/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit5.report;

import com.intellij.rt.execution.junit.MapSerializerUtil;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestPlan;

public final class ExecutionState {
    private final PrintStream myOut;
    private TestPlan myPlan;
    private long myCurrentTestStartNanos;
    private int myFinishCount;
    private String myRootName;
    private String myPresentableName;
    private boolean mySuccessful = true;
    private String myIdSuffix = "";
    private boolean mySendTree;

    public ExecutionState(PrintStream out) {
        this.myOut = out;
    }

    public void setPlan(TestPlan plan) {
        this.myPlan = plan;
    }

    public TestPlan plan() {
        return this.myPlan;
    }

    public void print(String line) {
        this.myOut.println(line);
    }

    public boolean wasSuccessful() {
        return this.mySuccessful;
    }

    public void updateSuccessful(TestExecutionResult.Status status) {
        this.mySuccessful &= status == TestExecutionResult.Status.SUCCESSFUL;
    }

    public void initializeIdSuffix(boolean forked) {
        if (forked && this.myIdSuffix.isEmpty()) {
            this.myIdSuffix = String.valueOf(System.currentTimeMillis());
        }
    }

    public void initializeIdSuffix(int i) {
        this.myIdSuffix = i + "th";
    }

    public String suffix() {
        return this.myIdSuffix;
    }

    public void setRootName(String rootName) {
        this.myRootName = rootName;
    }

    public String getRootName() {
        return this.myRootName;
    }

    public void setPresentableName(String presentableName) {
        this.myPresentableName = presentableName;
    }

    public String getPresentableName() {
        return this.myPresentableName;
    }

    public void setSendTree(boolean sendTree) {
        this.mySendTree = sendTree;
    }

    public boolean isSendTree() {
        return this.mySendTree;
    }

    public void onLeafTestStarted() {
        this.myCurrentTestStartNanos = System.nanoTime();
    }

    public long onLeafTestFinishedAndGetDurationMs() {
        return (System.nanoTime() - this.myCurrentTestStartNanos) / 1000000L;
    }

    public void resetFinishCount() {
        this.myFinishCount = 0;
    }

    public void incrementFinishCount() {
        ++this.myFinishCount;
    }

    public int finishCount() {
        return this.myFinishCount;
    }

    public void printRootNameIfNeeded() {
        if (this.myRootName == null) {
            return;
        }
        int lastPointIdx = this.myRootName.lastIndexOf(46);
        String name = this.myRootName;
        String comment = null;
        if (lastPointIdx >= 0) {
            name = this.myRootName.substring(lastPointIdx + 1);
            comment = this.myRootName.substring(0, lastPointIdx);
        }
        String messageName = this.myPresentableName == null || this.myPresentableName.isEmpty() ? name : this.myPresentableName;
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("name", messageName);
        if (comment != null) {
            attrs.put("comment", comment);
        }
        attrs.put("location", "java:suite://" + this.myRootName);
        this.print(MapSerializerUtil.asString((String)"rootName", attrs));
    }
}

