/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.impl;

import com.jediterm.terminal.TextStyle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.session.impl.StyleRange;
import org.jetbrains.plugins.terminal.view.TerminalLineIndex;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;
import org.jetbrains.plugins.terminal.view.impl.MutableTerminalOutputModel;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a \u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0006*\u00020\u0007H\u0002\u001a\u0011\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e*\u00020\u0002H\u0002\u001a\u0011\u0010\u000f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e*\u00020\u0002H\u0002\u00a8\u0006\u0010"}, d2={"predictTextStyleForTypingAt", "Lcom/jediterm/terminal/TextStyle;", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "offset", "Lorg/jetbrains/plugins/terminal/view/TerminalOffset;", "insertAtCursor", "", "Lorg/jetbrains/plugins/terminal/view/impl/MutableTerminalOutputModel;", "string", "", "style", "backspace", "getRemainingLinePart", "", "Lcom/intellij/openapi/util/NlsSafe;", "getTextAfterCursor", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalTypeAheadOutputModelController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalTypeAheadOutputModelController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelControllerKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,283:1\n1107#2,2:284\n1#3:286\n*S KotlinDebug\n*F\n+ 1 TerminalTypeAheadOutputModelController.kt\ncom/intellij/terminal/frontend/view/impl/TerminalTypeAheadOutputModelControllerKt\n*L\n236#1:284,2\n*E\n"})
public final class TerminalTypeAheadOutputModelControllerKt {
    private static final TextStyle predictTextStyleForTypingAt(TerminalOutputModel $this$predictTextStyleForTypingAt, TerminalOffset offset) {
        HighlightingInfo highlighting;
        boolean bl;
        TerminalOffset previousOffset;
        block4: {
            TerminalLineIndex lineIndex = $this$predictTextStyleForTypingAt.getLineByOffset(offset);
            TerminalOffset lineStartOffset = $this$predictTextStyleForTypingAt.getStartOfLine(lineIndex);
            if (Intrinsics.areEqual((Object)offset, (Object)lineStartOffset) || Intrinsics.areEqual((Object)offset, (Object)$this$predictTextStyleForTypingAt.getStartOffset())) {
                return null;
            }
            previousOffset = offset.minus(1L);
            String textBefore = ((Object)$this$predictTextStyleForTypingAt.getText(previousOffset, offset)).toString();
            CharSequence $this$any$iv = textBefore;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(!Character.isLetterOrDigit(it))) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        HighlightingInfo highlightingInfo = highlighting = $this$predictTextStyleForTypingAt.getHighlightingAt(previousOffset);
        TextAttributesProvider textAttributesProvider = highlightingInfo != null ? highlightingInfo.getTextAttributesProvider() : null;
        TextStyleAdapter textStyleAdapter = textAttributesProvider instanceof TextStyleAdapter ? (TextStyleAdapter)textAttributesProvider : null;
        if (textStyleAdapter == null) {
            return null;
        }
        TextStyleAdapter textStyleAdapter2 = textStyleAdapter;
        return textStyleAdapter2.getStyle();
    }

    private static final void insertAtCursor(MutableTerminalOutputModel $this$insertAtCursor, String string, TextStyle style) {
        $this$insertAtCursor.withTypeAhead((Function0<Unit>)((Function0)() -> TerminalTypeAheadOutputModelControllerKt.insertAtCursor$lambda$0($this$insertAtCursor, string, style)));
    }

    static /* synthetic */ void insertAtCursor$default(MutableTerminalOutputModel mutableTerminalOutputModel, String string, TextStyle textStyle, int n, Object object) {
        if ((n & 2) != 0) {
            textStyle = null;
        }
        TerminalTypeAheadOutputModelControllerKt.insertAtCursor(mutableTerminalOutputModel, string, textStyle);
    }

    private static final void backspace(MutableTerminalOutputModel $this$backspace) {
        TerminalOffset offset = $this$backspace.getCursorOffset();
        if (offset.compareTo($this$backspace.getStartOffset()) <= 0) {
            return;
        }
        TerminalOffset replaceOffset = offset.minus(1L);
        $this$backspace.replaceContent(replaceOffset, 1, " ", CollectionsKt.emptyList());
        $this$backspace.updateCursorPosition(replaceOffset);
    }

    private static final CharSequence getRemainingLinePart(TerminalOutputModel $this$getRemainingLinePart) {
        TerminalOffset cursorOffset = $this$getRemainingLinePart.getCursorOffset();
        TerminalLineIndex line = $this$getRemainingLinePart.getLineByOffset(cursorOffset);
        TerminalOffset lineEnd = TerminalOutputModel.getEndOfLine$default($this$getRemainingLinePart, line, false, 2, null);
        CharSequence remainingLinePart = $this$getRemainingLinePart.getText(cursorOffset, lineEnd);
        return remainingLinePart;
    }

    private static final CharSequence getTextAfterCursor(TerminalOutputModel $this$getTextAfterCursor) {
        TerminalOffset cursorOffset = $this$getTextAfterCursor.getCursorOffset();
        return $this$getTextAfterCursor.getText(cursorOffset, $this$getTextAfterCursor.getEndOffset());
    }

    private static final Unit insertAtCursor$lambda$0(MutableTerminalOutputModel $this_insertAtCursor, String $string, TextStyle $style) {
        StyleRange styleRange;
        CharSequence remainingLinePart = TerminalTypeAheadOutputModelControllerKt.getRemainingLinePart($this_insertAtCursor);
        int replaceLength = RangesKt.coerceAtMost((int)$string.length(), (int)remainingLinePart.length());
        TerminalOffset replaceOffset = $this_insertAtCursor.getCursorOffset();
        TextStyle textStyle = $style;
        if (textStyle != null) {
            TextStyle it = textStyle;
            boolean bl = false;
            styleRange = new StyleRange(0L, $string.length(), it, false);
        } else {
            styleRange = null;
        }
        StyleRange styleRange2 = styleRange;
        $this_insertAtCursor.replaceContent(replaceOffset, replaceLength, $string, CollectionsKt.listOfNotNull((Object)styleRange2));
        TerminalOffset newCursorOffset = (TerminalOffset)RangesKt.coerceAtMost((Comparable)TerminalOffset.Companion.of(replaceOffset.toAbsolute() + (long)$string.length()), (Comparable)$this_insertAtCursor.getEndOffset());
        $this_insertAtCursor.updateCursorPosition(newCursorOffset);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CharSequence access$getTextAfterCursor(TerminalOutputModel $receiver) {
        return TerminalTypeAheadOutputModelControllerKt.getTextAfterCursor($receiver);
    }

    public static final /* synthetic */ TextStyle access$predictTextStyleForTypingAt(TerminalOutputModel $receiver, TerminalOffset offset) {
        return TerminalTypeAheadOutputModelControllerKt.predictTextStyleForTypingAt($receiver, offset);
    }

    public static final /* synthetic */ void access$insertAtCursor(MutableTerminalOutputModel $receiver, String string, TextStyle style) {
        TerminalTypeAheadOutputModelControllerKt.insertAtCursor($receiver, string, style);
    }

    public static final /* synthetic */ void access$backspace(MutableTerminalOutputModel $receiver) {
        TerminalTypeAheadOutputModelControllerKt.backspace($receiver);
    }
}

