/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.nlp.similarity.Levenshtein;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.WordSet;
import ai.grazie.rules.en.AgreementSet;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.NonProgressive;
import ai.grazie.rules.en.Number;
import ai.grazie.rules.en.PassiveToActive;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.en.SubjectVerbAgreement;
import ai.grazie.rules.en.ToggleContraction;
import ai.grazie.rules.en.UnexpectedVerb;
import ai.grazie.rules.en.VerbInflectionNumber;
import ai.grazie.rules.en.WordConfusion;
import ai.grazie.rules.en.WordSeparation;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class AuxMainVerbForm {
    private static final NodePattern possiblyFinite = NodePattern.N.potentialPos("VB[PZD]");
    private static final NodePattern surpriseThat = NodePattern.N.lemma("surprise").withDependent("ccomp");
    private static final NodePattern goingTo = NodePattern.N.lemma("go").directlyBefore(NodePattern.N.form("to"));
    private static final NodePattern beforeContractedNot = NodePattern.N.noSpaceAfter().directlyBefore(EnglishTreePatterns.negation);
    private static final NodePattern auxCcAux = NodePattern.N.and(CommonPatterns.possiblySkipDown("advmod", NodePattern.N.withDependent("cc", NodePattern.N.after("FirstAux").markAs("CC")))).withDependent("cop|aux|aux:pass", NodePattern.N.after("CC"));
    private static final NodePattern suggestHaveTo = NodePattern.N.pos("VB").markAs("Predicate").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("PRP|NNP")).withDependent("aux", NodePattern.N.form("have|has|had").directlyBefore("Predicate")).noDependents("aux", NodePattern.N.lemma("should|must"));
    private static final NodePattern baseFormVerb = NodePattern.N.potentialPos("VB|MD").noDependents("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case");
    private static final NodePattern wordInternalPunctuation = NodePattern.N.form("\\p{L}+\\p{P}+\\p{L}+").noForm("\\p{L}+['\u2019`\u2018]+\\p{L}+");
    private static final NodePattern wendWentTypo = NodePattern.N.form("wend").and(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj.*")));
    private static final NodePattern suggestOnlyPassive = NodePattern.or(PassiveToActive.hasPassiveLikeArguments, NodePattern.N.withDependent("nsubj:pass").withDependent("aux:pass").and(CommonPatterns.possiblySkipDown("aux:pass", NodePattern.N.withDependent("aux"))), NodePattern.N.withDependent("conj", NodePattern.N.pos("VBN").noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl|cop|aux|aux:pass")));
    private static final NodePattern skipBaseFormSuggestion = NodePattern.or(NodePattern.N.lemma("will"), EnglishValences.definitelyTransitive.noDependents("obj"), suggestOnlyPassive.pos("VBN"));
    private static final NodePattern mainHaveVerb = NodePattern.N.form("have").andOr(NodePattern.N.withDependent("obj"), NodePattern.N.withDependent("xcomp", EnglishTreePatterns.withToMark));
    private static final NodePattern beTypo = NodePattern.N.withHeadRelation("cop|aux:pass|mark|nsubj").noPos("VB.*").andNot(NodePattern.N.form("[hw]e").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("will")))).and(n -> Levenshtein.INSTANCE.distance(n.lowForm(), "be") == 1);
    private static final NodePattern beenTypo = NodePattern.or(NodePattern.N.withHeadRelation("cop|aux.*|obj"), NodePattern.N.withDependent("aux", NodePattern.N.lemma("have"))).noPos("VB.*").and(n -> Levenshtein.INSTANCE.distance(n.lowForm(), "been") == 1);
    private static final NodePattern toCopulaSubject = NodePattern.N.form("solution|option|strategy|tactics|approach|idea|thing|step");
    private static final NodePattern suggestGerundAfterBe = NodePattern.or(NodePattern.N.noLemma("be"), NodePattern.N.form("be.*").withHead("cop|aux|aux:pass", NodePattern.N.pos("VBN")));
    static final String INCOMPATIBLE_VERB_FORMS = "Incompatible verb forms";
    private static final NodePattern subjectObjectDuplication = NodePattern.N.withDependent("obj", NodePattern.N.markAs("Obj")).withDependent("nsubj:pass", NodePattern.N.sameWordAs("Obj"));
    private final List<Node> auxVerbs;
    private final Map<Node, Integer> indices = new HashMap<Node, Integer>();
    private final Node predicate;
    @Nullable
    private final Node subject;
    private static final NodePattern withLastAuxContracted = NodePattern.N.withDependent("aux", EnglishTreePatterns.startsWithApostrophe.markAs("Contracted")).noDependents("aux", NodePattern.N.after("Contracted"));
    private static final NodePattern possibleVerbEllipsis = NodePattern.or(NodePattern.N.withDependent(".*", NodePattern.N.form("so|neither|than")), NodePattern.N.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?").withHeadRelation("conj"), NodePattern.N.withHeadRelation("advcl").andOr(NodePattern.N.withDependent("mark", NodePattern.N.form("than")), NodePattern.N.lemma("do")), NodePattern.N.withDependent("aux").potentialPos("NNS").withHead(NodePattern.N.withHeadRelation("obl").withPrevSibling(NodePattern.N.withHeadRelation("obj"))), NodePattern.N.pos("VB[GN]").afterHead().andOr(NodePattern.N.withDependent("mark", NodePattern.N.form("as")), NodePattern.N.withHeadRelation("acl:relcl"), NodePattern.N.withHeadRelation("advcl").withPrevSibling(NodePattern.N.pos("NN.*"))).andNot(withLastAuxContracted).andNot(NodePattern.N.pos("VBD").withDependent("aux", NodePattern.N.form("do")).noDependents("mark", NodePattern.N.form("as"))));
    private static final NodePattern baseAntipatterns = NodePattern.or(possibleVerbEllipsis, NodePattern.N.withDependent("aux", NodePattern.or(WordConfusion.wontWant, NodePattern.N.inFormSequence(0, "must", "needs").withNeighbor(2, NodePattern.N.pos("VB")))), NodePattern.N.directlyAfter(NodePattern.N.pos("DT").withHeadRelation("nsubj")).withDependent("ccomp"));
    private static final NodePattern couldBePassiveParticiple = NodePattern.N.potentialPos("VBN").noForm("come|become|been").andNot(NodePattern.N.form("overcome").withDependent("obj"));
    private static final NodePattern possibleCopulaHead = NodePattern.N.potentialPos("NN.*|JJ.*|RB.*").andNot(EnglishTreePatterns.unlikelyToBeNoun).andNot(PassiveToActive.hasPassiveLikeArguments.form("cause")).noDependents("advmod", NodePattern.N.form("recently|completely|yet"));
    private static final NodePattern withImperativeAllowingSubject = NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.or(NodePattern.or(NodePattern.N.form("all|what|(any|every)?thing"), NodePattern.N.noPos()).withDependent("acl:relcl"), NodePattern.N.pos("NNP?").withDependent("det", NodePattern.N.form("all"))));
    private static final NodePattern beAntipatterns = NodePattern.or(withImperativeAllowingSubject, NodePattern.N.lemma("be").withHead("cop", withImperativeAllowingSubject), EnglishTreePatterns.itsConfusion, EnglishTreePatterns.imperativePossible, EnglishTreePatterns.vbAposS, couldBePassiveParticiple.withDependent("cop|aux|aux:pass"), NodePattern.N.withDependent("case"), possibleCopulaHead.noDependents("advmod", EnglishTreePatterns.negation.before("Aux")), EnglishTreePatterns.unlikelyToBeVerb, NodePattern.markedNodeMatches("Aux", NodePattern.or(NodePattern.N.directlyAfter(CommonPatterns.noSpaceHyphen), WordSeparation.mayBe, EnglishTreePatterns.clausalCopula, EnglishTreePatterns.startsWithApostrophe.and(ToggleContraction.possiblyContractedDoes), WordConfusion.wereWeTypo, CommonPatterns.firstChildPhrase.withHead("cop", NodePattern.or(NodePattern.N.withHeadRelation("parataxis|ccomp|csubj"), NodePattern.N.withHeadRelation("acl:relcl").and(CommonPatterns.severalDependents("cop")))).trace("misattached cop"))));
    private static final NodePattern beModalAntipatterns = NodePattern.or(NodePattern.N.directlyBefore(CommonPatterns.HYPHEN_NODE), NodePattern.N.withHeadRelation("cop|aux|aux:pass").and(NodePattern.markedNodeMatches("Be", NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("det")))), NodePattern.markedNodeMatches("Be", NodePattern.or(NodePattern.N.directlyBefore(NodePattern.N.pos("JJ.*").withHeadRelation("amod")), EnglishTreePatterns.clausalCopula)));
    private static final NodePattern misparsedCompound = WordSeparation.nounLikeGerund.directlyBefore(NodePattern.N.pos("NN.*").directlyAfterHead());
    private static final NodePattern haveAntipatterns = NodePattern.or(NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.N.withDependent("aux", NodePattern.N.form("have|has|had")).noDependents("cop|aux|aux:pass", NodePattern.N.before("Aux")).withHeadRelation("acl:relcl").withDependent("nsubj").noDependents("i?obj")), NodePattern.N.directlyAfter(NodePattern.N.form("to")), NodePattern.markedNodeMatches("Aux", NodePattern.N.directlyBefore(NodePattern.N.form("to"))), NodePattern.N.withHead("acl:relcl", NodePattern.ROOT.andNot(EnglishTreePatterns.clause)), NodePattern.N.potentialPos("JJ").noDependents("obj").directlyAfter("Aux"), NodePattern.N.pos("VBP?").andOr(NodePattern.N.directlyAfter(NodePattern.N.pos("NN.*")).trace("have somebody do something"), NodePattern.N.markAs("Base").withHead("cop|aux|aux:pass", NodePattern.N.withDependent("mark", NodePattern.N.form("to").between("Aux", "Base"))).trace("Y have to be VBed")), NodePattern.N.potentialPos("JJR").withDependent("obj"), NodePattern.N.form("ringed"), misparsedCompound, EnglishTreePatterns.verbsMissingNounPosTags.noForm("do").noDependents("obj"), NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.form("that|who|which")), NodePattern.N.withDependent("advmod", NodePattern.N.form("better")), NodePattern.N.potentialPos("NN.*").directlyBefore(NodePattern.N.pos("CD")), NodePattern.N.markAs("Next").withDependent("discourse", NodePattern.N.between("Aux", "Next")), NodePattern.N.withHead("cop|aux|aux:pass", withImperativeAllowingSubject), NodePattern.N.inFormSequence(0, "double", "the"));
    private static final NodePattern beDoAntiPatterns = NodePattern.or(WordSeparation.mayBe, NodePattern.N.withHead("cop|aux|aux:pass", NodePattern.N.withDependent(".*", Questions.whWord)), EnglishTreePatterns.clausalCopula);
    private static final NodePattern possiblePlural = EnglishTreePatterns.apostropheS.directlyAfter(CommonPatterns.upperCase);
    static final NodePattern nonPassive = NodePattern.or(NodePattern.N.lemma("go|seem|keep|try|occur|happen|arise|exist|result|belong|differ|talk"), NodePattern.N.lemma("lack|suffer"), NodePattern.N.lemma("disappear|work"), NodePattern.N.lemma("begin"), NodePattern.N.lemma("consist").withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("of"))), NodePattern.N.lemma("depend").noDependents("obl", NodePattern.N.form("(up)?on").noDependents()), NodePattern.N.lemma("agree").noDependents("nsubj.*", NodePattern.N.form("it")), NodePattern.N.lemma("know").noDependents("nsubj.*|expl", NodePattern.N.form("it")).noDependents("obl").noDependents("xcomp|advcl", EnglishTreePatterns.withToMark), NodePattern.N.lemma("forget|tend").withDependent("advcl|xcomp", EnglishTreePatterns.withToMark));
    private static final NodePattern avoidActive = NodePattern.or(goingTo, NodePattern.N.lemma("know|seem").noDependents("ccomp|obj|expl"), surpriseThat, Semantics.useSupposeTo, Semantics.rareIntransitiveMeaning, NonProgressive.useFor, EnglishValences.lacksObligatoryArguments, NodePattern.N.withDependent("nsubj:pass", NodePattern.N.markAs("Subj")).and(SemCompatibility.Unlikely.between(SemCompatibility.Relation.Subject, NodePointer.anchor(), NodePointer.marked("Subj"))));
    private static final NodePattern suggestBeAux = NodePattern.or(NodePattern.N.pos("VBG|JJ.*").noDependents("conj", NodePattern.N.noPos("VBG|JJ.*")), NodePattern.N.potentialPos("VBN").and(EnglishValences.definitelyTransitive));
    private static final NodePattern suggestNounCopulaHeads = NodePattern.N.withDependent("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case").noDependents("obj");
    private static final NodePattern onlyCopulaSuggestions = NodePattern.or(EnglishTreePatterns.unlikelyToBeVerb, NodePattern.N.withDependent("obl", NodePattern.N.withDependent("case", NodePattern.N.form("than"))), NodePattern.N.withDependent("nmod(:poss)?|det|nummod|acl(:relcl)?|compound|amod|case"));
    static final Map<String, List<String>> verbsToAdjectives = WordSet.multiValueMap(WordSet.loadLines("en/words/verbs_to_adjectives.txt"));
    private static final NodePattern noDirectObject = NodePattern.N.noDependents("xcomp", NodePattern.N.pos("NN.*").andNot(EnglishTreePatterns.clause)).andNot(CommonPatterns.possiblySkipDown("obl", NodePattern.N.withDependent("i?obj", NodePattern.or(NodePattern.N.afterHead(), NodePattern.N.form("what|which").withHead(NodePattern.N.noDependents("nsubj:pass"))))));
    private static final NodePattern toAmodCopula = NodePattern.N.directlyBefore(NodePattern.N.pos("NN.*").withHeadRelation("i?obj")).directlyAfter(NodePattern.N.withHeadRelation("advmod")).withDependent("cop");

    AuxMainVerbForm(List<Node> auxVerbs, Node predicate) {
        this.auxVerbs = auxVerbs;
        this.predicate = predicate;
        Node subject = EnglishTreePatterns.findSubject(predicate);
        this.subject = subject != null ? subject : (predicate.hasHeadRelation("conj") ? EnglishTreePatterns.findSubject(Objects.requireNonNull(predicate.head())) : null);
        for (int i = 0; i < auxVerbs.size(); ++i) {
            this.indices.put(auxVerbs.get(i), i);
        }
        this.indices.put(predicate, auxVerbs.size());
    }

    private Node next(Node aux) {
        int index = this.indices.get(aux);
        return index == this.auxVerbs.size() - 1 ? this.predicate : this.auxVerbs.get(index + 1);
    }

    static NodePattern pattern() {
        return NodePattern.or(AuxMainVerbForm.auxCompatibility().trace("auxCompatibility"), AuxMainVerbForm.haveComp().trace("haveComp"), AuxMainVerbForm.haveBee().trace("haveBee"), AuxMainVerbForm.beVb().trace("beVB"), AuxMainVerbForm.canHas().trace("canHas"));
    }

    private static NodePattern beVb() {
        return NodePattern.N.pos("NN").potentialPos("VB").withDependent("cop", NodePattern.N.form("be").directlyBeforeHead().includeIntoReport().markAs("Be")).withDependent("aux", EnglishTreePatterns.baseAux.markAs("Aux")).noDependents("aux", NodePattern.N.after("Aux")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.markAs("Subj")).and((pred, match) -> {
            Node subj = match.getMarkedNode("Subj");
            Node vbPred = pred.copyWithForm(pred.form(), List.of(new Tree.Reading("VB", pred.lowForm())));
            return SemCompatibility.forSubject(pred, subj) == SemCompatibility.Unlikely && SemCompatibility.forSubject(vbPred, subj) == SemCompatibility.Likely ? match : null;
        }).includeIntoReport().correct(NodeCorrector.replace(NodePointer.marked("Be"), "")).message(INCOMPATIBLE_VERB_FORMS);
    }

    private static NodePattern haveBee() {
        return NodePattern.N.lemma("have").andOr(NodePattern.N.withDependent("obj", NodePattern.N.directlyAfterHead().and(beenTypo).markAs("Been")), NodePattern.N.withHead("aux", beenTypo.markAs("Been").noDependents("case|nmod.*|det"))).and(NodePattern.markedNodeMatches("Been", EnglishTreePatterns.typoReplacement("been")));
    }

    private static NodePattern canHas() {
        return NodePattern.or(NodePattern.N.pos("VBZ").noHeadRelation("discourse").andNot(NodePattern.N.inFormSequence(1, "must", "needs")), NodePattern.N.pos("VB[DN]").noPotentialPos("VB").noHeadRelation("amod|advcl")).noHeadRelation("cop|aux|aux:pass").directlyAfter(NodePattern.N.form("can|could|may|might|will|would|shall|should|must").andOr(NodePattern.N.pos("VB.?"), NodePattern.N.pos("MD").noPos("NN")).andNot(NodePattern.N.directlyAfter(NodePattern.N.pos("DT"))).andNot(EnglishTreePatterns.mayName).andNot(CommonPatterns.capitalizedMiddle)).andOr(NodePattern.N.lemma("have").directlyBefore(NodePattern.N.form("to")).directlyAfter(NodePattern.N.form("can")).correct(NodeCorrector.removeNodes(NodePointer.anchor(), NodePointer.neighbor(1))), NodePattern.N.correct(NodeCorrector.inflect("VBP")).andOptionally(NodePattern.N.pos("VBN").andOr(NodePattern.N.noDependents("i?obj|obl").andNot(NodePattern.N.withHead("acl:relcl", NodePattern.N.withHeadRelation("obl"))), NodePattern.N.withDependent("aux:pass")).correct(NodeCorrector.insertBefore("be ")))).message(INCOMPATIBLE_VERB_FORMS);
    }

    private static NodePattern auxCompatibility() {
        NodePattern possiblyMainDo = NodePattern.N.markAs("Finite").withDependent("aux", NodePattern.N.lemma("do").markAs("Do")).noDependents("nsubj", NodePattern.N.between("Do", "Finite")).noDependents("advmod", EnglishTreePatterns.negation).noDependents("xcomp").andOr(NodePattern.N.withDependent("advmod", NodePattern.N.pos("RB.*").between("Do", "Finite")), NodePattern.N.noDependents("i?obj", NodePattern.N.afterHead()), NodePattern.N.withHead("acl:relcl", CommonPatterns.skipUp("nmod", NodePattern.ROOT))).potentialPos("NN.*|VBG");
        NodePattern willAmbiguity = NodePattern.N.inFormSequence(1, "at", "will");
        return NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.markAs("FirstAux")).noDependents("cop|aux|aux:pass", NodePattern.or(CommonPatterns.capitalizedMiddle, EnglishTreePatterns.wordSlashWord, CommonPatterns.quotedWord, willAmbiguity, NodePattern.N.afterHead(), EnglishTreePatterns.afterAposOrQuote, EnglishTreePatterns.beforeAposOrQuote, NodePattern.N.noPotentialPos("VB.*|MD").noForm("ca|wo").andNot(beTypo).andNot(beenTypo))).andNot(auxCcAux).andOr(NodePattern.N.noPos("VB.*"), NodePattern.not(CommonPatterns.capitalizedMiddle)).andNot(possiblyMainDo).noDependents("acl:relcl|compound|nummod").andNot(NodePattern.N.pos("VBN").withDependent("obl:npmod", NodePattern.N.potentialPos("VBP?")).directlyBefore(NodePattern.N.pos("NN.*"))).andNot(NodePattern.N.inFormSequence(0, "fed", "ex")).andNot(NodePattern.N.withDependent("expl").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?").and(CommonPatterns.severalDependents("cop"))).andNot(NodePattern.N.pos("VBG").andOr(NodePattern.not(CommonPatterns.possiblyConj(NodePattern.N.withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl"))), NodePattern.N.anyMatchUntil("FirstAux", CommonPatterns.comma))).noForm("thanks|bollocks").noMatchUntil("FirstAux", NodePattern.or(wordInternalPunctuation, NodePattern.N.withHeadRelation("advmod").noPos())).andNot(NodePattern.N.noSpaceAfter().directlyBefore(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.N.noSpaceBefore().directlyAfter(CommonPatterns.HYPHEN_NODE)).andNot(NodePattern.ROOT.directlyAfter(CommonPatterns.ellipsis)).noDependents("det|advmod", NodePattern.N.form("no")).noDependents("csubj", NodePattern.N.beforeHead().withDependent("nsubj", Questions.whWord)).and((predicate, match) -> {
            List<Node> auxVerbs = predicate.findDependents("cop|aux|aux:pass");
            AuxMainVerbForm sequence = new AuxMainVerbForm(auxVerbs, predicate);
            for (Node verb : auxVerbs) {
                NodeMatch result = sequence.checkAux(verb, match);
                if (result == null) continue;
                return result.withTouchedNodes(auxVerbs);
            }
            return null;
        }).andNot(CommonPatterns.beforeSlashOrParenth).noDependents("advcl", EnglishTreePatterns.argumentParsedAsAdvcl).noDependents(NodePattern.N.beforeHead().after("FirstAux").form("since|when").trace("misparsed mark")).andNot(NodePattern.N.form("do").withDependent("cop").withDependent("nsubj", NodePattern.N.lemma("note")).trace("the note Do")).andNot(CommonPatterns.possiblySkipUp("cop|aux|aux:pass", EnglishTreePatterns.apostropheS.noSpaceBefore().directlyAfter(NodePattern.PUNCT)).trace("possibly possessive 's")).andNot(NodePattern.N.pos("VBG").and(NodePattern.markedNodeMatches("FirstAux", NodePattern.N.form("is|was"))).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.pos("NN.*").noDependents("det", NodePattern.N.noForm("the"))).noDependents("cop|aux|aux:pass", NodePattern.not(NodePattern.N.alreadyMarkedAs("FirstAux"))).trace("seeing is believing")).andNot(NodePattern.N.potentialPos("VB").withDependent("cop|aux|aux:pass", NodePattern.N.lemma("be")).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", toCopulaSubject).andNot(avoidActive).trace("missing infinitive to"));
    }

    private AuxKind classify(Node aux, Node next) {
        if (EnglishTreePatterns.baseAux.matches(aux)) {
            return baseAntipatterns.matches(this.predicate) ? null : AuxKind.NeedsBase;
        }
        if (possiblePlural.matches(aux)) {
            return null;
        }
        if (aux.hasLemma("be")) {
            return AuxKind.Be;
        }
        if (aux.hasLemma("have") && !aux.hasLemma("will") && haveAntipatterns.match(next, NodeMatch.EMPTY.withMarkedNode("Aux", aux)) == null) {
            return AuxKind.Have;
        }
        return null;
    }

    private NodeMatch checkAux(Node aux, NodeMatch match) {
        AuxKind kind;
        Node next = this.next(aux);
        if (aux.hasForm("can|will") && this.subject != null && !this.subject.hasPos("NN.*|PRP|VB.*")) {
            return null;
        }
        if (WordSeparation.mayBe.matches(next.nextNode())) {
            return null;
        }
        if (next.posReadings().isEmpty()) {
            return null;
        }
        if (next == this.predicate) {
            if (EnglishTreePatterns.afterAposOrQuote.matches(next)) {
                return null;
            }
            if (!next.hasPos("VB.*") && !AuxMainVerbForm.isNonBeCopula(aux, next)) {
                return null;
            }
        }
        if ((kind = this.classify(aux, next)) == null) {
            return null;
        }
        if (kind == AuxKind.NeedsBase && (!next.tagIndependently().hasPos("VB") || next.hasPos("MD") && next != this.predicate || next.hasForm("will"))) {
            if (AuxMainVerbForm.isNonBeCopula(aux, next)) {
                return match.withMessage("Did you mean the verb 'be'?").withCorrectors(this.finiteAuxToBe(aux)).withReportedRange(aux.startOffset(), next.endOffset(), aux.tree());
            }
            match = match.withMessage(INCOMPATIBLE_VERB_FORMS).withReportedNode(next, ReportingKind.Hover);
            if (aux.hasForm("can") && next.hasLemma("have") && next.nextNode() != null && next.nextNode().hasForm("to")) {
                return match.withCorrector(NodeCorrector.replaceNodes(next, next.neighbor(1), ""));
            }
            if (aux.hasLemma("do")) {
                if (next.hasLemma("be")) {
                    return match.withCorrector(this.doBeCorrector(aux, next));
                }
                if (next != aux.nextNode() && baseFormVerb.matches(next)) {
                    match = AuxMainVerbForm.replaceDoWithNext(match, aux, next);
                }
            }
            return match.withCorrectors(this.baseFormCorrectors(aux, next));
        }
        if (kind == AuxKind.Be) {
            if (this.isBeDo(aux, next) && !beDoAntiPatterns.matches(aux)) {
                return match.withCorrector(this.subject == null || !this.predicate.hasPos("VB") ? null : this.removeBe(aux, next)).withCorrectors(NonProgressive.noSuggestions.matches(this.predicate) ? List.of() : this.auxCorrectors(aux, next, "VBG")).withMessage("Auxiliary 'do' should not be placed after auxiliary 'be'");
            }
            if (next == this.predicate && NonProgressive.prohibit.matches(next)) {
                return match.withCorrector(this.removeBe(aux, next)).withMessage("'" + next.lemmaReadings().getFirst() + "' is usually not used in '-ing' form");
            }
            if (next != this.predicate && next.hasPos("MD") && beModalAntipatterns.match(next, match.withMarkedNode("Be", aux)) == null) {
                return match.withMessage("Excessive " + aux.quotedPresentableText() + "?").withCorrector(NodeCorrector.replaceNodes(aux, EnglishTreePatterns.negation.matches(aux.nextNode()) ? aux.nextNode() : aux, ""));
            }
            if (!(next.hasPos("VBG") || EnglishTreePatterns.verbsMissingAdjPosTags.matches(next) || next.hasPos("VBN") && EnglishTreePatterns.apostropheS.matches(aux) || beAntipatterns.match(next, match.withMarkedNode("Aux", aux)) != null)) {
                List<NodeCorrector> correctors = this.beCorrectors(aux, next);
                match = match.withCorrectors(correctors);
                if (EnglishTreePatterns.startsWithApostrophe.noSpaceBefore().matches(aux) && match.withAnchor(this.predicate).reportedRanges().stream().anyMatch(r -> r.containsInclusive(aux.startOffset()))) {
                    for (NodeCorrector corrector : correctors) {
                        match = match.withReportedRange(corrector.calcChangeRange(), aux.tree());
                    }
                    match = match.withReportedNode(aux.prevNode());
                }
                return match.withMessage(INCOMPATIBLE_VERB_FORMS).withReportedNode(next, ReportingKind.Hover);
            }
        }
        if (kind == AuxKind.Have && !next.hasPos("VBN")) {
            if (next == aux.nextNode() && mainHaveVerb.matches(next)) {
                match = match.withCorrector(NodeCorrector.removeNode(aux));
            }
            return match.withMessage(INCOMPATIBLE_VERB_FORMS).withCorrectors(this.auxCorrectors(aux, next, "VBN")).withReportedNode(next, ReportingKind.Hover);
        }
        return null;
    }

    @Nullable
    private NodeCorrector doBeCorrector(Node auxDo, Node auxBe) {
        if (this.subject == null || auxDo != this.auxVerbs.getFirst()) {
            return null;
        }
        Node nt = beforeContractedNot.matches(auxBe) ? auxBe.neighbor(1) : null;
        String be = VerbInflectionNumber.from(this.predicate, this.subject).sameTense(auxBe).inflectBe();
        return NodeCorrector.replace(auxDo, be + (nt != null ? nt.lowForm() : "")).join(NodeCorrector.replaceNodes(auxBe, nt != null ? nt : auxBe, ""));
    }

    private boolean isBeDo(Node aux, Node next) {
        return next.hasLemma("do") && next != this.predicate && aux.hasLemma("be");
    }

    private static NodePattern haveComp() {
        NodePattern havePattern = NodePattern.N.lemma("have").pos("VB[ZPD]?").noLemma("will");
        return NodePattern.N.pos("VBG?").noPos("VBN").andOr(NodePattern.N.withHeadRelation("ccomp|xcomp").directlyAfter(havePattern.withHeadRelation("root|ccomp").noDependents("obj")), NodePattern.ROOT.withDependent("aux", havePattern.directlyBeforeHead())).andNot(misparsedCompound).andNot(EnglishTreePatterns.unlikelyToBeVerb).and((node, match) -> {
            Node have = node.neighbor(-1);
            return match.withCorrectors(new AuxMainVerbForm(List.of(have), node).auxCorrectors(have, node, "VBN"));
        }).andOptionally(NodePattern.N.pos("VB").correct(NodeCorrector.insertBefore("to "))).and((node, match) -> {
            node.head();
            return match.withMessage(INCOMPATIBLE_VERB_FORMS);
        });
    }

    private static NodeMatch replaceDoWithNext(NodeMatch match, Node aux, Node next) {
        String replacement;
        match = match.withReportedNodes(aux, next);
        String string = replacement = aux.hasPos("VBD") && next.hasLemma("can") ? "could" : next.lowForm();
        if (beforeContractedNot.matches(aux)) {
            match = match.withReportedNode(aux.nextNode());
            if ("can".equals(replacement)) {
                return match.withCorrector(NodeCorrector.replaceNodes(aux, aux.neighbor(1), "can\u2019t").join(NodeCorrector.removeNode(next)));
            }
        }
        return match.withCorrector(NodeCorrector.replace(aux, replacement).join(NodeCorrector.removeNode(next)));
    }

    private static boolean isNonBeCopula(Node aux, Node next) {
        return next == aux.head() && !next.hasPos("VB.*") && next.hasPos("JJ.*") && aux.hasLemma("do");
    }

    private List<NodeCorrector> baseFormCorrectors(Node aux, Node next) {
        Node overNext;
        if (next.lowForm().equals("becoming")) {
            return List.of(NodeCorrector.replace(next, "be coming"));
        }
        Node afterAux = aux.nextNode();
        if (beTypo.matches(afterAux)) {
            return List.of(NodeCorrector.replace(afterAux, "be"));
        }
        if (next != afterAux && beTypo.matches(next)) {
            return List.of(NodeCorrector.replace(next, "be"));
        }
        List<NodeCorrector> nextCorrectors = next == this.predicate ? List.of() : this.nextAuxCorrectors(next);
        ArrayList<NodeCorrector> result = new ArrayList<NodeCorrector>();
        if (!skipBaseFormSuggestion.matches(next)) {
            result.addAll(AuxMainVerbForm.joinWithNextFixes(NodeCorrector.inflect(next, "VB.*", "VB"), AuxMainVerbForm.filterAfter(nextCorrectors, next.endOffset())));
        }
        if (this.predicate == next && !next.hasLemma("please")) {
            if (aux.hasLemma("do")) {
                if (!NonProgressive.noSuggestions.matches(next) || next.tagIndependently().hasPos("VBN")) {
                    result.addAll(this.finiteAuxToBe(aux));
                }
            } else if (next.tagIndependently().hasPos("VB[NG]")) {
                result.addAll(AuxMainVerbForm.insertBeOrHave(aux, next));
            }
        }
        if (next != this.predicate && baseFormVerb.matches(overNext = this.next(next))) {
            boolean isNextNegated = beforeContractedNot.matches(next);
            if (!isNextNegated) {
                result.add(NodeCorrector.removeNode(next));
            }
            if (this.subject != null && aux.isAfter(this.subject) && baseFormVerb.matches(aux) && !EnglishTreePatterns.negation.matches(afterAux)) {
                result.addAll(AuxMainVerbForm.joinWithNextFixes(NodeCorrector.removeNode(aux), AuxMainVerbForm.filterAfter(nextCorrectors, next.startOffset())));
            }
            if (isNextNegated) {
                result.add(AuxMainVerbForm.removeNegatedNext(aux, next));
            }
        }
        if (result.isEmpty() && next.hasForm("will")) {
            return List.of(NodeCorrector.replace(next, next == this.predicate ? "wish" : "become"));
        }
        return result;
    }

    private static NodeCorrector removeNegatedNext(Node aux, Node next) {
        NodeCorrector removeNext = NodeCorrector.removeNode(next).join(NodeCorrector.removeNode(next.neighbor(1)));
        String contracted = ToggleContraction.contractNegation(aux.lowForm());
        if (contracted != null && !beforeContractedNot.matches(aux)) {
            removeNext = removeNext.join(NodeCorrector.replace(aux, contracted));
        }
        return removeNext;
    }

    private static List<NodeCorrector> filterAfter(List<NodeCorrector> correctors, int offset) {
        return correctors.stream().filter(c -> c.calcChangeRange().start() >= offset).toList();
    }

    private static List<NodeCorrector> joinWithNextFixes(NodeCorrector corrector, List<NodeCorrector> fixesForNext) {
        return fixesForNext.isEmpty() ? List.of(corrector) : fixesForNext.stream().map(c -> corrector.join((NodeCorrector)c)).toList();
    }

    private List<NodeCorrector> nextAuxCorrectors(Node next) {
        NodeMatch match = this.checkAux(next, NodeMatch.EMPTY);
        if (match == null) {
            return List.of();
        }
        return match.correctors();
    }

    private static List<NodeCorrector> insertBeOrHave(Node aux, Node next) {
        String toInsert;
        String string = toInsert = next.hasPos("VBG") || !next.hasDependent("i?obj") && !aux.hasForm("may|might") ? "be" : "have";
        if ("have".equals(toInsert) && aux.hasLemma("can")) {
            return List.of();
        }
        if (next.hasPos("VBG") || aux.nextUntil(next).anyMatch(n -> n.hasForm("never") || n.hasHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?|expl"))) {
            return List.of(NodeCorrector.insertBefore(next, toInsert + " "));
        }
        return List.of(NodeCorrector.insertAfter(EnglishTreePatterns.negation.matches(aux.nextNode()) ? Objects.requireNonNull(aux.nextNode()) : aux, " " + toInsert));
    }

    private List<NodeCorrector> finiteAuxToBe(Node aux) {
        if (this.subject == null || !aux.hasPos("VB[ZDP]") || !suggestBeAux.matches(this.predicate)) {
            return List.of();
        }
        String be = VerbInflectionNumber.from(this.predicate, this.subject).sameTense(aux).inflectBe();
        if (beforeContractedNot.matches(aux) && "am".equals(be)) {
            return List.of(NodeCorrector.replaceNodes(aux, aux.neighbor(1), "am not"));
        }
        return List.of(NodeCorrector.replace(aux, be));
    }

    private List<NodeCorrector> beCorrectors(Node be, Node next) {
        boolean suggestVbn;
        NodeCorrector fixAgreement = this.fixAgreement(be);
        ArrayList<NodeCorrector> result = new ArrayList<NodeCorrector>();
        if (next == this.predicate) {
            if (wendWentTypo.matches(next)) {
                result.add(NodeCorrector.replace(next, "went").join(NodeCorrector.removeNode(be)));
            }
            result.addAll(AuxMainVerbForm.replaceByMap(next, verbsToAdjectives));
            if (suggestNounCopulaHeads.matches(next)) {
                result.addAll(AuxMainVerbForm.replaceByMap(next, UnexpectedVerb.verbsToNouns));
            }
            if (!result.isEmpty() && onlyCopulaSuggestions.matches(next)) {
                return result;
            }
            NodeMatch match = subjectObjectDuplication.match(next);
            if (match != null) {
                Node obj = match.getMarkedNode("Obj");
                result.add(NodeCorrector.inflect(next, "VB.*", "VBN").join(fixAgreement).join(NodeCorrector.replaceNodes(obj.phraseStart(), obj.phraseEnd(), "")));
            }
        }
        if (next.tagIndependently().hasPos("VB") && EnglishTreePatterns.apostropheS.matches(be)) {
            result.add(NodeCorrector.replace(be, be.form().charAt(0) + "d"));
        }
        boolean mayChangeNext = !beforeContractedNot.matches(next);
        boolean bl = suggestVbn = this.suggestVbn(next, be) && !nonPassive.matches(next);
        if (suggestVbn && mayChangeNext) {
            result.add(NodeCorrector.inflect(next, "VB.*", "VBN").join(fixAgreement));
        }
        boolean doubleBe = next.hasLemma("be");
        if (next != this.predicate || !suggestOnlyPassive.matches(this.predicate)) {
            NodeCorrector toFinite;
            if (!NonProgressive.noSuggestions.matches(next)) {
                if (doubleBe) {
                    boolean presentPast;
                    if (be.hasForm("being") && !this.predicate.hasDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl")) {
                        return List.of();
                    }
                    boolean bl2 = presentPast = be.nextNode() == next && be.hasPos("VB[PZD]") && next.hasPos("VBD");
                    if (be.hasForm("be") && next.hasForm("be") && be.nextNode() != next || !mayChangeNext || presentPast) {
                        result.add(NodeCorrector.removeNode(be));
                    }
                    if (mayChangeNext && !presentPast) {
                        result.add(NodeCorrector.removeNode(next).join(fixAgreement));
                    }
                }
                if (mayChangeNext && be.hasPos("VB[ZPDN]") && suggestGerundAfterBe.matches(next)) {
                    result.add(NodeCorrector.inflect(next, "VB.*", "VBG").join(fixAgreement));
                }
            }
            if (!doubleBe && this.suggestRemovingBe(be, next) && !avoidActive.matches(next) && (toFinite = this.removeBe(be, next)) != null) {
                result.add(toFinite);
            }
        }
        if (next.hasPos("VBN")) {
            if (be.hasForm("['\u2019`\u2018](m|re)")) {
                result.add(NodeCorrector.replace(be, be.form().charAt(0) + "ve"));
            } else if (be.hasForm("am|are")) {
                result.add(NodeCorrector.replace(be, "have"));
            } else if (be.hasForm("is")) {
                result.add(NodeCorrector.replace(be, "has"));
            } else if (be.hasForm("were")) {
                result.add(NodeCorrector.replace(be, "have").join(fixAgreement));
            } else if (be.hasForm("was")) {
                if (this.subject != null && (this.subject.hasForm("I|you") || this.subject.hasPos("NNS"))) {
                    result.add(NodeCorrector.replace(be, "have"));
                } else {
                    result.add(NodeCorrector.replace(be, "has"));
                }
            }
        }
        if (suggestVbn && next == this.predicate) {
            HashSet<String> nextLemmas = new HashSet<String>(next.lemmaReadings());
            result.add(NodeCorrector.replace(next, ((StreamEx)((StreamEx)next.similarWordsOfPos("VBN").filter(s -> next.tree().treeSupport().tagToken((String)s).lemmaReadings().stream().noneMatch(nextLemmas::contains))).limit(1L)).toList()));
        }
        return result;
    }

    @Nullable
    private NodeCorrector fixAgreement(Node aux) {
        Number subjectNumber;
        if (aux == this.auxVerbs.getFirst() && this.subject != null && (subjectNumber = SubjectVerbAgreement.subjectNumber(this.subject, this.predicate)).conflictsWith(Number.verbNumber(aux))) {
            List<NodeCorrector> correctors = new AgreementSet(this.subject, subjectNumber).changeVerbNumber(aux, false);
            return correctors == null || correctors.isEmpty() ? null : correctors.getFirst();
        }
        return null;
    }

    static List<NodeCorrector> replaceByMap(Node node, Map<String, List<String>> map) {
        return StreamEx.of(node.lemmaReadings()).map(map::get).nonNull().map(suggestions -> NodeCorrector.replace(node, suggestions)).toList();
    }

    @Nullable
    private NodeCorrector removeBe(Node be, Node next) {
        if (be.hasDependent(".*")) {
            return null;
        }
        if (this.subject != null && be.isBefore(this.subject)) {
            return next.lowForm().equals(be.lowForm()) ? NodeCorrector.replace(next, "") : null;
        }
        if (AuxMainVerbForm.isToBeVB(be, next)) {
            return NodeCorrector.replace(be, "");
        }
        NodeCorrector inflectNext = be.hasPos("VBN") ? NodeCorrector.inflect(next, "VB.*", "VBN") : (be.hasPos("VBG") ? NodeCorrector.inflect(next, "VB.*", "VBG") : (!next.hasPos("VBP?") ? NodeCorrector.inflect(next, "VB.*", "VB") : null));
        VerbInflectionNumber number = VerbInflectionNumber.fromLikely(this.predicate, this.subject);
        if (number == null) {
            return null;
        }
        VerbInflectionNumber.Inflector inflector = next.hasPos("VBD") && !next.hasPos("VBN") ? number.past(true) : number.sameTense(be);
        boolean negated = EnglishTreePatterns.negation.matches(be.nextNode());
        if (be == this.auxVerbs.getFirst()) {
            if (negated && next.hasLemma("be")) {
                return null;
            }
            return negated ? NodeCorrector.replace(be, (EnglishTreePatterns.startsWithApostrophe.matches(be) ? " " : "") + inflector.inflectDo()).join(inflectNext) : NodeCorrector.replace(be, "").join(inflector.inflectFinite(next));
        }
        return negated ? inflectNext : NodeCorrector.replace(be, "").join(inflectNext);
    }

    private boolean suggestRemovingBe(Node be, Node next) {
        if (this.subject == null) {
            return AuxMainVerbForm.isToBeVB(be, next);
        }
        Node firstAux = this.auxVerbs.getFirst();
        return EnglishTreePatterns.baseAux.matches(firstAux) && next.hasPos("VB") || next == this.predicate && be.hasForm("being") || be == firstAux && possiblyFinite.matches(next) || be == firstAux && nonPassive.matches(this.predicate) && SubjectVerbAgreement.subjectNumber(this.subject, this.predicate) == Number.singular;
    }

    private static boolean isToBeVB(Node be, Node next) {
        return be.prevNode() != null && "to".equals(be.prevNode().lowForm()) && next.hasPos("VB") && !WordConfusion.copHeadTypo.matches(next);
    }

    private boolean suggestVbn(Node next, Node be) {
        if (next == this.predicate) {
            return noDirectObject.matches(this.predicate) || EnglishValences.mayHaveTwoObjects.matches(this.predicate) || toAmodCopula.matches(this.predicate);
        }
        if (next.hasLemma("be")) {
            return EnglishTreePatterns.apostropheS.matches(be) && next.lowForm().startsWith("be");
        }
        if (possiblyFinite.matches(next)) {
            return false;
        }
        return this.predicate.hasPos("VBN");
    }

    List<NodeCorrector> auxCorrectors(Node aux, Node next, String basePosReplacement) {
        block7: {
            ArrayList<NodeCorrector> result;
            NodeCorrector removeAux;
            List<String> fullAux;
            block9: {
                block8: {
                    if (!beforeContractedNot.matches(next)) break block7;
                    fullAux = ToggleContraction.decontractVerb(aux);
                    removeAux = NodeCorrector.replace(aux, "");
                    result = new ArrayList<NodeCorrector>();
                    if (!this.isBeDo(aux, next)) break block8;
                    if (this.predicate.hasPos("VB")) break block9;
                }
                result.addAll(StreamEx.of(this.baseFormCorrectors(next, this.predicate)).map(removeAux::join).toList());
            }
            result.add(removeAux.join(NodeCorrector.replace(next, fullAux)).join(NodeCorrector.inflect(this.predicate, "VB.*", basePosReplacement)));
            return result;
        }
        ArrayList<NodeCorrector> result = new ArrayList<NodeCorrector>();
        if (!EnglishTreePatterns.negation.matches(next.nextNode())) {
            if (beenTypo.matches(next)) {
                result.add(NodeCorrector.replace(next, "been"));
            }
            result.add(NodeCorrector.inflect(next, "VB.*", "VBN"));
        }
        if (next == this.predicate && next.hasPos("VB[ZPG]?") && !next.hasPos("VB[DP]")) {
            result.add(NodeCorrector.insertBefore(next, "been ").join(NodeCorrector.inflect(next, "VB.*", "VBG")));
        }
        if (suggestHaveTo.matches(next)) {
            result.add(NodeCorrector.insertBefore(next, "to "));
        }
        return result;
    }

    private static enum AuxKind {
        NeedsBase,
        Be,
        Have;

    }
}

