/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommaLicense;
import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.en.Articles;
import ai.grazie.rules.en.Commas;
import ai.grazie.rules.en.EnglishParameters;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.en.EnglishValences;
import ai.grazie.rules.en.PunctuationRules;
import ai.grazie.rules.en.Questions;
import ai.grazie.rules.en.SemCompatibility;
import ai.grazie.rules.en.Semantics;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.Tree;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class RelativeClauses {
    static final NodePattern possiblySententialRelativeBasicPattern = NodePattern.N.withDependent("nsubj", NodePattern.N.form("which")).withHead(NodePattern.N.inPhrase(EnglishTreePatterns.clause).markAs("ClauseHead")).withPhraseEnd(NodePattern.or(CommonPatterns.lastWord, NodePattern.N.markAs("PhraseEnd").directlyBefore(NodePattern.N.inPhrase(NodePattern.N.after("PhraseEnd").withHead("conj|parataxis", NodePattern.N.before("ClauseHead"))))));
    private static final NodePattern possiblySententialRelative = possiblySententialRelativeBasicPattern.andOr(CommonPatterns.possiblySkipDown("cop|aux|aux:pass", NodePattern.N.pos("VBZ|MD")).andOr(NodePattern.N.withHead("(acl|advcl):relcl", NodePattern.N.withDependent("cop", NodePattern.N.pos("VBD"))).withDependent("cop", NodePattern.N.form("is")), NodePattern.N.pos("NN").withDependent("det", NodePattern.N.form("an?").andNot(NodePattern.N.directlyAfter(NodePattern.N.form("neither")))), NodePattern.N.pos("JJ|VB[NG]").noDependents("aux", NodePattern.N.lemma("will")).withHead("(acl|advcl):relcl", NodePattern.N.noPos("NN").andNot(NodePattern.N.directlyBefore("Which")))), NodePattern.N.pos("WRB|JJR").withDependent("cop"), NodePattern.N.pos("VBZ").directlyAfter("Which").markAs("SentRel").andOr(NodePattern.N.withHead("(acl|advcl):relcl", NodePattern.or(NodePattern.N.pos("NNS").andNot(NodePattern.N.directlyBefore("Which")), NodePattern.ROOT.andOr(NodePattern.N.noDependents("cop").withDependent(".*", NodePattern.N.afterHead().before("Which").noHeadRelation("acl")).and(NodePattern.markedNodeMatches("SentRel", NodePattern.not(NodePattern.custom(rel -> {
        Node beforeWhich = rel.neighbor(-2);
        return beforeWhich.hasPos("NN.*") && SemCompatibility.forSubject(rel, beforeWhich) == SemCompatibility.Likely;
    }).trace("misattached noun relcl")).andNot(NodePattern.N.withPrevSibling(NodePattern.N.pos("NN"))))), NodePattern.N.pos("JJ").withDependent("advmod", NodePattern.N.directlyBeforeHead())))), NodePattern.N.withHeadRelation("parataxis"))).andNot(NodePattern.N.withHead("(acl|advcl):relcl", NodePattern.N.inPhrase(NodePattern.ROOT.and(EnglishTreePatterns.imperativeVB)))).andNot(NodePattern.N.pos("JJ").withHead("(acl|advcl):relcl", NodePattern.or(NodePattern.N.withHead("nsubj", NodePattern.N.form("here")), EnglishTreePatterns.isSubjectOfExpl))).trace("possiblySententialRelative");
    private static final NodePattern theOnes = NodePattern.N.form("ones?").withDependent("det", NodePattern.N.form("the"));
    static final NodePattern possiblyHeadOfNonRestrictiveClause = NodePattern.or(theOnes.withDependent("amod", NodePattern.N.noForm("only")), NodePattern.N.label(".*"), CommonPatterns.capitalizedMiddle.withDependent("compound", NodePattern.N.noPos()), NodePattern.N.withHead("nsubj.*", NodePattern.ROOT).withDependent("det", EnglishTreePatterns.demonstratives), NodePattern.N.withDependent("amod", CommonPatterns.capitalizedMiddle.noDependents("punct")), NodePattern.N.withDependent("nmod:poss", NodePattern.N.noForm("there")).andNot(Semantics.definitelyUncountableNoun).noDependents("amod", NodePattern.N.form("own")).noDependents("conj")).noDependents("det", NodePattern.N.form("an?"));
    private static final NodePattern possiblyWrongRelClHead = NodePattern.or(NodePattern.N.pos("NNS?").noDependents("det").withDependent("case").withHead("nmod", NodePattern.N.withDependent("det")), NodePattern.N.withDependent("nmod", NodePattern.N.withDependent("case", NodePattern.N.form("at|between"))).afterHead(), NodePattern.N.withDependent("case").withHead("nmod", NodePattern.ROOT.pos("NN")), NodePattern.N.noPos().withHead("nmod", NodePattern.N.pos("NNS")), NodePattern.N.inPhrase(NodePattern.N.withHeadRelation("acl"))).trace("possiblyWrongHead");

    RelativeClauses() {
    }

    static NodePattern commaPattern() {
        return NodePattern.or(RelativeClauses.comma_That(), RelativeClauses.comma_ProperNoun(), RelativeClauses.comma_Which(), RelativeClauses.misparsedRestrictiveRelcl());
    }

    private static NodePattern misparsedRestrictiveRelcl() {
        return Commas.misparsedRestrictiveRelcl.and(PunctuationRules.removeSurroundingCommas).message("If introducing essential information about '$Head', remove surrounding commas").trace("misparsedRestrictiveRelcl");
    }

    private static NodePattern comma_ProperNoun() {
        NodePattern specificProper = Commas.properNoun.withDependent("det", NodePattern.N.form("the")).noDependents("flat|appos").andNot(Articles.geoRequiringThe).andNot(NodePattern.N.formCaseSensitive("Forces?").withDependent("compound", NodePattern.N.form("space|air|armed"))).noForm("Dalai|Lama|Pope").noLabel("NATIONALITY_OR_GROUP|PRODUCT|ORGANIZATION");
        return NodePattern.or(Commas.properNonRestrictiveRelClause().andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.withHeadRelation("cc")))).and(NodePattern.custom((head, match) -> PunctuationRules.addCommasAround(head, match))).message("If the clause introduces non-essential information about a proper noun, consider surrounding it with commas"), EnglishTreePatterns.clause.withHead("acl:relcl", specificProper).noDependents(NodePattern.N.form("which")).and(RelativeClauses.thatToWhichWho()).and(PunctuationRules.removeSurroundingCommas));
    }

    private static NodePattern comma_That() {
        NodePattern possiblyMisparsedIndependentClause = NodePattern.custom(Semantics::canDescribeAbstractConcept).and(NodePattern.markedNodeMatches("Noun", NodePattern.N.afterHead().withHead(NodePattern.N.inPhrase(EnglishTreePatterns.clause.before("Noun"))))).and(NodePattern.markedNodeMatches("That", NodePattern.N.withHeadRelation("nsubj.*")));
        return EnglishTreePatterns.clause.markAs("RelCl").withHead("a(dv)?cl:relcl", NodePattern.N.pos("NN.*").markAs("Noun").noDependents("amod", NodePattern.N.afterHead().before("RelCl")).noDependents("advmod", Commas.egIe.afterHead().before("RelCl")).withHeadRelation("nsubj.*|i?obj|obl.*|nmod|root").andNot(NodePattern.N.withHeadRelation("obl:tmod").withDependent("det")).andNot(NodePattern.N.withHead("nsubj.*", NodePattern.N.pos("VBN").directlyAfter(CommonPatterns.comma).noDependents("i?obj")))).withDependent("nsubj.*|mark", NodePattern.N.form("that").markAs("That")).noDependents("advmod", Commas.egIe.before("RelCl")).andNot(NodePattern.N.withDependent("nsubj", NodePattern.N.after("That")).withDependent("cop")).and(PunctuationRules.removeSurroundingCommas).and(RelativeClauses.thatToWhichWho()).andNot(NodePattern.custom(n -> n.forward().anyMatch(NodePattern.N.inFormSequence(1, "and", "that")::matches))).andNot(PunctuationRules.hasPunctuationAfter(CommonPatterns.comma.directlyBefore(NodePattern.N.form("that")))).andNot(PunctuationRules.hasPunctuationBefore(CommonPatterns.comma.directlyAfter(NodePattern.N.inPhrase(EnglishTreePatterns.clause.withHead("acl:relcl", NodePattern.N.inPhrase(NodePattern.N.alreadyMarkedAs("Noun"))))))).andNot(NodePattern.N.inPhrase(NodePattern.N.withDependent(".*", Questions.whPhrase))).andNot(possiblyMisparsedIndependentClause);
    }

    private static NodePattern surroundRelativeClauseWithCommas() {
        NodePattern requiresNonRestrictiveRel = NodePattern.or(possiblyHeadOfNonRestrictiveClause, NodePattern.N.withDependent("appos", CommonPatterns.insideQuotes.noDependents("det", NodePattern.N.form("an?")).afterHead().withNextSibling(NodePattern.N.alreadyMarkedAs("RelCl"))), NodePattern.N.noPos("NNS").withDependent("conj", NodePattern.N.after("RelCl").withDependent("acl:relcl")).andNot(NodePattern.N.form("ones?").noDependents("amod").withHeadRelation("appos"))).trace("requiresNonRestrictiveRel");
        NodePattern probablyNonRestrictiveRel = NodePattern.N.withDependent("nsubj:pass", NodePattern.N.form("which")).andOr(NodePattern.N.withDependent("advmod", NodePattern.N.form("first|initially|previously")), EnglishTreePatterns.withModal.pos("VBN").withPhraseEnd(CommonPatterns.lastToken).withHead(NodePattern.ROOT));
        NodePattern explanatoryAppos = NodePattern.N.markAs("Appos").withHead("appos", NodePattern.N.sameWordAs("Appos"));
        return NodePattern.or(NodePattern.N.withHead("(acl|advcl):relcl", requiresNonRestrictiveRel.andNot(RelativeClauses.requiresRestrictiveRel()).andNot(explanatoryAppos).andNot(possiblyWrongRelClHead)).trace("head requires non-restrictive rel clause"), possiblySententialRelative.trace("sentential rel clause"), probablyNonRestrictiveRel.trace("probably non-restrictive rel clause")).and(NodePattern.custom((head, match) -> PunctuationRules.addCommasAround(head, match)));
    }

    static NodePattern requiresRestrictiveRel() {
        NodePattern possiblyDefinite = NodePattern.or(NodePattern.N.withDependent("appos|compound", CommonPatterns.insideQuotes), NodePattern.N.withDependent("amod", NodePattern.N.form("following|next|previous")).noHeadRelation("obj"), NodePattern.N.withDependent("amod", NodePattern.or(NodePattern.N.pos("JJS"), NodePattern.N.withDependent("advmod", NodePattern.N.form("most")))), NodePattern.N.withDependent("amod", CommonPatterns.capitalizedMiddle).withDependent("det", NodePattern.N.form("the")));
        return NodePattern.or(NodePattern.N.pos("WP").withHeadRelation("nsubj(:pass|:outer)?|csubj(:pass)?"), NodePattern.N.withHead("nsubj", NodePattern.N.withDependent("expl")), NodePattern.N.withDependent("cop").andOr(NodePattern.N.noPos("NNPS?").withDependent("nsubj|expl", NodePattern.not(possiblyDefinite).noDependents("(acl|advcl):relcl")).andNot(NodePattern.N.pos("JJ").noPos("CD").noDependents("det|nmod:poss|amod|nummod", NodePattern.N.beforeHead())), NodePattern.N.potentialPos("NNP?").withDependent("expl|nsubj", NodePattern.N.form("it"))), theOnes.noDependents("amod", NodePattern.N.noForm("only")), EnglishTreePatterns.someAnyEveryNoX, Semantics.people, NodePattern.N.withHead("obj", NodePattern.N.withHeadRelation("csubj")), NodePattern.N.withDependent("det", NodePattern.N.form("all|any|no|every|each|some")), NodePattern.N.withDependent("amod|advmod", NodePattern.N.form("most|many")), NodePattern.N.withDependent("(acl|advcl):relcl", NodePattern.N.withDependent("cc:preconj", NodePattern.N.form("neither")))).andNot(possiblyDefinite).andNot(possiblyWrongRelClHead).andNot(NodePattern.N.withDependent("(acl|advcl):relcl", possiblySententialRelative));
    }

    private static NodePattern comma_Which() {
        NodePattern thatInTheClause = NodePattern.or(NodePattern.N.withDependent("acl:relcl", NodePattern.N.withDependent("ccomp", EnglishTreePatterns.withThatMark)), NodePattern.N.withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", EnglishTreePatterns.withThatMark), NodePattern.N.withDependent("det", NodePattern.N.form("that"))).trace("thatInTheClause");
        NodePattern quotedNP = NodePattern.N.directlyAfter(EnglishTreePatterns.aposOrQuote).and(CommonPatterns.insideQuotes).noMatchUntil("RelCl", EnglishTreePatterns.aposOrQuote);
        NodePattern whichToThat = EnglishParameters.VARIANT.withValue("US").withHead("(acl|advcl):relcl", CommonPatterns.possiblySkipUp(NodePattern.N.withHeadRelation("nmod").withDependent("case", NodePattern.N.form("of")), NodePattern.or(RelativeClauses.requiresRestrictiveRel().andNot(thatInTheClause), NodePattern.ROOT.andNot(EnglishTreePatterns.clause).markAs("WhichAndThat")))).andNot(NodePattern.N.withPhraseStart(NodePattern.or(NodePattern.PUNCT, NodePattern.N.directlyAfter(NodePattern.PUNCT)))).andNot(NodePattern.markedNodeMatches("Which", NodePattern.N.directlyAfter(NodePattern.PUNCT))).correct(NodeCorrector.replace(NodePointer.marked("Which"), "that"));
        NodePattern surround = RelativeClauses.surroundRelativeClauseWithCommas();
        return EnglishTreePatterns.clause.withDependent("nsubj.*|obj|obl", NodePattern.N.form("which").withOnlyDependents(NodePattern.PUNCT).markAs("Which")).markAs("RelCl").andOr(whichToThat.andOr(NodePattern.markedNodeMatches("WhichAndThat", NodePattern.N).and(surround).message("In American English, use 'that' when introducing essential information; otherwise, surround non-essential clause with commas"), NodePattern.N.message("In American English, 'that' is preferred over 'which' when introducing essential information about a noun")), surround.message("Consider surrounding the clause that introduces non-essential information with commas")).withHead(NodePattern.not(quotedNP)).andNot(NodePattern.markedNodeMatches("Which", NodePattern.N.withHead("nsubj", NodePattern.N.withDependent("cop").withHead(EnglishValences.mayHaveArgument("ccomp"))).trace("misparsed ccomp"))).andNot(NodePattern.N.withPhraseEnd(NodePattern.N.directlyBefore(NodePattern.N.form("and|or").withHead("cc", EnglishTreePatterns.clause.noDependents("nsubj(:pass|:outer)?|csubj(:pass)?|expl")))));
    }

    private static NodePattern thatToWhichWho() {
        NodePattern restrictiveOnly = NodePattern.N.withHeadRelation("nsubj").withDependent("det", NodePattern.or(NodePattern.N.directlyBeforeHead().form("the|this|th[eo]se|that|another"), NodePattern.N.inFormSequence(0, "the", "only")));
        return NodePattern.custom((relcl, match) -> {
            Node that = StreamEx.of(relcl.findDependents("mark")).findFirst(n -> n.hasForm("that")).orElse(relcl.findSingleDependent("nsubj.*"));
            if (that == null) {
                return null;
            }
            List<Node> hostCandidates = EnglishTreePatterns.findRelativeClauseHostCandidates(that, relcl);
            String about = hostCandidates.size() == 1 ? " about '" + RelativeClauses.clauseHeadText(hostCandidates.getFirst()) + "'" : "";
            String message = "If introducing essential information" + about + ", remove surrounding commas";
            if (!that.hasForm("that") || restrictiveOnly.matches(relcl.head())) {
                return match.withMessage(message);
            }
            Boolean animate = RelativeClauses.suggestAnimateRelativizer(relcl, hostCandidates);
            List<String> toSuggest = animate == null ? List.of("which", "who") : List.of(animate != false ? "who" : "which");
            NodeCorrector corrector = NodeCorrector.replace(that, toSuggest);
            PhraseCommaChange change = CommaLicense.forPhrase(relcl, CommaLicense.NeedCommas.around).addMissingCommas(PunctuationRules.commaOrOpening, PunctuationRules.commaOrClosing);
            if (change != null) {
                corrector = corrector.join(change.correct());
                if (change.changeBefore() != null) {
                    Tree tree = relcl.tree();
                    match = match.withReportedRange(PhraseCommaChange.mainReportedRange(tree, change.changeBefore()), tree);
                }
            }
            match = match.withCorrector(corrector);
            return match.withMessage(message + "; otherwise, use " + StreamEx.of(toSuggest).map(s -> "'" + s + "'").joining((CharSequence)" or "));
        });
    }

    @Nullable
    static Boolean suggestAnimateRelativizer(Node relcl, List<Node> hostCandidates) {
        ArrayList<Node> nouns = new ArrayList<Node>(hostCandidates);
        if (SemCompatibility.nominalPredicate.matches(relcl)) {
            nouns.add(relcl);
        }
        boolean hasAnimate = false;
        boolean hasInanimate = false;
        for (Node noun : nouns) {
            Set<Semantics.Animacy> animacies = Semantics.animacies(noun);
            if (animacies.size() != 1) {
                return null;
            }
            if (animacies.iterator().next() == Semantics.Animacy.humanLike) {
                hasAnimate = true;
                continue;
            }
            hasInanimate = true;
        }
        if (hasAnimate != hasInanimate) {
            return hasAnimate;
        }
        return null;
    }

    private static String clauseHeadText(Node head) {
        Object headText = head.form();
        Node next = head.nextNode();
        if (next != null) {
            if (next.head() == head && next.hasHeadRelation("flat")) {
                headText = (String)headText + " " + next.form();
            }
            if (head.allDependents().stream().anyMatch(n -> n.isAfter(next) && n.hasHeadRelation("conj"))) {
                headText = (String)headText + "...";
            }
        }
        return headText;
    }

    static NodePattern relativePronounConfusion() {
        return NodePattern.or(RelativeClauses.whatThat(), RelativeClauses.thatWithPreposition(), RelativeClauses.whichWho());
    }

    private static NodePattern whichWho() {
        return NodePattern.N.form("which").markAs("Which").withHead("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound", NodePattern.N.withHeadRelation("acl:relcl").and((relcl, match) -> {
            Node which = match.getMarkedNode("Which");
            if (Boolean.TRUE.equals(RelativeClauses.suggestAnimateRelativizer(relcl, EnglishTreePatterns.findRelativeClauseHostCandidates(which, relcl)))) {
                return match.withCorrector(NodeCorrector.replace(which, which.hasDependent("case") ? "whom" : "who"));
            }
            return null;
        })).message("Use 'who' with people");
    }

    private static NodePattern whatThat() {
        return NodePattern.N.form("what").markAs("What").andOr(NodePattern.N.withHead("obj", NodePattern.N.withHead("acl:relcl", NodePattern.N.withHeadRelation("nsubj.*").pos("NN.*").reportRangeTo("What", ReportingKind.Hover))).noDependents("acl:relcl").andNot(NodePattern.N.directlyAfter(NodePattern.N.withHeadRelation("mark")).trace("misattached case")).correct(NodeCorrector.replace("")), NodePattern.N.directlyAfter(NodePattern.N.form("all").reportRangeTo("What", ReportingKind.Hover)).withDependent("acl:relcl").andOptionally(NodePattern.N.noDependents("det:predet").correct(NodeCorrector.replace("")))).correct(NodeCorrector.replace("that")).message("Avoid using 'what' as a relative pronoun in clauses that modify a noun or pronoun");
    }

    private static NodePattern thatWithPreposition() {
        return NodePattern.N.markAs("Prep").noForm("of").withHead("case", NodePattern.N.form("that").beforeHead().markAs("That").withHead("obl", NodePattern.N.withHeadRelation("acl:relcl").withPhraseStart(NodePattern.N.sameWordAs("Prep")).noDependents("obl", NodePattern.N.pos("IN").afterHead()).markAs("RelCl").reportRangeTo("Prep", ReportingKind.Hover))).reportRangeTo("That").message("Use 'which' or move the preposition to the end of the relative clause").and((node, match) -> {
            String preposition = node.form();
            Node that = match.getMarkedNode("That");
            Node relcl = match.getMarkedNode("RelCl");
            if (relcl == relcl.phraseEnd()) {
                match = match.withCorrector(NodeCorrector.replace(node, "").join(NodeCorrector.insertAfter(relcl, " " + preposition)));
            }
            return match.withCorrector(NodeCorrector.replace(that, "which"));
        });
    }
}

