/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0000\u001a\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00102\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000eH\u0002\u001a\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0005*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "joinData", "", "user", "", "password", "Lcom/intellij/credentialStore/OneTimeString;", "splitData", "Lcom/intellij/credentialStore/Credentials;", "data", "ESCAPING_CHAR", "", "parseString", "", "delimiter", "createSecureRandom", "Ljava/security/SecureRandom;", "generateBytes", "size", "", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\ncredentialStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 credentialStore.kt\ncom/intellij/credentialStore/CredentialStoreKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n13#2:89\n*S KotlinDebug\n*F\n+ 1 credentialStore.kt\ncom/intellij/credentialStore/CredentialStoreKt\n*L\n12#1:89\n*E\n"})
public final class CredentialStoreKt {
    private static final char ESCAPING_CHAR = '\\';

    @NotNull
    public static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PasswordSafeSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @Nullable
    public static final byte[] joinData(@Nullable String user, @Nullable OneTimeString password) {
        if (user == null && password == null) {
            return null;
        }
        String string = user;
        if (string == null) {
            string = "";
        }
        StringBuilder builder = new StringBuilder(string);
        StringUtil.escapeChar((StringBuilder)builder, (char)'\\');
        StringUtil.escapeChar((StringBuilder)builder, (char)'@');
        if (password != null) {
            builder.append('@');
            password.appendTo(builder);
        }
        ByteBuffer buffer = Charsets.UTF_8.encode(CharBuffer.wrap(builder));
        builder.setLength(0);
        Intrinsics.checkNotNull((Object)buffer);
        return IoKt.toByteArray$default((ByteBuffer)buffer, (boolean)false, (int)1, null);
    }

    @Nullable
    public static final Credentials splitData(@Nullable String data) {
        CharSequence charSequence = data;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        List<String> list = CredentialStoreKt.parseString(data, '@');
        return new Credentials((String)CollectionsKt.getOrNull(list, (int)0), (String)CollectionsKt.getOrNull(list, (int)1));
    }

    private static final List<String> parseString(String data, char delimiter) {
        ArrayList<String> result = new ArrayList<String>(2);
        StringBuilder part = new StringBuilder();
        int i = 0;
        Character c = null;
        do {
            if ((c = StringsKt.getOrNull((CharSequence)data, (int)i++)) != null) {
                char c2 = delimiter;
                if (c.charValue() != c2) {
                    c2 = '\\';
                    if (c.charValue() == c2) {
                        c = StringsKt.getOrNull((CharSequence)data, (int)i++);
                    }
                    if (c != null) {
                        part.append(c.charValue());
                        continue;
                    }
                }
            }
            result.add(part.toString());
            part.setLength(0);
            if (i >= data.length()) continue;
            String string = data.substring(i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            result.add(string);
            break;
        } while (c != null);
        return result;
    }

    @NotNull
    public static final SecureRandom createSecureRandom() {
        return new SecureRandom();
    }

    @NotNull
    public static final synchronized byte[] generateBytes(@NotNull SecureRandom $this$generateBytes, int size) {
        Intrinsics.checkNotNullParameter((Object)$this$generateBytes, (String)"<this>");
        byte[] result = new byte[size];
        $this$generateBytes.nextBytes(result);
        return result;
    }
}

