/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.OneTimeStringKt;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.util.io.IoKt;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/credentialStore/kdbx/StringProtectedByStreamCipher;", "Lcom/intellij/credentialStore/kdbx/SecureString;", "value", "", "cipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "<init>", "([BLorg/bouncycastle/crypto/SkippingStreamCipher;)V", "", "(Ljava/lang/CharSequence;Lorg/bouncycastle/crypto/SkippingStreamCipher;)V", "position", "", "data", "get", "Lcom/intellij/credentialStore/OneTimeString;", "clearable", "", "getAsByteArray", "intellij.platform.credentialStore.impl"})
public final class StringProtectedByStreamCipher
implements SecureString {
    @NotNull
    private final SkippingStreamCipher cipher;
    private final long position;
    @NotNull
    private final byte[] data;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringProtectedByStreamCipher(@NotNull byte[] value, @NotNull SkippingStreamCipher cipher) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        this.cipher = cipher;
        long position = 0L;
        this.data = new byte[value.length];
        SkippingStreamCipher skippingStreamCipher = this.cipher;
        synchronized (skippingStreamCipher) {
            boolean bl = false;
            position = this.cipher.getPosition();
            int n = this.cipher.processBytes(value, 0, value.length, this.data, 0);
        }
        this.position = position;
    }

    public StringProtectedByStreamCipher(@NotNull CharSequence value, @NotNull SkippingStreamCipher cipher) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)cipher, (String)"cipher");
        ByteBuffer byteBuffer = Charsets.UTF_8.encode(CharBuffer.wrap(value));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"encode(...)");
        this(IoKt.toByteArray$default((ByteBuffer)byteBuffer, (boolean)false, (int)1, null), cipher);
    }

    @Override
    @NotNull
    public OneTimeString get(boolean clearable) {
        return OneTimeStringKt.OneTimeString$default((byte[])this.getAsByteArray(), (int)0, (int)0, (boolean)clearable, (int)6, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] getAsByteArray() {
        byte[] value = new byte[this.data.length];
        SkippingStreamCipher skippingStreamCipher = this.cipher;
        synchronized (skippingStreamCipher) {
            boolean bl = false;
            this.cipher.seekTo(this.position);
            int n = this.cipher.processBytes(this.data, 0, this.data.length, value, 0);
        }
        return value;
    }
}

