/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.DisposableWrapperList;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ExternalSystemShortcutsManager
implements Disposable {
    private static final String ACTION_ID_PREFIX = "ExternalSystem_";
    @NotNull
    private final Project myProject;
    private final DisposableWrapperList<Listener> myListeners;

    public ExternalSystemShortcutsManager(@NotNull Project project) {
        if (project == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(0);
        }
        this.myListeners = new DisposableWrapperList();
        this.myProject = project;
    }

    public void init() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }

            public void shortcutsChanged(@NotNull Keymap keymap, @NonNls @NotNull Collection<String> actionIds, boolean fromSettings) {
                if (keymap == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actionIds == null) {
                    1.$$$reportNull$$$0(1);
                }
                ExternalSystemShortcutsManager.this.fireShortcutsUpdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "keymap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actionIds";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager$1";
                objectArray[2] = "shortcutsChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public String getActionId(@Nullable String projectPath, @Nullable String taskName) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            File file = new File(portablePath);
            result.append(file.getParentFile() != null ? file.getParentFile().getName() : file.getName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (taskName != null) {
                result.append(taskName);
            }
        }
        String string = result.toString();
        if (string == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    public String getDescription(@Nullable String projectPath, @Nullable String taskName) {
        Shortcut[] shortcuts = this.getShortcuts(projectPath, taskName);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    public boolean hasShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        return this.getShortcuts(projectPath, taskName).length > 0;
    }

    public boolean hasShortcuts(@NotNull String actionId) {
        if (actionId == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(2);
        }
        return KeymapUtil.getPrimaryShortcut((String)actionId) != null;
    }

    private Shortcut @NotNull [] getShortcuts(@Nullable String projectPath, @Nullable String taskName) {
        String actionId = this.getActionId(projectPath, taskName);
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
        if (shortcutArray == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(3);
        }
        return shortcutArray;
    }

    private void fireShortcutsUpdated() {
        for (Listener listener2 : this.myListeners) {
            listener2.shortcutsUpdated();
        }
    }

    public void addListener(Listener listener2, Disposable parent) {
        this.myListeners.add((Object)listener2, parent);
    }

    void scheduleKeymapUpdate(@NotNull Collection<? extends DataNode<TaskData>> taskData) {
        if (taskData == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(4);
        }
        ExternalSystemKeymapExtension.updateActions(this.myProject, taskData);
    }

    void scheduleRunConfigurationKeymapUpdate(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            ExternalSystemShortcutsManager.$$$reportNull$$$0(5);
        }
        ExternalSystemKeymapExtension.updateRunConfigurationActions(this.myProject, externalSystemId);
    }

    public void dispose() {
        ExternalSystemKeymapExtension.clearActions(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalSystemShortcutsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasShortcuts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleKeymapUpdate";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRunConfigurationKeymapUpdate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }

    @FunctionalInterface
    public static interface Listener {
        public void shortcutsUpdated();
    }
}

