/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483638)
@ApiStatus.Internal
public final class ModuleDataService
extends AbstractModuleDataService<ModuleData> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE;
        if (key == null) {
            ModuleDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    @Override
    @Nullable
    public String getExternalModuleType() {
        return null;
    }

    @Override
    public void postProcess(@NotNull Collection<? extends DataNode<ModuleData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            ModuleDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            ModuleDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            ModuleDataService.$$$reportNull$$$0(3);
        }
        super.postProcess(toImport, projectData, project, modelsProvider);
        ModuleDataService.updateLocalSettings(toImport, project);
    }

    private static void updateLocalSettings(Collection<? extends DataNode<ModuleData>> toImport, Project project) {
        if (toImport.isEmpty()) {
            return;
        }
        ProjectSystemId externalSystemId = ((ModuleData)toImport.iterator().next().getData()).getOwner();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        MultiMap grouped = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.PROJECT);
        HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>> data = new HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>>();
        for (Map.Entry entry : grouped.entrySet()) {
            data.put(ExternalProjectPojo.from((Named)((ProjectData)((DataNode)entry.getKey()).getData())), ContainerUtil.map((Collection)((Collection)entry.getValue()), node -> ExternalProjectPojo.from((Named)((ModuleData)node.getData()))));
        }
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        Set<String> pathsToForget = ModuleDataService.detectRenamedProjects(data, settings.getAvailableProjects());
        if (!pathsToForget.isEmpty()) {
            settings.forgetExternalProjects(pathsToForget);
        }
        HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects = new HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>>(settings.getAvailableProjects());
        projects.putAll(data);
        settings.setAvailableProjects(projects);
    }

    @NotNull
    private static Set<String> detectRenamedProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> currentInfo, @NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> oldInfo) {
        if (currentInfo == null) {
            ModuleDataService.$$$reportNull$$$0(4);
        }
        if (oldInfo == null) {
            ModuleDataService.$$$reportNull$$$0(5);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : currentInfo.entrySet()) {
            map.put(entry.getKey().getPath(), entry.getKey().getName());
            for (ExternalProjectPojo pojo : entry.getValue()) {
                map.put(pojo.getPath(), pojo.getName());
            }
        }
        HashSet<String> result = new HashSet<String>();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : oldInfo.entrySet()) {
            String newName = (String)map.get(entry.getKey().getPath());
            if (newName != null && !newName.equals(entry.getKey().getName())) {
                result.add(entry.getKey().getPath());
            }
            for (ExternalProjectPojo pojo : entry.getValue()) {
                newName = (String)map.get(pojo.getPath());
                if (newName == null || newName.equals(pojo.getName())) continue;
                result.add(pojo.getPath());
            }
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            ModuleDataService.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ModuleDataService";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "detectRenamedProjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "detectRenamedProjects";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

