/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ExternalProjectPathLookupElement
extends LookupElement {
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myProjectPath;

    public ExternalProjectPathLookupElement(@NotNull String projectName, @NotNull String projectPath) {
        if (projectName == null) {
            ExternalProjectPathLookupElement.$$$reportNull$$$0(0);
        }
        if (projectPath == null) {
            ExternalProjectPathLookupElement.$$$reportNull$$$0(1);
        }
        this.myProjectName = projectName;
        this.myProjectPath = projectPath;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myProjectName;
        if (string == null) {
            ExternalProjectPathLookupElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            ExternalProjectPathLookupElement.$$$reportNull$$$0(3);
        }
        Editor editor = context.getEditor();
        FoldingModel foldingModel = editor.getFoldingModel();
        foldingModel.runBatchFoldingOperation(() -> {
            FoldRegion[] regions;
            for (FoldRegion region : regions = foldingModel.getAllFoldRegions()) {
                foldingModel.removeFoldRegion(region);
            }
        });
        Document document = editor.getDocument();
        int startOffset = context.getStartOffset();
        document.replaceString(startOffset, document.getTextLength(), (CharSequence)this.myProjectPath);
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        foldingModel.runBatchFoldingOperationDoNotCollapseCaret(() -> {
            FoldRegion region = foldingModel.addFoldRegion(startOffset, startOffset + this.myProjectPath.length(), this.myProjectName);
            if (region != null) {
                region.setExpanded(false);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathLookupElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/ui/ExternalProjectPathLookupElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

