/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.statistics;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.statistics.ProjectImportCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\b\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00032\u0018\u0010\u0010\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012\u0018\u00010\u0011\u00a8\u0006\u0014"}, d2={"getAnonymizedSystemId", "", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "addExternalSystemId", "", "data", "Lcom/intellij/internal/statistic/eventLog/FeatureUsageData;", "anonymizeSystemId", "findPluginInfoBySystemId", "Lcom/intellij/internal/statistic/utils/PluginInfo;", "importActivityStarted", "Lcom/intellij/internal/statistic/StructuredIdeActivity;", "project", "Lcom/intellij/openapi/project/Project;", "externalSystemId", "dataSupplier", "Lkotlin/Function0;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "intellij.platform.externalSystem.impl"})
@SourceDebugExtension(value={"SMAP\nExternalSystemStatUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalSystemStatUtil.kt\ncom/intellij/openapi/externalSystem/statistics/ExternalSystemStatUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class ExternalSystemStatUtilKt {
    @NotNull
    public static final String getAnonymizedSystemId(@NotNull ProjectSystemId systemId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)systemId);
        if (manager == null) {
            String string2;
            boolean isMaven = StringsKt.equals((String)systemId.getId(), (String)"Maven", (boolean)true);
            if (isMaven) {
                String string3 = systemId.getReadableName();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getReadableName(...)");
            } else {
                string2 = "undefined.system";
            }
            return string2;
        }
        if (PluginInfoDetectorKt.getPluginInfo(manager.getClass()).isDevelopedByJetBrains()) {
            String string4 = systemId.getReadableName();
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getReadableName(...)");
        } else {
            string = "third.party";
        }
        return string;
    }

    public static final void addExternalSystemId(@NotNull FeatureUsageData data, @Nullable ProjectSystemId systemId) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        data.addData("system_id", ExternalSystemStatUtilKt.anonymizeSystemId(systemId));
    }

    @NotNull
    public static final String anonymizeSystemId(@Nullable ProjectSystemId systemId) {
        Object object;
        block3: {
            block2: {
                object = systemId;
                if (object == null) break block2;
                ProjectSystemId it = object;
                boolean bl = false;
                String string = ExternalSystemStatUtilKt.getAnonymizedSystemId(it);
                object = string;
                if (string != null) break block3;
            }
            object = "undefined.system";
        }
        return object;
    }

    @Nullable
    public static final PluginInfo findPluginInfoBySystemId(@Nullable ProjectSystemId systemId) {
        if (systemId == null) {
            return null;
        }
        ExternalSystemManager externalSystemManager = ExternalSystemApiUtil.getManager((ProjectSystemId)systemId);
        if (externalSystemManager == null) {
            return null;
        }
        ExternalSystemManager manager = externalSystemManager;
        PluginInfo pluginInfo = PluginInfoDetectorKt.getPluginInfo(manager.getClass());
        return pluginInfo.isDevelopedByJetBrains() ? pluginInfo : null;
    }

    @NotNull
    public static final StructuredIdeActivity importActivityStarted(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable Function0<? extends List<? extends EventPair<?>>> dataSupplier) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalSystemId, (String)"externalSystemId");
        return ProjectImportCollector.IMPORT_ACTIVITY.started(project, () -> ExternalSystemStatUtilKt.importActivityStarted$lambda$0(externalSystemId, dataSupplier));
    }

    private static final List importActivityStarted$lambda$0(ProjectSystemId $externalSystemId, Function0 $dataSupplier) {
        Object[] objectArray = new EventPair[]{ExternalSystemActionsCollector.INSTANCE.getEXTERNAL_SYSTEM_ID().with((Object)ExternalSystemStatUtilKt.anonymizeSystemId($externalSystemId))};
        List data = CollectionsKt.mutableListOf((Object[])objectArray);
        PluginInfo pluginInfo = ExternalSystemStatUtilKt.findPluginInfoBySystemId($externalSystemId);
        if (pluginInfo != null) {
            data.add(EventFields.PluginInfo.with((Object)pluginInfo));
        }
        if ($dataSupplier != null) {
            data.addAll((Collection)$dataSupplier.invoke());
        }
        return data;
    }
}

