/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.BytecodeToolWindowService;
import com.intellij.byteCodeViewer.ShowBytecodeActionKt;
import com.intellij.filename.UniqueNameBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeToolWindowService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "registeredListeners", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/wm/ToolWindow;", "Lcom/intellij/ui/content/ContentManagerListener;", "ensureContentManagerListenerRegistered", "", "toolWindow", "updateTabNames", "Companion", "intellij.java.byteCodeViewer"})
@SourceDebugExtension(value={"SMAP\nBytecodeToolWindowService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BytecodeToolWindowService.kt\ncom/intellij/byteCodeViewer/BytecodeToolWindowService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,116:1\n11705#2:117\n12052#2,3:118\n*S KotlinDebug\n*F\n+ 1 BytecodeToolWindowService.kt\ncom/intellij/byteCodeViewer/BytecodeToolWindowService\n*L\n74#1:117\n74#1:118,3\n*E\n"})
public final class BytecodeToolWindowService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ConcurrentHashMap<ToolWindow, ContentManagerListener> registeredListeners;

    public BytecodeToolWindowService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.registeredListeners = new ConcurrentHashMap();
    }

    public final void ensureContentManagerListenerRegistered(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        ContentManager contentManager = toolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
        ContentManager contentManager2 = contentManager;
        if (this.registeredListeners.containsKey(toolWindow)) {
            return;
        }
        MessageBus messageBus = this.project.getMessageBus();
        Disposable disposable = toolWindow.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        MessageBusConnection messageBusConnection = messageBus.connect(disposable);
        Topic topic = UISettingsListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> BytecodeToolWindowService.ensureContentManagerListenerRegistered$lambda$0(this, toolWindow, arg_0));
        ContentManagerListener listener2 = new ContentManagerListener(this, toolWindow){
            final /* synthetic */ BytecodeToolWindowService this$0;
            final /* synthetic */ ToolWindow $toolWindow;
            {
                this.this$0 = $receiver;
                this.$toolWindow = $toolWindow;
            }

            public void contentAdded(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (UISettings.Companion.getInstance().getShowDirectoryForNonUniqueFilenames()) {
                    this.this$0.updateTabNames(this.$toolWindow);
                }
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (UISettings.Companion.getInstance().getShowDirectoryForNonUniqueFilenames()) {
                    this.this$0.updateTabNames(this.$toolWindow);
                }
            }
        };
        contentManager2.addContentManagerListener(listener2);
        ((Map)this.registeredListeners).put(toolWindow, listener2);
        Disposer.register((Disposable)toolWindow.getDisposable(), () -> BytecodeToolWindowService.ensureContentManagerListenerRegistered$lambda$1(contentManager2, listener2, this, toolWindow, messageBusConnection));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateTabNames(@NotNull ToolWindow toolWindow) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Content[] contentArray = toolWindow.getContentManager().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
        Object[] $this$map$iv = contentArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        int $i$f$mapTo = 0;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void content;
            Content content2 = (Content)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            VirtualFile virtualFile = (VirtualFile)content.getUserData(ShowBytecodeActionKt.getJAVA_CLASS_FILE());
            if (virtualFile == null) {
                throw new IllegalStateException("Content has no JAVA_CLASS_FILE or it is null. Content: " + (Content)content);
            }
            collection.add(virtualFile);
        }
        List javaClassFiles = (List)destination$iv$iv;
        if (javaClassFiles.size() == 1) {
            toolWindow.getContentManager().getContents()[0].setDisplayName(((VirtualFile)javaClassFiles.get(0)).getName());
            return;
        }
        if (UISettings.Companion.getInstance().getShowDirectoryForNonUniqueFilenames()) {
            Object object = VfsUtil.getCommonAncestor((Collection)javaClassFiles);
            if (object == null || (object = object.getPath()) == null) {
                return;
            }
            Object commonAncestor = object;
            UniqueNameBuilder uniqueNameBuilder = new UniqueNameBuilder((String)commonAncestor, "/");
            for (VirtualFile javaClassFile : javaClassFiles) {
                uniqueNameBuilder.addPath((Object)javaClassFile.getPath(), javaClassFile.getPath());
            }
            Content[] contentArray2 = toolWindow.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray2, (String)"getContents(...)");
            for (Content content : contentArray2) {
                String displayName;
                VirtualFile javaClassFile;
                if ((VirtualFile)content.getUserData(ShowBytecodeActionKt.getJAVA_CLASS_FILE()) == null) {
                    throw new IllegalStateException("Content has no JAVA_CLASS_FILE or it is null. Content: " + (Content)content);
                }
                if (uniqueNameBuilder.getShortPath((Object)javaClassFile.getPath()) == null) {
                    throw new IllegalStateException("Cannot get short path for " + javaClassFile.getPath());
                }
                content.setDisplayName(displayName);
            }
        } else {
            Content[] contentArray3 = toolWindow.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray3, (String)"getContents(...)");
            for (Content content : contentArray3) {
                VirtualFile javaClassFile;
                if ((VirtualFile)content.getUserData(ShowBytecodeActionKt.getJAVA_CLASS_FILE()) == null) {
                    throw new IllegalStateException("Content has no JAVA_CLASS_FILE or it is null. Content: " + content);
                }
                content.setDisplayName(javaClassFile.getName());
            }
        }
    }

    private static final void ensureContentManagerListenerRegistered$lambda$0(BytecodeToolWindowService this$0, ToolWindow $toolWindow, UISettings it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateTabNames($toolWindow);
    }

    private static final void ensureContentManagerListenerRegistered$lambda$1(ContentManager $contentManager, ensureContentManagerListenerRegistered.listener.1 $listener, BytecodeToolWindowService this$0, ToolWindow $toolWindow, MessageBusConnection $messageBusConnection) {
        $contentManager.removeContentManagerListener((ContentManagerListener)$listener);
        this$0.registeredListeners.remove($toolWindow);
        $messageBusConnection.disconnect();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeToolWindowService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/byteCodeViewer/BytecodeToolWindowService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.java.byteCodeViewer"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BytecodeToolWindowService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(BytecodeToolWindowService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (BytecodeToolWindowService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

