/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.workspace.storage.impl.IdPerCount;
import com.intellij.platform.workspace.storage.impl.IntIdGenerator;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u000fJ\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/workspace/storage/impl/VirtualFileNameStore;", "", "isRootDirCaseSensitive", "", "<init>", "(Z)V", "generator", "Lcom/intellij/platform/workspace/storage/impl/IntIdGenerator;", "id2NameStore", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "", "name2IdStore", "", "Lcom/intellij/platform/workspace/storage/impl/IdPerCount;", "generateIdForName", "", "name", "removeName", "", "getNameForId", "id", "getIdForName", "(Ljava/lang/String;)Ljava/lang/Integer;", "clear", "intellij.platform.workspace.storage"})
public final class VirtualFileNameStore {
    @NotNull
    private final IntIdGenerator generator = new IntIdGenerator();
    @NotNull
    private final Int2ObjectOpenHashMap<String> id2NameStore = new Int2ObjectOpenHashMap();
    @NotNull
    private final Map<String, IdPerCount> name2IdStore;

    public VirtualFileNameStore(boolean isRootDirCaseSensitive) {
        Map map2;
        if (Registry.Companion.is("ide.new.project.model.index.case.sensitivity", false) && !isRootDirCaseSensitive) {
            Map map3 = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)HashingStrategy.caseInsensitive());
            map2 = map3;
            Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createCustomHashingStrategyMap(...)");
        } else {
            Map map4 = CollectionFactory.createSmallMemoryFootprintMap();
            map2 = map4;
            Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"createSmallMemoryFootprintMap(...)");
        }
        this.name2IdStore = map2;
    }

    public final int generateIdForName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IdPerCount idPerCount = this.name2IdStore.get(name);
        if (idPerCount != null) {
            IdPerCount idPerCount2 = idPerCount;
            long l = idPerCount2.getUsageCount();
            idPerCount2.setUsageCount(l + 1L);
            return idPerCount.getId();
        }
        int id = this.generator.generateId();
        this.name2IdStore.put(name, new IdPerCount(id, 1L));
        this.id2NameStore.put(id, (Object)name);
        return id;
    }

    public final void removeName(@NotNull String name) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IdPerCount idPerCount = this.name2IdStore.get(name);
        if (idPerCount == null) {
            return;
        }
        IdPerCount idPerCount2 = idPerCount;
        if (idPerCount2.getUsageCount() == 1L) {
            this.name2IdStore.remove(name);
            object = this.id2NameStore.remove(idPerCount2.getId());
        } else {
            long l = idPerCount2.getUsageCount();
            idPerCount2.setUsageCount(l + -1L);
            object = l;
        }
    }

    @Nullable
    public final String getNameForId(int id) {
        return (String)this.id2NameStore.get(id);
    }

    @Nullable
    public final Integer getIdForName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IdPerCount idPerCount = this.name2IdStore.get(name);
        return idPerCount != null ? Integer.valueOf(idPerCount.getId()) : null;
    }

    @TestOnly
    public final void clear() {
        this.name2IdStore.clear();
        this.id2NameStore.clear();
        this.generator.clear();
    }
}

