/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.query;

import com.intellij.platform.workspace.storage.ImmutableEntityStorage;
import com.intellij.platform.workspace.storage.impl.cache.PropagationResult;
import com.intellij.platform.workspace.storage.impl.query.Cell;
import com.intellij.platform.workspace.storage.impl.query.CellId;
import com.intellij.platform.workspace.storage.impl.query.Match;
import com.intellij.platform.workspace.storage.impl.query.MatchList;
import com.intellij.platform.workspace.storage.impl.query.TokenKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\r\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/platform/workspace/storage/impl/query/DiffCollectorCell;", "T", "Lcom/intellij/platform/workspace/storage/impl/query/Cell;", "id", "Lcom/intellij/platform/workspace/storage/impl/query/CellId;", "addedData", "", "removedData", "<init>", "(Lcom/intellij/platform/workspace/storage/impl/query/CellId;Ljava/util/List;Ljava/util/List;)V", "getAddedData", "()Ljava/util/List;", "getRemovedData", "input", "Lcom/intellij/platform/workspace/storage/impl/cache/PropagationResult;", "prevData", "Lcom/intellij/platform/workspace/storage/impl/query/MatchList;", "newSnapshot", "Lcom/intellij/platform/workspace/storage/ImmutableEntityStorage;", "prevSnapshot", "data", "()Ljava/lang/Object;", "intellij.platform.workspace.storage"})
@SourceDebugExtension(value={"SMAP\nCell.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cell.kt\ncom/intellij/platform/workspace/storage/impl/query/DiffCollectorCell\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n1915#2,2:284\n1915#2,2:286\n*S KotlinDebug\n*F\n+ 1 Cell.kt\ncom/intellij/platform/workspace/storage/impl/query/DiffCollectorCell\n*L\n60#1:284,2\n64#1:286,2\n*E\n"})
public final class DiffCollectorCell<T>
extends Cell<T> {
    @NotNull
    private final List<T> addedData;
    @NotNull
    private final List<T> removedData;

    public DiffCollectorCell(@NotNull CellId id, @NotNull List<? extends T> addedData, @NotNull List<? extends T> removedData) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(addedData, (String)"addedData");
        Intrinsics.checkNotNullParameter(removedData, (String)"removedData");
        super(id, null);
        this.addedData = addedData;
        this.removedData = removedData;
    }

    @NotNull
    public final List<T> getAddedData() {
        return this.addedData;
    }

    @NotNull
    public final List<T> getRemovedData() {
        return this.removedData;
    }

    @Override
    @NotNull
    public PropagationResult<T> input(@NotNull MatchList prevData, @NotNull ImmutableEntityStorage newSnapshot) {
        Intrinsics.checkNotNullParameter((Object)prevData, (String)"prevData");
        Intrinsics.checkNotNullParameter((Object)newSnapshot, (String)"newSnapshot");
        throw new IllegalStateException("Another input should be called".toString());
    }

    @NotNull
    public final PropagationResult<T> input(@NotNull MatchList prevData, @NotNull ImmutableEntityStorage newSnapshot, @Nullable ImmutableEntityStorage prevSnapshot) {
        Match it;
        Intrinsics.checkNotNullParameter((Object)prevData, (String)"prevData");
        Intrinsics.checkNotNullParameter((Object)newSnapshot, (String)"newSnapshot");
        ArrayList<Object> newAddedData = new ArrayList<Object>();
        ArrayList<Object> newRemovedData = new ArrayList<Object>();
        Iterable $this$forEach$iv = prevData.removedMatches();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Match)element$iv;
            boolean bl = false;
            if (prevSnapshot == null) {
                throw new IllegalStateException("Prev snapshot cannot be null for diff".toString());
            }
            newRemovedData.add(TokenKt.getData(it, prevSnapshot));
        }
        $this$forEach$iv = prevData.addedMatches();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Match)element$iv;
            boolean bl = false;
            newAddedData.add(TokenKt.getData(it, newSnapshot));
        }
        DiffCollectorCell<T> newCell = new DiffCollectorCell<T>(this.getId(), (List)newAddedData, (List)newRemovedData);
        return new PropagationResult(newCell, new MatchList(), CollectionsKt.emptyList());
    }

    @Override
    public T data() {
        throw new IllegalStateException("Should not be accessed".toString());
    }
}

