/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.icons.SuffixPathTransform;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007\u001a@\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0010H\u0002\u001a>\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0007\u001a(\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00180\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0019"}, d2={"createImageDescriptorList", "", "Lcom/intellij/ui/icons/ImageDescriptor;", "path", "", "isDark", "", "isStroke", "pixScale", "", "addFileNameVariant", "", "isRetina", "isSvg", "scale", "list", "", "createImageDescriptorTransformListWithSizeSpecialization", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "originalWidth", "", "originalHeight", "createCommonImagePathTransforms", "Lkotlin/Function2;", "intellij.platform.util.ui"})
public final class ImageDescriptorKt {
    @ApiStatus.Internal
    @NotNull
    public static final List<ImageDescriptor> createImageDescriptorList(@NotNull String path, boolean isDark, boolean isStroke, float pixScale) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!StringsKt.startsWith$default((String)path, (String)"file:/", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)path, (CharSequence)"://", (boolean)false, (int)2, null)) {
            String string;
            int qI = StringsKt.lastIndexOf$default((CharSequence)path, (char)'?', (int)0, (boolean)false, (int)6, null);
            if (qI == -1) {
                string = path;
            } else {
                String string2 = path.substring(0, qI);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            boolean isSvg = StringsKt.endsWith((String)string, (String)".svg", (boolean)true);
            return CollectionsKt.listOf((Object)new ImageDescriptor((Function2<? super String, ? super String, String>)((Function2)new SuffixPathTransform("")), 1.0f, isSvg, isDark, false));
        }
        boolean isSvg = StringsKt.endsWith$default((String)path, (String)".svg", (boolean)false, (int)2, null);
        boolean isRetina = !(pixScale == 1.0f);
        ArrayList list = new ArrayList(5);
        if (isStroke) {
            ImageDescriptorKt.addFileNameVariant(isRetina, false, isSvg, true, pixScale, list);
        }
        if (!isSvg) {
            ImageDescriptorKt.addFileNameVariant$default(isRetina, isDark, false, false, pixScale, list, 8, null);
        }
        ImageDescriptorKt.addFileNameVariant$default(isRetina, isDark, isSvg, false, pixScale, list, 8, null);
        if (isDark) {
            ImageDescriptorKt.addFileNameVariant$default(isRetina, false, isSvg, false, pixScale, list, 8, null);
            if (!isSvg) {
                ImageDescriptorKt.addFileNameVariant$default(false, false, true, false, pixScale, list, 8, null);
            }
        }
        return list;
    }

    private static final void addFileNameVariant(boolean isRetina, boolean isDark, boolean isSvg, boolean isStroke, float scale, List<ImageDescriptor> list) {
        float nonRetinaScale;
        float retinaScale = isSvg ? scale : 2.0f;
        float f = nonRetinaScale = isSvg ? scale : 1.0f;
        if (isStroke) {
            float strokeScale = isRetina ? retinaScale : nonRetinaScale;
            ImageDescriptor d = new ImageDescriptor((Function2<? super String, ? super String, String>)((Function2)new SuffixPathTransform("_stroke")), strokeScale, isSvg, isDark, true);
            v1 = list.add(d);
        } else if (isDark) {
            ImageDescriptor d1 = new ImageDescriptor(new SuffixPathTransform("@2x_dark"), retinaScale, isSvg, true, false, 16, null);
            ImageDescriptor d2 = new ImageDescriptor(new SuffixPathTransform("_dark@2x"), retinaScale, isSvg, true, false, 16, null);
            ImageDescriptor d3 = new ImageDescriptor(new SuffixPathTransform("_dark"), nonRetinaScale, isSvg, true, false, 16, null);
            if (isRetina) {
                list.add(d1);
                list.add(d2);
                v1 = list.add(d3);
            } else {
                list.add(d3);
                list.add(d2);
                v1 = list.add(d1);
            }
        } else {
            ImageDescriptor d1 = new ImageDescriptor(new SuffixPathTransform("@2x"), retinaScale, isSvg, false, false, 24, null);
            ImageDescriptor d2 = new ImageDescriptor(new SuffixPathTransform(""), nonRetinaScale, isSvg, false, false, 24, null);
            if (isRetina) {
                list.add(d1);
                v1 = list.add(d2);
            } else {
                list.add(d2);
                v1 = list.add(d1);
            }
        }
    }

    static /* synthetic */ void addFileNameVariant$default(boolean bl, boolean bl2, boolean bl3, boolean bl4, float f, List list, int n, Object object) {
        if ((n & 8) != 0) {
            bl4 = false;
        }
        ImageDescriptorKt.addFileNameVariant(bl, bl2, bl3, bl4, f, list);
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<ImageDescriptor> createImageDescriptorTransformListWithSizeSpecialization(@NotNull String path, boolean isDark, boolean isStroke, @NotNull ScaleContext scaleContext, int originalWidth, int originalHeight) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        boolean isSvg = StringsKt.endsWith$default((String)path, (String)".svg", (boolean)false, (int)2, null);
        ArrayList sizeSpecializedDescriptors = new ArrayList(2);
        if (isSvg) {
            float objScale = (float)scaleContext.getScale(ScaleType.OBJ_SCALE);
            int scaledWidth = (int)((float)originalWidth * objScale);
            int scaledHeight = (int)((float)originalHeight * objScale);
            if (isDark) {
                ((Collection)sizeSpecializedDescriptors).add(new ImageDescriptor(new SuffixPathTransform("@" + scaledWidth + "x" + scaledHeight + "_dark"), pixScale / objScale, true, true, false, 16, null));
            }
            ((Collection)sizeSpecializedDescriptors).add(new ImageDescriptor(new SuffixPathTransform("@" + scaledWidth + "x" + scaledHeight), pixScale / objScale, true, false, false, 16, null));
        }
        List<ImageDescriptor> defaultDescriptors = ImageDescriptorKt.createImageDescriptorList(path, isDark, isStroke, pixScale);
        return CollectionsKt.plus((Collection)sizeSpecializedDescriptors, (Iterable)defaultDescriptors);
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<Function2<String, String, String>> createCommonImagePathTransforms(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = new SuffixPathTransform[]{new SuffixPathTransform(""), new SuffixPathTransform("_stroke"), new SuffixPathTransform("@2x_dark"), new SuffixPathTransform("_dark@2x"), new SuffixPathTransform("_dark"), new SuffixPathTransform("@2x")};
        List transforms = CollectionsKt.mutableListOf((Object[])object);
        object = CollectionsKt.listOf((Object)20).iterator();
        while (object.hasNext()) {
            int customSize = ((Number)object.next()).intValue();
            ((Collection)transforms).add(new SuffixPathTransform("@" + customSize + "x" + customSize + "_dark"));
            ((Collection)transforms).add(new SuffixPathTransform("@" + customSize + "x" + customSize));
        }
        return transforms;
    }
}

