/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.util.Consumer;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SetTodoFilterAction
extends ActionGroup
implements DumbAware {
    private final Project myProject;
    private final TodoPanelSettings myToDoSettings;
    private final Consumer<? super TodoFilter> myTodoFilterConsumer;

    public SetTodoFilterAction(@NotNull Project project, @NotNull TodoPanelSettings toDoSettings, @NotNull Consumer<? super TodoFilter> todoFilterConsumer) {
        if (project == null) {
            SetTodoFilterAction.$$$reportNull$$$0(0);
        }
        if (toDoSettings == null) {
            SetTodoFilterAction.$$$reportNull$$$0(1);
        }
        if (todoFilterConsumer == null) {
            SetTodoFilterAction.$$$reportNull$$$0(2);
        }
        super(IdeBundle.message((String)"action.filter.todo.items", (Object[])new Object[0]), null, AllIcons.General.Filter);
        this.setPopup(true);
        this.myProject = project;
        this.myToDoSettings = toDoSettings;
        this.myTodoFilterConsumer = todoFilterConsumer;
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray = SetTodoFilterAction.createPopupActionGroup(this.myProject, this.myToDoSettings, false, this.myTodoFilterConsumer).getChildren(e);
        if (anActionArray == null) {
            SetTodoFilterAction.$$$reportNull$$$0(3);
        }
        return anActionArray;
    }

    public static DefaultActionGroup createPopupActionGroup(final @NotNull Project project, @NotNull TodoPanelSettings settings, boolean skipShowAllWithoutFilters, @NotNull Consumer<? super TodoFilter> todoFilterConsumer) {
        if (project == null) {
            SetTodoFilterAction.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            SetTodoFilterAction.$$$reportNull$$$0(5);
        }
        if (todoFilterConsumer == null) {
            SetTodoFilterAction.$$$reportNull$$$0(6);
        }
        TodoFilter[] filters = TodoConfiguration.getInstance().getTodoFilters();
        DefaultActionGroup group = new DefaultActionGroup();
        if (!skipShowAllWithoutFilters || filters.length != 0) {
            group.add((AnAction)new TodoFilterApplier(IdeBundle.message((String)"action.todo.show.all", (Object[])new Object[0]), IdeBundle.message((String)"action.description.todo.show.all", (Object[])new Object[0]), null, settings, todoFilterConsumer));
        }
        for (TodoFilter filter : filters) {
            group.add((AnAction)new TodoFilterApplier(filter.getName(), null, filter, settings, todoFilterConsumer));
        }
        group.addSeparator();
        group.add((AnAction)new DumbAwareAction(IdeBundle.messagePointer((String)"action.todo.edit.filters", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.todo.edit.filters.description", (Object[])new Object[0]), AllIcons.General.Settings){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().showSettingsDialog(project, IdeBundle.message((String)"title.todo", (Object[])new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/SetTodoFilterAction$1", "actionPerformed"));
            }
        });
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toDoSettings";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoFilterConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/SetTodoFilterAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/SetTodoFilterAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopupActionGroup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class TodoFilterApplier
    extends ToggleAction
    implements DumbAware {
        private final TodoFilter myFilter;
        private final TodoPanelSettings mySettings;
        private final Consumer<? super TodoFilter> myTodoFilterConsumer;

        TodoFilterApplier(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, TodoFilter filter, TodoPanelSettings settings, Consumer<? super TodoFilter> todoFilterConsumer) {
            super(null, description, null);
            this.mySettings = settings;
            this.myTodoFilterConsumer = todoFilterConsumer;
            this.getTemplatePresentation().setText(text, false);
            this.myFilter = filter;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(0);
            }
            super.update(e);
            if (this.myFilter != null) {
                e.getPresentation().setEnabled(!this.myFilter.isEmpty());
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                TodoFilterApplier.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(2);
            }
            String arg1 = this.myFilter != null ? this.myFilter.getName() : null;
            return Objects.equals(arg1, this.mySettings.todoFilterName);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                TodoFilterApplier.$$$reportNull$$$0(3);
            }
            if (state) {
                this.myTodoFilterConsumer.consume((Object)this.myFilter);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/todo/SetTodoFilterAction$TodoFilterApplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/todo/SetTodoFilterAction$TodoFilterApplier";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

