/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class FilePosition {
    private final File myFile;
    private final int myStartLine;
    private final int myStartColumn;
    private final int myEndLine;
    private final int myEndColumn;

    public FilePosition(File file, int line, int column) {
        this(file, line, column, line, column);
    }

    public FilePosition(File file, int startLine, int startColumn, int endLine, int endColumn) {
        this.myFile = file;
        this.myStartLine = startLine;
        this.myStartColumn = startColumn;
        this.myEndLine = endLine;
        this.myEndColumn = endColumn;
    }

    @Nullable
    public File getFile() {
        return this.myFile;
    }

    public int getStartLine() {
        return this.myStartLine;
    }

    public int getStartColumn() {
        return this.myStartColumn;
    }

    public int getEndLine() {
        return this.myEndLine;
    }

    public int getEndColumn() {
        return this.myEndColumn;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePosition position = (FilePosition)o;
        return this.myStartLine == position.myStartLine && this.myStartColumn == position.myStartColumn && this.myEndLine == position.myEndLine && this.myEndColumn == position.myEndColumn && Objects.equals(this.myFile, position.myFile);
    }

    public int hashCode() {
        return Objects.hash(this.myFile, this.myStartLine, this.myStartColumn, this.myEndLine, this.myEndColumn);
    }
}

