/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.data;

import com.intellij.collaboration.ui.html.AsyncHtmlImageLoader;
import com.intellij.collaboration.ui.icon.AsyncImageIconsProvider;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ImageUtil;
import icons.CollaborationToolsIcons;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URL;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabApi;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDTO;
import org.jetbrains.plugins.gitlab.api.request.GitLabUsersApiKt;
import org.jetbrains.plugins.gitlab.data.GitLabImageLoader;
import org.jetbrains.plugins.gitlab.data.GitLabImageLoaderKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0096@\u00a2\u0006\u0002\u0010\rJ\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0096@\u00a2\u0006\u0002\u0010\u0012J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0016\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/gitlab/data/GitLabImageLoader;", "Lcom/intellij/collaboration/ui/icon/AsyncImageIconsProvider$AsyncImageLoader;", "Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;", "Lcom/intellij/collaboration/ui/html/AsyncHtmlImageLoader;", "apiClient", "Lorg/jetbrains/plugins/gitlab/api/GitLabApi;", "gitLabProjectCoordinates", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "<init>", "(Lorg/jetbrains/plugins/gitlab/api/GitLabApi;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;)V", "load", "Ljava/awt/Image;", "key", "(Lorg/jetbrains/plugins/gitlab/api/dto/GitLabUserDTO;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "baseUrl", "Ljava/net/URL;", "src", "", "(Ljava/net/URL;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createBaseIcon", "Ljavax/swing/Icon;", "iconSize", "", "postProcess", "image", "(Ljava/awt/Image;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.gitlab"})
public final class GitLabImageLoader
implements AsyncImageIconsProvider.AsyncImageLoader<GitLabUserDTO>,
AsyncHtmlImageLoader {
    @NotNull
    private final GitLabApi apiClient;
    @NotNull
    private final GitLabProjectCoordinates gitLabProjectCoordinates;

    public GitLabImageLoader(@NotNull GitLabApi apiClient, @NotNull GitLabProjectCoordinates gitLabProjectCoordinates) {
        Intrinsics.checkNotNullParameter((Object)apiClient, (String)"apiClient");
        Intrinsics.checkNotNullParameter((Object)gitLabProjectCoordinates, (String)"gitLabProjectCoordinates");
        this.apiClient = apiClient;
        this.gitLabProjectCoordinates = gitLabProjectCoordinates;
    }

    @Nullable
    public Object load(@NotNull GitLabUserDTO key, @NotNull Continuation<? super Image> $completion) {
        Image image;
        String string = key.getAvatarUrl();
        if (string != null) {
            String avatarUrl = string;
            boolean bl = false;
            String actualUri = StringsKt.startsWith$default((String)avatarUrl, (String)"http", (boolean)false, (int)2, null) ? avatarUrl : (StringsKt.startsWith$default((String)avatarUrl, (String)"/avatar", (boolean)false, (int)2, null) ? "https://secure.gravatar.com" + avatarUrl + "?s=80&d=identicon" : this.gitLabProjectCoordinates.getServerPath().getUri() + avatarUrl);
            Object object = this.load(null, actualUri, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            image = (Image)object;
        } else {
            image = null;
        }
        return image;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object load(@Nullable URL baseUrl, @NotNull String src, @NotNull Continuation<? super Image> $completion) {
        if (!($completion instanceof load.3)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GitLabImageLoader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.load(null, null, (Continuation<? super Image>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                uri = URI.create(src);
                Intrinsics.checkNotNull((Object)uri);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)baseUrl);
                $continuation.L$1 = src;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)uri);
                $continuation.label = 1;
                v0 = GitLabUsersApiKt.loadImage(this.apiClient, uri, (Continuation<? super Image>)$continuation);
                ** if (v0 != var8_6) goto lbl23
lbl22:
                // 1 sources

                return var8_6;
lbl23:
                // 1 sources

                ** GOTO lbl32
            }
            case 1: {
                uri = (URI)$continuation.L$2;
                src = (String)$continuation.L$1;
                baseUrl = (URL)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl32:
                    // 2 sources

                    return v0;
                }
                catch (CancellationException ce) {
                    throw ce;
                }
                catch (Exception e) {
                    GitLabImageLoaderKt.access$getLOG$p().warn("Failed to load the image from src " + src, (Throwable)e);
                    throw e;
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public Icon createBaseIcon(@Nullable GitLabUserDTO key, int iconSize) {
        Icon icon = CollaborationToolsIcons.Review.DefaultAvatar;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"DefaultAvatar");
        return IconUtil.resizeSquared((Icon)icon, (int)iconSize);
    }

    @Nullable
    public Object postProcess(@NotNull Image image, @NotNull Continuation<? super Image> $completion) {
        BufferedImage bufferedImage = ImageUtil.createCircleImage((BufferedImage)ImageUtil.toBufferedImage((Image)image));
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createCircleImage(...)");
        return bufferedImage;
    }
}

