/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.project.Project;
import com.intellij.refactoring.rename.api.PsiModifiableRenameUsage;
import com.intellij.refactoring.rename.api.RenameTarget;
import com.intellij.refactoring.rename.api.RenameUsage;
import com.intellij.refactoring.rename.api.RenameUsageSearchParameters;
import com.intellij.refactoring.rename.api.RenameUsageSearcher;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectReference;
import org.jetbrains.plugins.gradle.service.resolve.GradleProjectSymbol;
import org.jetbrains.plugins.gradle.service.resolve.ProjectReferenceSearchKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/plugins/gradle/service/resolve/GradleProjectRenameUsageSearcher;", "Lcom/intellij/refactoring/rename/api/RenameUsageSearcher;", "<init>", "()V", "collectSearchRequest", "Lcom/intellij/util/Query;", "Lcom/intellij/refactoring/rename/api/RenameUsage;", "parameters", "Lcom/intellij/refactoring/rename/api/RenameUsageSearchParameters;", "intellij.gradle.java"})
public final class GradleProjectRenameUsageSearcher
implements RenameUsageSearcher {
    @Nullable
    public Query<? extends RenameUsage> collectSearchRequest(@NotNull RenameUsageSearchParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        RenameTarget renameTarget = parameters.getTarget();
        GradleProjectSymbol gradleProjectSymbol = renameTarget instanceof GradleProjectSymbol ? (GradleProjectSymbol)renameTarget : null;
        if (gradleProjectSymbol == null) {
            return null;
        }
        GradleProjectSymbol projectSymbol = gradleProjectSymbol;
        Project project = parameters.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return ProjectReferenceSearchKt.searchGradleProjectReferences(project, projectSymbol, parameters.getSearchScope()).mapping(arg_0 -> GradleProjectRenameUsageSearcher.collectSearchRequest$lambda$1(GradleProjectRenameUsageSearcher::collectSearchRequest$lambda$0, arg_0));
    }

    private static final PsiModifiableRenameUsage collectSearchRequest$lambda$0(GradleProjectReference it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return PsiModifiableRenameUsage.Companion.defaultPsiModifiableRenameUsage(PsiUsage.Companion.textUsage((PsiSymbolReference)it));
    }

    private static final PsiModifiableRenameUsage collectSearchRequest$lambda$1(Function1 $tmp0, Object p0) {
        return (PsiModifiableRenameUsage)$tmp0.invoke(p0);
    }
}

