/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.toml;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.UseScopeEnlarger;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.config.GradleBuildscriptSearchScope;
import org.jetbrains.plugins.gradle.service.resolve.GradleVersionCatalogHandlerKt;
import org.toml.lang.psi.TomlElement;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/service/toml/GradleTomlUseScopeEnlarger;", "Lcom/intellij/psi/search/UseScopeEnlarger;", "<init>", "()V", "getAdditionalUseScope", "Lcom/intellij/psi/search/SearchScope;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.gradle.java"})
public final class GradleTomlUseScopeEnlarger
extends UseScopeEnlarger {
    @Nullable
    public SearchScope getAdditionalUseScope(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof TomlElement)) {
            return null;
        }
        PsiFile psiFile = ((TomlElement)element).getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        PsiFile containingFile = psiFile;
        Project project = ((TomlElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Collection<VirtualFile> versionCatalogFiles = GradleVersionCatalogHandlerKt.getVersionCatalogFiles(project).values();
        if (!versionCatalogFiles.contains(containingFile)) {
            return null;
        }
        Project project2 = ((TomlElement)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return (SearchScope)new GradleBuildscriptSearchScope(project2);
    }
}

