/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalProcessAuthHelper;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtil;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ScriptGeneratorUtil {
    private ScriptGeneratorUtil() {
    }

    @NotNull
    private static File createBatchScript(@NotNull @NonNls String fileName, @NotNull @NonNls String commandLine) throws IOException {
        if (fileName == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(0);
        }
        if (commandLine == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(1);
        }
        String batchScriptText = "@echo off\r\n" + commandLine + " %*\r\n";
        return ScriptGeneratorUtil.createTempExecutable(fileName + ".bat", batchScriptText);
    }

    @NotNull
    private static File createShellScript(@NotNull @NonNls String fileName, @NotNull @NonNls String commandLine) throws IOException {
        if (fileName == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(2);
        }
        if (commandLine == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(3);
        }
        String shellText = "#!/bin/sh\n" + commandLine + " \"$@\"\n";
        return ScriptGeneratorUtil.createTempExecutable(fileName + ".sh", shellText);
    }

    @NotNull
    private static File createTempExecutable(@NotNull @NonNls String fileName, @NotNull @NonNls String content) throws IOException {
        if (fileName == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(4);
        }
        if (content == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(5);
        }
        File file = new File(PathManager.getTempPath(), fileName);
        FileUtil.writeToFile((File)file, (String)content);
        FileUtil.setExecutable((File)file);
        File file2 = file;
        if (file2 == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(6);
        }
        return file2;
    }

    @NotNull
    public static File createTempScript(@NotNull String commandLine, @NotNull String fileNamePrefix, boolean useBatchFile) throws IOException {
        if (commandLine == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(7);
        }
        if (fileNamePrefix == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(8);
        }
        return useBatchFile ? ScriptGeneratorUtil.createBatchScript(fileNamePrefix, commandLine) : ScriptGeneratorUtil.createShellScript(fileNamePrefix, commandLine);
    }

    @NotNull
    public static File getJarFileFor(@NotNull Class<?> clazz) {
        if (clazz == null) {
            ScriptGeneratorUtil.$$$reportNull$$$0(9);
        }
        return new File(PathUtil.getJarPathForClass(clazz));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalProcessAuthHelper/ScriptGeneratorUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNamePrefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalProcessAuthHelper/ScriptGeneratorUtil";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempExecutable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createBatchScript";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createShellScript";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTempExecutable";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createTempScript";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getJarFileFor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

