/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.cmdline;

import com.dynatrace.hash4j.hashing.Hashing;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.Gson;
import com.google.protobuf.Message;
import com.intellij.compiler.notNullVerification.NotNullVerifyingInstrumenter;
import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.ClassPathUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.platform.eel.fs.EelFiles;
import com.intellij.tracing.Tracer;
import com.intellij.uiDesigner.compiler.AlienFormFileException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.JavaVersion;
import com.jgoodies.forms.layout.CellConstraints;
import com.thoughtworks.qdox.JavaProjectBuilder;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import kotlin.metadata.jvm.JvmMetadataUtil;
import kotlinx.coroutines.Deferred;
import net.n3.nanoxml.IXMLBuilder;
import org.h2.mvstore.MVStore;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.jps.builders.impl.java.EclipseCompilerTool;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;
import org.jetbrains.jps.cmdline.BuildMain;
import org.jetbrains.jps.dependency.DependencyGraph;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.javac.ast.JavacReferenceCollector;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsModelImpl;
import org.jetbrains.jps.model.serialization.JpsMavenSettings;
import org.jetbrains.jps.model.serialization.JpsProjectLoader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

@ApiStatus.Internal
public final class ClasspathBootstrap {
    private static final Logger LOG = Logger.getInstance(ClasspathBootstrap.class);
    private static final Class<?>[] COMMON_REQUIRED_CLASSES = new Class[]{Message.class};
    private static final String[] REFLECTION_OPEN_PACKAGES = new String[]{"java.base/sun.nio=ALL-UNNAMED", "java.base/sun.nio.ch=ALL-UNNAMED", "java.base/jdk.internal.ref=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.code=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.comp=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.file=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.main=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.model=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.parser=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.processing=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.tree=ALL-UNNAMED", "jdk.compiler/com.sun.tools.javac.jvm=ALL-UNNAMED"};
    private static final String[] FORBIDDEN_JARS = new String[]{"app.jar", "app-backend.java"};
    @VisibleForTesting
    public static final String NETTY_JPS_VERSION = "4.1.117.Final";
    private static final String NETTY_JPS_DISTRIBUTION_JAR_NAME = "netty-jps.jar";
    private static final String[] NETTY_ARTIFACT_NAMES = new String[]{"netty-buffer", "netty-codec-http", "netty-codec", "netty-common", "netty-handler", "netty-resolver", "netty-transport"};

    private ClasspathBootstrap() {
    }

    private static void getNettyForJpsClasspath(Consumer<Path> consumer) {
        Path rootPath = Path.of(ClasspathBootstrap.getResourcePath(ExternalJavacProcess.class), new String[0]);
        Path nettyDistributionPath = rootPath.resolveSibling("rt").resolve(NETTY_JPS_DISTRIBUTION_JAR_NAME);
        if (Files.isRegularFile(rootPath, new LinkOption[0]) && Files.exists(nettyDistributionPath, new LinkOption[0])) {
            consumer.accept(nettyDistributionPath);
        } else {
            Path artifactRoot = Path.of(JpsMavenSettings.getMavenRepositoryPath(), new String[0]).resolve("io").resolve("netty");
            for (String artifactName : NETTY_ARTIFACT_NAMES) {
                consumer.accept(artifactRoot.resolve(artifactName).resolve(NETTY_JPS_VERSION).resolve(artifactName + "-4.1.117.Final.jar"));
            }
        }
    }

    private static void addToClassPath(Set<String> result, Class<?> aClass) {
        Path path = PathManager.getJarForClass(aClass);
        if (path == null) {
            return;
        }
        String pathString = path.toString();
        if (result.add(pathString)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(pathString + " added to classpath to include " + aClass.getName());
            }
            ClasspathBootstrap.assertPathDoesNotContainTheWholeWorld(pathString, path, aClass);
        }
    }

    private static void assertPathDoesNotContainTheWholeWorld(@NotNull String pathString, @NotNull Path path, @NotNull Class<?> aClass) {
        if (pathString == null) {
            ClasspathBootstrap.$$$reportNull$$$0(0);
        }
        if (path == null) {
            ClasspathBootstrap.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            ClasspathBootstrap.$$$reportNull$$$0(2);
        }
        for (String jarName : FORBIDDEN_JARS) {
            if (!pathString.endsWith(jarName) || !path.getFileName().toString().equals(jarName) || !path.getParent().equals(Paths.get(PathManager.getLibPath(), new String[0]))) continue;
            LOG.error("Due to " + aClass.getName() + " requirement, inappropriate " + pathString + " is added to build process classpath");
        }
    }

    private static void addToClassPath(Set<String> cp, @NotNull @NotNull Class<?> @NotNull [] classes) {
        if (classes == null) {
            ClasspathBootstrap.$$$reportNull$$$0(3);
        }
        for (Class<?> aClass : classes) {
            ClasspathBootstrap.addToClassPath(cp, aClass);
        }
    }

    @NotNull
    public static Collection<String> getBuildProcessApplicationClasspath() {
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        ClasspathBootstrap.addToClassPath(cp, BuildMain.class);
        ClasspathBootstrap.addToClassPath(cp, ExternalJavacProcess.class);
        ClasspathBootstrap.addToClassPath(cp, JavacReferenceCollector.class);
        ClasspathBootstrap.addToClassPath(cp, DependencyGraph.class);
        ClasspathBootstrap.addToClassPath(cp, ClassPathUtil.getUtilClasses());
        ClasspathBootstrap.addToClassPath(cp, HashMapZipFile.class);
        ClassPathUtil.addKotlinStdlib(cp);
        ClasspathBootstrap.addToClassPath(cp, Deferred.class);
        ClasspathBootstrap.addToClassPath(cp, JvmMetadataUtil.class);
        ClasspathBootstrap.addToClassPath(cp, COMMON_REQUIRED_CLASSES);
        ClasspathBootstrap.getNettyForJpsClasspath(path -> cp.add(path.toString()));
        ClasspathBootstrap.addToClassPath(cp, ClassWriter.class);
        ClasspathBootstrap.addToClassPath(cp, ClassVisitor.class);
        ClasspathBootstrap.addToClassPath(cp, JpsModel.class);
        ClasspathBootstrap.addToClassPath(cp, JpsModelImpl.class);
        ClasspathBootstrap.addToClassPath(cp, JpsProjectLoader.class);
        ClasspathBootstrap.addToClassPath(cp, JavaVersion.class);
        ClasspathBootstrap.addToClassPath(cp, Strings.class);
        ClasspathBootstrap.addToClassPath(cp, AlienFormFileException.class);
        ClasspathBootstrap.addToClassPath(cp, GridConstraints.class);
        ClasspathBootstrap.addToClassPath(cp, CellConstraints.class);
        cp.addAll(ClasspathBootstrap.getInstrumentationUtilRoots());
        ClasspathBootstrap.addToClassPath(cp, IXMLBuilder.class);
        ClasspathBootstrap.addToClassPath(cp, JavaProjectBuilder.class);
        ClasspathBootstrap.addToClassPath(cp, Gson.class);
        ClasspathBootstrap.addToClassPath(cp, Caffeine.class);
        ClasspathBootstrap.addToClassPath(cp, Hashing.class);
        ClasspathBootstrap.addToClassPath(cp, MVStore.class);
        ClasspathBootstrap.addToClassPath(cp, ArtifactRepositoryManager.getClassesFromDependencies());
        ClasspathBootstrap.addToClassPath(cp, Tracer.class);
        ClasspathBootstrap.addToClassPath(cp, EelFiles.class);
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            ClasspathBootstrap.addToClassPath(cp, cmdLineWrapper);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        LinkedHashSet<String> linkedHashSet = cp;
        if (linkedHashSet == null) {
            ClasspathBootstrap.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    public static void appendJavaCompilerClasspath(Collection<? super String> cp, boolean includeEcj) {
        File file;
        if (includeEcj && (file = EclipseCompilerTool.findEcjJarFile()) != null) {
            cp.add(file.getAbsolutePath());
        }
    }

    public static List<File> getExternalJavacProcessClasspath(String sdkHome, JavaCompilingTool compilingTool) {
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        cp.add(ClasspathBootstrap.getResourceFile(ExternalJavacProcess.class));
        cp.add(ClasspathBootstrap.getResourceFile(JavacReferenceCollector.class));
        cp.add(ClasspathBootstrap.getResourceFile(SystemInfoRt.class));
        for (Class<?> aClass : COMMON_REQUIRED_CLASSES) {
            cp.add(ClasspathBootstrap.getResourceFile(aClass));
        }
        ClasspathBootstrap.getNettyForJpsClasspath(path -> cp.add(path.toFile()));
        try {
            Class<?> cmdLineWrapper = Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            cp.add(ClasspathBootstrap.getResourceFile(cmdLineWrapper));
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        try {
            String localJavaHome = FileUtilRt.toSystemIndependentName((String)SystemProperties.getJavaHome());
            File candidate = new File(sdkHome, "lib/tools.jar");
            if (candidate.exists()) {
                cp.add(candidate);
            } else {
                String localJarPath;
                String relPath;
                JavaCompiler systemCompiler = ToolProvider.getSystemJavaCompiler();
                Class<?> compilerClass = systemCompiler != null ? systemCompiler.getClass() : Class.forName("com.sun.tools.javac.api.JavacTool", false, ClasspathBootstrap.class.getClassLoader());
                File resourceFile = ClasspathBootstrap.getResourceFile(compilerClass);
                if (resourceFile != null && (relPath = FileUtilRt.getRelativePath((String)localJavaHome, (String)(localJarPath = FileUtilRt.toSystemIndependentName((String)resourceFile.getPath())), (char)'/')) != null) {
                    if (relPath.contains("..")) {
                        relPath = FileUtilRt.getRelativePath((String)FileUtilRt.toSystemIndependentName((String)new File(localJavaHome).getParent()), (String)localJarPath, (char)'/');
                    }
                    if (relPath != null) {
                        File targetFile = new File(sdkHome, relPath);
                        cp.add(targetFile);
                    }
                }
            }
        }
        catch (Throwable th) {
            LOG.info(th);
        }
        cp.addAll(compilingTool.getAdditionalClasspath());
        for (JavaSourceTransformer t : JavaSourceTransformer.getTransformers()) {
            cp.add(ClasspathBootstrap.getResourceFile(t.getClass()));
        }
        return new ArrayList<File>(cp);
    }

    @Nullable
    public static String getResourcePath(@NotNull Class<?> aClass) {
        if (aClass == null) {
            ClasspathBootstrap.$$$reportNull$$$0(5);
        }
        return PathManager.getJarPathForClass(aClass);
    }

    @Nullable
    public static File getResourceFile(@NotNull Class<?> aClass) {
        Path resourcePath;
        if (aClass == null) {
            ClasspathBootstrap.$$$reportNull$$$0(6);
        }
        return (resourcePath = PathManager.getJarForClass(aClass)) != null ? resourcePath.toFile() : null;
    }

    public static void configureReflectionOpenPackages(Consumer<? super String> paramConsumer) {
        for (String aPackage : REFLECTION_OPEN_PACKAGES) {
            paramConsumer.accept("--add-opens");
            paramConsumer.accept(aPackage);
        }
    }

    private static List<String> getInstrumentationUtilRoots() {
        String instrumentationUtilPath = ClasspathBootstrap.getResourcePath(NotNullVerifyingInstrumenter.class);
        assert (instrumentationUtilPath != null);
        File instrumentationUtil = new File(instrumentationUtilPath);
        if (instrumentationUtil.isDirectory()) {
            return Arrays.asList(instrumentationUtilPath, new File(instrumentationUtil.getParentFile(), "intellij.java.compiler.instrumentationUtil.java8").getAbsolutePath());
        }
        String relevantJarsRoot = ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation();
        Map mapping = ArchivedCompilationContextUtil.getArchivedCompiledClassesMapping();
        if (relevantJarsRoot != null && mapping != null && instrumentationUtilPath.startsWith(relevantJarsRoot)) {
            return Arrays.asList(instrumentationUtilPath, (String)mapping.get("production/intellij.java.compiler.instrumentationUtil.java8"));
        }
        return Collections.singletonList(instrumentationUtilPath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/cmdline/ClasspathBootstrap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/cmdline/ClasspathBootstrap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProcessApplicationClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "assertPathDoesNotContainTheWholeWorld";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addToClassPath";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResourcePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResourceFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

