/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.platform.workspace.jps.entities.LibraryId;
import com.intellij.workspaceModel.ide.legacyBridge.LibraryBridgesKt;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@TestOnly
public final class LibraryTableTracker {
    private Map<LibraryId, Library> stored;
    private Throwable trace;
    private boolean isTracking;
    private LibraryTable myLibraryTable;

    public LibraryTableTracker() {
        this.store();
    }

    private synchronized void store() {
        if (this.isTracking) {
            this.isTracking = false;
            if (this.trace != null) {
                this.trace.printStackTrace(System.err);
            }
            throw new IllegalStateException("Previous test did not call assertDisposed() - see 'Caused by:' for its stacktrace", this.trace);
        }
        this.trace = new Throwable();
        this.myLibraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable();
        this.stored = this.dumpAll();
        this.isTracking = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void assertDisposed() {
        if (!this.isTracking) {
            throw new IllegalStateException("Double call of assertDisposed() - see 'Caused by:' for the previous call", this.trace);
        }
        Map<LibraryId, Library> leaked = this.dumpAll();
        try {
            this.stored.keySet().forEach(leaked::remove);
            for (Library library : leaked.values()) {
                System.err.println("Leaked library: " + String.valueOf(library) + " creation trace:\n" + ((TraceableDisposable)library).getStackTrace());
                ((TraceableDisposable)library).throwDisposalError("Leaked library: " + String.valueOf(library));
            }
        }
        finally {
            this.stored = null;
            this.trace = new Throwable();
            this.isTracking = false;
            this.myLibraryTable = null;
        }
    }

    @NotNull
    private Map<LibraryId, Library> dumpAll() {
        HashMap<LibraryId, Library> libraries = new HashMap<LibraryId, Library>();
        for (Library library : this.myLibraryTable.getLibraries()) {
            libraries.put(LibraryBridgesKt.findLibraryId(library), library);
        }
        HashMap<LibraryId, Library> hashMap = libraries;
        if (hashMap == null) {
            LibraryTableTracker.$$$reportNull$$$0(0);
        }
        return hashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/libraries/LibraryTableTracker", "dumpAll"));
    }
}

