/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayFactory;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CommonProblemDescriptor {
    public static final Comparator<CommonProblemDescriptor> DESCRIPTOR_COMPARATOR = (c1, c2) -> {
        if (c1 instanceof ProblemDescriptor) {
            ProblemDescriptor pd1 = (ProblemDescriptor)c1;
            if (c2 instanceof ProblemDescriptor) {
                ProblemDescriptor pd2 = (ProblemDescriptor)c2;
                int diff = Integer.compare(pd2.getLineNumber(), pd1.getLineNumber());
                if (diff != 0) {
                    return diff;
                }
                diff = PsiUtilCore.compareElementsByPosition((PsiElement)pd2.getPsiElement(), (PsiElement)pd1.getPsiElement());
                if (diff != 0) {
                    return diff;
                }
                TextRange range1 = pd1.getTextRangeInElement();
                TextRange range2 = pd2.getTextRangeInElement();
                diff = Segment.BY_START_OFFSET_THEN_END_OFFSET.compare(range2 == null ? TextRange.EMPTY_RANGE : range2, range1 == null ? TextRange.EMPTY_RANGE : range1);
                if (diff != 0) {
                    return diff;
                }
            }
        }
        return c2.getDescriptionTemplate().compareTo(c1.getDescriptionTemplate());
    };
    public static final CommonProblemDescriptor[] EMPTY_ARRAY = new CommonProblemDescriptor[0];
    public static final ArrayFactory<CommonProblemDescriptor> ARRAY_FACTORY = count -> count == 0 ? EMPTY_ARRAY : new CommonProblemDescriptor[count];

    @InspectionMessage
    @NotNull
    public String getDescriptionTemplate();

    public @NotNull QuickFix @Nullable [] getFixes();
}

