/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nJ*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH&J9\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0013JA\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J8\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0013J$\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015H\u00a7@\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0017\u001a\u00020\u000e2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015H\u00a7@\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015H'\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/vfs/newvfs/RefreshQueue;", "", "<init>", "()V", "createSession", "Lcom/intellij/openapi/vfs/newvfs/RefreshSession;", "async", "", "recursive", "finishRunnable", "Ljava/lang/Runnable;", "state", "Lcom/intellij/openapi/application/ModalityState;", "refresh", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(ZZLjava/lang/Runnable;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "", "(ZZLjava/lang/Runnable;Lcom/intellij/openapi/application/ModalityState;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "", "(ZLjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processEvents", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "intellij.platform.analysis"})
public abstract class RefreshQueue {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RefreshSession createSession(boolean async, boolean recursive, @Nullable Runnable finishRunnable) {
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        return this.createSession(async, recursive, finishRunnable, modalityState);
    }

    @NotNull
    public abstract RefreshSession createSession(boolean var1, boolean var2, @Nullable Runnable var3, @NotNull ModalityState var4);

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, VirtualFile ... files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        this.refresh(async, recursive, finishRunnable, modalityState, Arrays.copyOf(files, files.length));
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        this.refresh(async, recursive, finishRunnable, modalityState, files);
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState state, VirtualFile ... files) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        RefreshSession session = this.createSession(async, recursive, finishRunnable, state);
        session.addAllFiles(Arrays.copyOf(files, files.length));
        session.launch();
    }

    public final void refresh(boolean async, boolean recursive, @Nullable Runnable finishRunnable, @NotNull ModalityState state, @NotNull Collection<? extends VirtualFile> files) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        RefreshSession session = this.createSession(async, recursive, finishRunnable, state);
        session.addAllFiles(files);
        session.launch();
    }

    @ApiStatus.Experimental
    @Nullable
    public abstract Object refresh(boolean var1, @NotNull List<? extends VirtualFile> var2, @NotNull Continuation<? super Unit> var3);

    @ApiStatus.Internal
    @Nullable
    public abstract Object processEvents(@NotNull List<? extends VFileEvent> var1, @NotNull Continuation<? super Unit> var2);

    @ApiStatus.Internal
    public abstract void processEvents(boolean var1, @NotNull List<? extends VFileEvent> var2);

    @JvmStatic
    @NotNull
    public static final RefreshQueue getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vfs/newvfs/RefreshQueue$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/vfs/newvfs/RefreshQueue;", "intellij.platform.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RefreshQueue getInstance() {
            Object object = ApplicationManager.getApplication().getService(RefreshQueue.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (RefreshQueue)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

