/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.NettyKt;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerAuth;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000A\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002*\u0001\u000b\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0010J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0015\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0019R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR$\u0010\r\u001a\u0018\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u000f\u0012\t\u0012\u00070\u0010\u00a2\u0006\u0002\b\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/builtInWebServer/BuiltInWebServerAuth;", "", "<init>", "()V", "STANDARD_COOKIE", "Lio/netty/handler/codec/http/cookie/DefaultCookie;", "getSTANDARD_COOKIE", "()Lio/netty/handler/codec/http/cookie/DefaultCookie;", "STANDARD_COOKIE$delegate", "Lkotlin/Lazy;", "TOKEN_KEY", "org/jetbrains/builtInWebServer/BuiltInWebServerAuth$TOKEN_KEY$1", "Lorg/jetbrains/builtInWebServer/BuiltInWebServerAuth$TOKEN_KEY$1;", "tokens", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "acquireToken", "validateToken", "Lio/netty/handler/codec/http/HttpHeaders;", "request", "Lio/netty/handler/codec/http/HttpRequest;", "validateToken$intellij_platform_builtInServer_impl", "isRequestSigned", "", "isRequestSigned$intellij_platform_builtInServer_impl", "intellij.platform.builtInServer.impl"})
@SourceDebugExtension(value={"SMAP\nBuiltInWebServerAuth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuiltInWebServerAuth.kt\norg/jetbrains/builtInWebServer/BuiltInWebServerAuth\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,101:1\n1#2:102\n13#3:103\n*S KotlinDebug\n*F\n+ 1 BuiltInWebServerAuth.kt\norg/jetbrains/builtInWebServer/BuiltInWebServerAuth\n*L\n37#1:103\n*E\n"})
public final class BuiltInWebServerAuth {
    @NotNull
    private final Lazy STANDARD_COOKIE$delegate = LazyKt.lazy(BuiltInWebServerAuth::STANDARD_COOKIE_delegate$lambda$0);
    @NotNull
    private final TOKEN_KEY.1 TOKEN_KEY = new Object(){};
    @NotNull
    private final Cache<Object, String> tokens;

    public BuiltInWebServerAuth() {
        Cache cache = Caffeine.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.tokens = cache;
    }

    private final DefaultCookie getSTANDARD_COOKIE() {
        Lazy lazy = this.STANDARD_COOKIE$delegate;
        return (DefaultCookie)lazy.getValue();
    }

    @NotNull
    public final String acquireToken() {
        Object object = this.tokens.get((Object)this.TOKEN_KEY, arg_0 -> BuiltInWebServerAuth.acquireToken$lambda$1(BuiltInWebServerAuth::acquireToken$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (String)object;
    }

    @Nullable
    public final HttpHeaders validateToken$intellij_platform_builtInServer_impl(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
        }
        String string = request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (string != null) {
            String it = string;
            boolean bl = false;
            for (Cookie cookie : ServerCookieDecoder.STRICT.decode(it)) {
                if (!Intrinsics.areEqual((Object)cookie.name(), (Object)this.getSTANDARD_COOKIE().name())) continue;
                if (Intrinsics.areEqual((Object)cookie.value(), (Object)this.getSTANDARD_COOKIE().value())) {
                    return (HttpHeaders)EmptyHttpHeaders.INSTANCE;
                }
                break;
            }
        }
        if (this.isRequestSigned$intellij_platform_builtInServer_impl(request)) {
            return new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)(ServerCookieEncoder.STRICT.encode((Cookie)this.getSTANDARD_COOKIE()) + "; SameSite=strict"));
        }
        return null;
    }

    public final boolean isRequestSigned$intellij_platform_builtInServer_impl(@NotNull HttpRequest request) {
        String token;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (BuiltInServerOptions.getInstance().allowUnsignedRequests) {
            return true;
        }
        String string = request.headers().get("x-ijt");
        if (string == null) {
            List list = (List)new QueryStringDecoder(request.uri()).parameters().get("_ijt");
            string = list != null ? (String)CollectionsKt.firstOrNull((List)list) : null;
            if (string == null) {
                String string2 = NettyKt.getReferrer((HttpRequest)request);
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    List list2 = (List)new QueryStringDecoder(it).parameters().get("_ijt");
                    string = list2 != null ? (String)CollectionsKt.firstOrNull((List)list2) : null;
                } else {
                    string = null;
                }
            }
        }
        return (token = string) != null && Intrinsics.areEqual((Object)this.tokens.getIfPresent((Object)this.TOKEN_KEY), (Object)token);
    }

    private static final DefaultCookie STANDARD_COOKIE_delegate$lambda$0() {
        String string = PathManager.getConfigPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getConfigPath(...)");
        String configPath = string;
        String[] stringArray = new String[]{"user.web.token"};
        Path file = Path.of(configPath, stringArray);
        String token = null;
        Intrinsics.checkNotNull((Object)file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(file, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            try {
                token = UUID.fromString(PathsKt.readText$default((Path)file, null, (int)1, null)).toString();
            }
            catch (Exception e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(BuiltInWebServerAuth.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
            }
        }
        if (token == null) {
            token = UUID.randomUUID().toString();
            PathsKt.writeText$default((Path)file, (CharSequence)token, null, (OpenOption[])new OpenOption[0], (int)2, null);
            Path $i$f$logger = file;
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            PosixFileAttributeView e = Files.getFileAttributeView($i$f$logger, PosixFileAttributeView.class, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
            if (e != null) {
                e.setPermissions((Set<PosixFilePermission>)EnumSet.of((Enum)PosixFilePermission.OWNER_READ, (Enum)PosixFilePermission.OWNER_WRITE));
            }
        }
        String productName = ApplicationNamesInfo.getInstance().getLowercaseProductName();
        DefaultCookie cookie = new DefaultCookie(productName + "-" + Integer.toHexString(configPath.hashCode()), token);
        cookie.setHttpOnly(true);
        cookie.setMaxAge(TimeUnit.DAYS.toSeconds(3650L));
        cookie.setPath("/");
        return cookie;
    }

    private static final String acquireToken$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return DigestUtil.randomToken();
    }

    private static final String acquireToken$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

