/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.findUsages;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.resolve.ElementResolveResult;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineASTTransformationPerformer;
import org.jetbrains.plugins.groovy.transformations.inline.GroovyInlineTransformationUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/groovy/findUsages/GrInlineTransformationReferencesSearcher;", "Lcom/intellij/openapi/application/QueryExecutorBase;", "Lcom/intellij/psi/PsiReference;", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "()V", "processQuery", "", "queryParameters", "consumer", "Lcom/intellij/util/Processor;", "intellij.groovy.psi"})
public final class GrInlineTransformationReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)queryParameters, (String)"queryParameters");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        PsiElement psiElement = queryParameters.getElementToSearch();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementToSearch(...)");
        PsiElement target = psiElement;
        ActionsKt.runReadAction(() -> GrInlineTransformationReferencesSearcher.processQuery$lambda$0(target, consumer));
    }

    private static final Unit processQuery$lambda$0(PsiElement $target, Processor $consumer) {
        if (!($target.getContainingFile() instanceof GroovyFileBase)) {
            return Unit.INSTANCE;
        }
        Pair<GroovyPsiElement, GroovyInlineASTTransformationPerformer> pair = GroovyInlineTransformationUtilKt.getHierarchicalInlineTransformationData($target);
        if (pair == null) {
            return Unit.INSTANCE;
        }
        Pair<GroovyPsiElement, GroovyInlineASTTransformationPerformer> pair2 = pair;
        GroovyPsiElement call = (GroovyPsiElement)pair2.component1();
        GroovyInlineASTTransformationPerformer performer = (GroovyInlineASTTransformationPerformer)pair2.component2();
        call.accept(new GroovyRecursiveElementVisitor(performer, $target, (Processor<? super PsiReference>)$consumer){
            final /* synthetic */ GroovyInlineASTTransformationPerformer $performer;
            final /* synthetic */ PsiElement $target;
            final /* synthetic */ Processor<? super PsiReference> $consumer;
            {
                this.$performer = $performer;
                this.$target = $target;
                this.$consumer = $consumer;
            }

            public void visitElement(GroovyPsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                ElementResolveResult<PsiElement> elementResolveResult = this.$performer.computeStaticReference(element);
                if (elementResolveResult == null) {
                    super.visitElement(element);
                    return;
                }
                ElementResolveResult<PsiElement> reference = elementResolveResult;
                if (!Intrinsics.areEqual((Object)reference.getElement(), (Object)this.$target)) {
                    super.visitElement(element);
                    return;
                }
                TextRange textRange = new TextRange(0, PsiTreeUtilKt.getEndOffset((PsiElement)element) - PsiTreeUtilKt.getStartOffset((PsiElement)element));
                PsiReferenceBase<PsiElement> ref2 = new PsiReferenceBase<PsiElement>(element, this.$target, textRange){
                    final /* synthetic */ PsiElement $target;
                    {
                        this.$target = $target;
                        super((PsiElement)$element, $super_call_param$1, true);
                    }

                    public PsiElement resolve() {
                        return this.$target;
                    }
                };
                this.$consumer.process((Object)ref2);
            }
        });
        return Unit.INSTANCE;
    }
}

