/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.impl;

import com.intellij.diff.actions.impl.GoToChangePopupBuilder;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.impl.CacheDiffRequestProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheDiffRequestChainProcessor
extends CacheDiffRequestProcessor.Simple {
    @NotNull
    private final DiffRequestChain myRequestChain;
    private int myIndex;

    public CacheDiffRequestChainProcessor(@Nullable Project project, @NotNull DiffRequestChain requestChain) {
        if (requestChain == null) {
            CacheDiffRequestChainProcessor.$$$reportNull$$$0(0);
        }
        super(project, (UserDataHolder)requestChain);
        this.myRequestChain = requestChain;
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(true);
            ((AsyncDiffRequestChain)this.myRequestChain).addListener(new MyChangeListener(), (Disposable)this);
        }
        this.myIndex = this.myRequestChain.getIndex();
    }

    @Override
    protected void onDispose() {
        if (this.myRequestChain instanceof AsyncDiffRequestChain) {
            ((AsyncDiffRequestChain)this.myRequestChain).onAssigned(false);
        }
        super.onDispose();
    }

    @Override
    protected DiffRequestProducer getCurrentRequestProvider() {
        List requests = this.myRequestChain.getRequests();
        if (this.myIndex < 0 || this.myIndex >= requests.size()) {
            return null;
        }
        return (DiffRequestProducer)requests.get(this.myIndex);
    }

    @NotNull
    public DiffRequestChain getRequestChain() {
        DiffRequestChain diffRequestChain = this.myRequestChain;
        if (diffRequestChain == null) {
            CacheDiffRequestChainProcessor.$$$reportNull$$$0(1);
        }
        return diffRequestChain;
    }

    public void setCurrentRequest(int index) {
        this.myIndex = index;
        this.updateRequest();
    }

    @Override
    protected boolean hasNextChange(boolean fromUpdate) {
        return this.myIndex < this.myRequestChain.getRequests().size() - 1;
    }

    @Override
    protected boolean hasPrevChange(boolean fromUpdate) {
        return this.myIndex > 0;
    }

    @Override
    protected void goToNextChange(boolean fromDifferences) {
        this.goToNextChangeImpl(fromDifferences, () -> ++this.myIndex);
    }

    @Override
    protected void goToPrevChange(boolean fromDifferences) {
        this.goToPrevChangeImpl(fromDifferences, () -> --this.myIndex);
    }

    @Override
    protected boolean isNavigationEnabled() {
        return this.myRequestChain.getRequests().size() > 1;
    }

    @Override
    @NotNull
    public AnAction createGoToChangeAction() {
        AnAction anAction = GoToChangePopupBuilder.create(this.myRequestChain, (Consumer<? super Integer>)((Consumer)index -> {
            if (index >= 0 && index < this.myRequestChain.getRequests().size() && index != this.myIndex) {
                this.setCurrentRequest((int)index);
            }
        }), this.myIndex);
        if (anAction == null) {
            CacheDiffRequestChainProcessor.$$$reportNull$$$0(2);
        }
        return anAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestChain";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/impl/CacheDiffRequestChainProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/impl/CacheDiffRequestChainProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequestChain";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoToChangeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private class MyChangeListener
    implements AsyncDiffRequestChain.Listener {
        private MyChangeListener() {
        }

        @Override
        public void onRequestsLoaded() {
            CacheDiffRequestChainProcessor.this.dropCaches();
            CacheDiffRequestChainProcessor.this.myIndex = CacheDiffRequestChainProcessor.this.myRequestChain.getIndex();
            CacheDiffRequestChainProcessor.this.updateRequest(true);
        }
    }
}

