/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.merge.MergeThreesideViewer;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Pair;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/diff/merge/ShowDiffWithBaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "viewer", "Lcom/intellij/diff/merge/MergeThreesideViewer;", "side", "Lcom/intellij/diff/util/ThreeSide;", "<init>", "(Lcom/intellij/diff/merge/MergeThreesideViewer;Lcom/intellij/diff/util/ThreeSide;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.platform.diff.impl"})
public final class ShowDiffWithBaseAction
extends DumbAwareAction {
    @NotNull
    private final MergeThreesideViewer viewer;
    @NotNull
    private final ThreeSide side;

    public ShowDiffWithBaseAction(@NotNull MergeThreesideViewer viewer, @NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.viewer = viewer;
        this.side = side;
        String actionId = (String)this.side.select((Object)"Diff.CompareWithBase.Left", (Object)"Diff.CompareWithBase.Result", (Object)"Diff.CompareWithBase.Right");
        ActionUtil.copyFrom((AnAction)((AnAction)this), (String)actionId);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(!this.viewer.isExternalOperationInProgress());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        List list = this.viewer.getMergeRequest().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        DocumentContent baseContent = (DocumentContent)ThreeSide.BASE.select(list);
        List list2 = this.viewer.getMergeRequest().getContentTitles();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContentTitles(...)");
        String baseTitle = (String)ThreeSide.BASE.select(list2);
        List list3 = this.viewer.getRequest().getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getContents(...)");
        DiffContent otherContent = (DiffContent)this.side.select(list3);
        List list4 = this.viewer.getRequest().getContentTitles();
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"getContentTitles(...)");
        String otherTitle = (String)this.side.select(list4);
        SimpleDiffRequest request = new SimpleDiffRequest(this.viewer.getRequest().getTitle(), (DiffContent)baseContent, otherContent, baseTitle, otherTitle);
        LogicalPosition logicalPosition = DiffUtil.getCaretPosition((Editor)this.viewer.getCurrentEditor());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getCaretPosition(...)");
        LogicalPosition currentPosition = logicalPosition;
        LogicalPosition logicalPosition2 = this.viewer.transferPosition(this.viewer.getCurrentSide(), this.side, currentPosition);
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"transferPosition(...)");
        LogicalPosition resultPosition = logicalPosition2;
        request.putUserData(DiffUserDataKeys.SCROLL_TO_LINE, (Object)Pair.create((Object)Side.RIGHT, (Object)resultPosition.line));
        DiffManager.getInstance().showDiff(this.viewer.getProject(), (DiffRequest)request, new DiffDialogHints(null, (Component)this.viewer.getComponent()));
    }
}

