/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.requests;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.BinaryMergeRequest;
import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.MergeResult;
import com.intellij.diff.merge.MergeUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.ThreeSide;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.UIBundle;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BinaryMergeRequestImpl
extends BinaryMergeRequest {
    private static final Logger LOG = Logger.getInstance(BinaryMergeRequestImpl.class);
    @Nullable
    private final Project myProject;
    @NotNull
    private final FileContent myFile;
    @NotNull
    private final List<DiffContent> myContents;
    @NotNull
    private final List<byte[]> myByteContents;
    private final byte @NotNull [] myOriginalContent;
    @NlsContexts.DialogTitle
    @Nullable
    private final String myTitle;
    @NotNull
    private final List<String> myTitles;

    public BinaryMergeRequestImpl(@Nullable Project project, @NotNull FileContent file, byte @NotNull [] originalContent, @NotNull List<DiffContent> contents, @NotNull List<byte[]> byteContents, @NlsContexts.DialogTitle @Nullable String title, @NotNull List<@Nls String> contentTitles) {
        if (file == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(0);
        }
        if (contents == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(1);
        }
        if (byteContents == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(2);
        }
        if (contentTitles == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(3);
        }
        if (originalContent == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(4);
        }
        assert (byteContents.size() == 3);
        assert (contents.size() == 3);
        assert (contentTitles.size() == 3);
        this.myProject = project;
        this.myFile = file;
        this.myOriginalContent = originalContent;
        this.myByteContents = byteContents;
        this.myContents = contents;
        this.myTitle = title;
        this.myTitles = contentTitles;
    }

    @NotNull
    public FileContent getOutputContent() {
        FileContent fileContent = this.myFile;
        if (fileContent == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(5);
        }
        return fileContent;
    }

    @NotNull
    public List<DiffContent> getContents() {
        List<DiffContent> list = this.myContents;
        if (list == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public List<byte[]> getByteContents() {
        List<byte[]> list = this.myByteContents;
        if (list == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @NotNull
    public List<String> getContentTitles() {
        List<String> list = this.myTitles;
        if (list == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void applyResult(@NotNull MergeResult result) {
        byte[] applyContent;
        if (result == null) {
            BinaryMergeRequestImpl.$$$reportNull$$$0(9);
        }
        switch (result) {
            default: {
                throw new MatchException(null, null);
            }
            case CANCEL: {
                byte[] byArray;
                if (MergeUtil.shouldRestoreOriginalContentOnCancel((MergeRequest)this)) {
                    byArray = this.myOriginalContent;
                    break;
                }
                byArray = null;
                break;
            }
            case LEFT: {
                byte[] byArray = (byte[])ThreeSide.LEFT.select(this.myByteContents);
                break;
            }
            case RIGHT: {
                byte[] byArray = (byte[])ThreeSide.RIGHT.select(this.myByteContents);
                break;
            }
            case RESOLVED: {
                byte[] byArray = applyContent = null;
            }
        }
        if (applyContent != null) {
            try {
                VirtualFile file = this.myFile.getFile();
                if (!file.isValid()) {
                    throw new IOException(IdeBundle.message((String)"error.file.not.found.message", (Object[])new Object[]{file.getPresentableUrl()}));
                }
                if (!DiffUtil.makeWritable(this.myProject, file)) {
                    throw new IOException(UIBundle.message((String)"file.is.read.only.message.text", (Object[])new Object[]{file.getPresentableUrl()}));
                }
                WriteCommandAction.writeCommandAction(null).run(() -> file.setBinaryContent(applyContent));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)DiffBundle.message((String)"can.t.finish.merge.resolve", (Object[])new Object[0]));
            }
        }
        MergeCallback.getCallback((MergeRequest)this).applyResult(result);
    }

    public void onAssigned(boolean assigned) {
        this.myFile.onAssigned(assigned);
        for (DiffContent content : this.myContents) {
            content.onAssigned(assigned);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteContents";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTitles";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalContent";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/requests/BinaryMergeRequestImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/requests/BinaryMergeRequestImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputContent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteContents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentTitles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 8 -> new IllegalStateException(string);
        };
    }
}

