/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.DiffManagerEx;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.merge.MergeRequest;
import com.intellij.diff.merge.ThreesideMergeRequest;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.diff.tools.external.ExternalDiffToolUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\bH\u0007J\"\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/diff/tools/external/ExternalMergeTool;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "isEnabled", "", "isDefault", "show", "", "project", "Lcom/intellij/openapi/project/Project;", "externalTool", "Lcom/intellij/diff/tools/external/ExternalDiffSettings$ExternalTool;", "request", "Lcom/intellij/diff/merge/MergeRequest;", "canShow", "canProcessOutputContent", "content", "Lcom/intellij/diff/contents/DiffContent;", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class ExternalMergeTool {
    @NotNull
    public static final ExternalMergeTool INSTANCE = new ExternalMergeTool();
    @NotNull
    private static final Logger LOG;

    private ExternalMergeTool() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isEnabled() {
        if (!ExternalDiffSettings.Companion.getInstance().isExternalToolsEnabled()) return false;
        List list = ExternalDiffSettings.Companion.getInstance().getExternalTools().get((Object)ExternalDiffSettings.ExternalToolGroup.MERGE_TOOL);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if (((Collection)list).isEmpty()) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isDefault() {
        return ExternalMergeTool.isEnabled() && ExternalDiffSettings.Companion.isNotBuiltinMergeTool();
    }

    @JvmStatic
    public static final void show(@Nullable Project project, @NotNull ExternalDiffSettings.ExternalTool externalTool, @NotNull MergeRequest request) {
        Intrinsics.checkNotNullParameter((Object)externalTool, (String)"externalTool");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        try {
            if (ExternalMergeTool.canShow(request)) {
                ExternalDiffToolUtil.executeMerge(project, externalTool, (ThreesideMergeRequest)request, null);
            } else {
                DiffManagerEx.getInstance().showMergeBuiltin(project, request);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        catch (Throwable e) {
            LOG.warn(e);
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)DiffBundle.message((String)"can.t.show.merge.in.external.tool", (Object[])new Object[0]));
        }
    }

    @JvmStatic
    public static final boolean canShow(@NotNull MergeRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (request instanceof ThreesideMergeRequest) {
            DiffContent diffContent = ((ThreesideMergeRequest)request).getOutputContent();
            Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"getOutputContent(...)");
            DiffContent outputContent = diffContent;
            if (!INSTANCE.canProcessOutputContent(outputContent)) {
                return false;
            }
            List list = ((ThreesideMergeRequest)request).getContents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
            List contents = list;
            if (contents.size() != 3) {
                return false;
            }
            for (DiffContent content : contents) {
                if (ExternalDiffToolUtil.canCreateFile(content)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private final boolean canProcessOutputContent(DiffContent content) {
        if (content instanceof DocumentContent) {
            return true;
        }
        return content instanceof FileContent && ((FileContent)content).getFile().isInLocalFileSystem();
    }

    static {
        Logger logger = Logger.getInstance(ExternalMergeTool.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

