/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class UnifiedEditorHighlighter
implements EditorHighlighter {
    private static final Logger LOG = Logger.getInstance(UnifiedEditorHighlighter.class);
    @NotNull
    private final Document myDocument;
    @NotNull
    private final List<Element> myPieces;

    UnifiedEditorHighlighter(@NotNull Document document, @NotNull EditorHighlighter highlighter1, @NotNull EditorHighlighter highlighter2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (document == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(0);
        }
        if (highlighter1 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(1);
        }
        if (highlighter2 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(2);
        }
        if (ranges == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(3);
        }
        this.myDocument = document;
        this.myPieces = new ArrayList<Element>();
        this.init(highlighter1.createIterator(0), highlighter2.createIterator(0), ranges, textLength);
    }

    private void init(@NotNull HighlighterIterator it1, @NotNull HighlighterIterator it2, @NotNull List<? extends HighlightRange> ranges, int textLength) {
        if (it1 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(4);
        }
        if (it2 == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(5);
        }
        if (ranges == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        int i = 0;
        int offset = 0;
        block0: for (HighlightRange highlightRange : ranges) {
            TextRange base = highlightRange.getBase();
            TextRange changed = highlightRange.getChanged();
            if (base.isEmpty()) continue;
            if (base.getStartOffset() > offset) {
                this.addElement(UnifiedEditorHighlighter.createEmptyElement(offset, base.getStartOffset()));
                offset = base.getStartOffset();
            }
            HighlighterIterator it = (HighlighterIterator)highlightRange.getSide().select((Object)it1, (Object)it2);
            while (!it.atEnd() && changed.getStartOffset() >= it.getEnd()) {
                if (i++ % 1024 == 0) {
                    ProgressManager.checkCanceled();
                }
                it.advance();
            }
            if (it.atEnd()) {
                LOG.error("Unexpected end of highlighter");
                break;
            }
            if (changed.getEndOffset() <= it.getStart()) continue;
            do {
                int relativeStart = Math.max(it.getStart() - changed.getStartOffset(), 0);
                int relativeEnd = Math.min(it.getEnd() - changed.getStartOffset(), changed.getLength() + 1);
                this.addElement(new Element(offset + relativeStart, offset + relativeEnd, it.getTokenType(), it.getTextAttributes(), it.getTextAttributesKeys()));
                if (changed.getEndOffset() <= it.getEnd()) {
                    offset += changed.getLength();
                    continue block0;
                }
                if (i++ % 1024 == 0) {
                    ProgressManager.checkCanceled();
                }
                it.advance();
            } while (!it.atEnd());
            LOG.error("Unexpected end of highlighter");
        }
        if (offset < textLength) {
            this.addElement(UnifiedEditorHighlighter.createEmptyElement(offset, textLength));
        }
    }

    private void addElement(@NotNull Element element) {
        Element oldElement;
        if (element == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(7);
        }
        boolean merged = false;
        if (!this.myPieces.isEmpty() && (oldElement = this.myPieces.get(this.myPieces.size() - 1)).getEnd() >= element.getStart() && Comparing.equal((Object)oldElement.getAttributes(), (Object)element.getAttributes()) && Arrays.equals(oldElement.getAttributesKeys(), element.getAttributesKeys()) && Comparing.equal((Object)oldElement.getElementType(), (Object)element.getElementType())) {
            merged = true;
            this.myPieces.remove(this.myPieces.size() - 1);
            this.myPieces.add(new Element(oldElement.getStart(), element.getEnd(), element.getElementType(), element.getAttributes(), element.getAttributesKeys()));
        }
        if (!merged) {
            this.myPieces.add(element);
        }
    }

    @NotNull
    public HighlighterIterator createIterator(int startOffset) {
        int index = Collections.binarySearch(this.myPieces, UnifiedEditorHighlighter.createEmptyElement(startOffset, 0), Comparator.comparingInt(Element::getStart));
        if (index < 0) {
            index = Math.max(-index - 2, 0);
        }
        return new ProxyIterator(this.myDocument, index, this.myPieces);
    }

    public void setEditor(@NotNull HighlighterClient editor) {
        if (editor == null) {
            UnifiedEditorHighlighter.$$$reportNull$$$0(8);
        }
    }

    @NotNull
    private static Element createEmptyElement(int startOffset, int endOffset) {
        return new Element(startOffset, endOffset, null, TextAttributes.ERASE_MARKER, TextAttributesKey.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter2";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it1";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "init";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addElement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "setEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class Element {
        private final int myStart;
        private final int myEnd;
        private final IElementType myElementType;
        private final TextAttributes myAttributes;
        private final TextAttributesKey @NotNull [] myAttributesKeys;

        private Element(int start, int end, @Nullable IElementType elementType, @NotNull TextAttributes attributes, TextAttributesKey @NotNull [] keys) {
            if (attributes == null) {
                Element.$$$reportNull$$$0(0);
            }
            if (keys == null) {
                Element.$$$reportNull$$$0(1);
            }
            this.myStart = start;
            this.myEnd = end;
            this.myElementType = elementType;
            this.myAttributes = attributes;
            this.myAttributesKeys = keys;
        }

        int getStart() {
            return this.myStart;
        }

        int getEnd() {
            return this.myEnd;
        }

        IElementType getElementType() {
            return this.myElementType;
        }

        @NotNull
        TextAttributes getAttributes() {
            TextAttributes textAttributes = this.myAttributes;
            if (textAttributes == null) {
                Element.$$$reportNull$$$0(2);
            }
            return textAttributes;
        }

        private TextAttributesKey @NotNull [] getAttributesKeys() {
            if (this.myAttributesKeys == null) {
                Element.$$$reportNull$$$0(3);
            }
            return this.myAttributesKeys;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keys";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$Element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$Element";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesKeys";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ProxyIterator
    implements HighlighterIterator {
        @NotNull
        private final Document myDocument;
        private int myIdx;
        private final List<Element> myPieces;

        private ProxyIterator(@NotNull Document document, int idx, @NotNull List<Element> pieces) {
            if (document == null) {
                ProxyIterator.$$$reportNull$$$0(0);
            }
            if (pieces == null) {
                ProxyIterator.$$$reportNull$$$0(1);
            }
            this.myDocument = document;
            this.myIdx = idx;
            this.myPieces = pieces;
        }

        public TextAttributes getTextAttributes() {
            return this.myPieces.get(this.myIdx).getAttributes();
        }

        public TextAttributesKey @NotNull [] getTextAttributesKeys() {
            TextAttributesKey[] textAttributesKeyArray = this.myPieces.get(this.myIdx).getAttributesKeys();
            if (textAttributesKeyArray == null) {
                ProxyIterator.$$$reportNull$$$0(2);
            }
            return textAttributesKeyArray;
        }

        public int getStart() {
            return this.myPieces.get(this.myIdx).getStart();
        }

        public int getEnd() {
            return this.myPieces.get(this.myIdx).getEnd();
        }

        public IElementType getTokenType() {
            return this.myPieces.get((int)this.myIdx).myElementType;
        }

        public void advance() {
            if (this.myIdx < this.myPieces.size()) {
                ++this.myIdx;
            }
        }

        public void retreat() {
            if (this.myIdx > -1) {
                --this.myIdx;
            }
        }

        public boolean atEnd() {
            return this.myIdx < 0 || this.myIdx >= this.myPieces.size();
        }

        @NotNull
        public Document getDocument() {
            Document document = this.myDocument;
            if (document == null) {
                ProxyIterator.$$$reportNull$$$0(3);
            }
            return document;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pieces";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$ProxyIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/tools/fragmented/UnifiedEditorHighlighter$ProxyIterator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextAttributesKeys";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

