/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gradle.toolingExtension.impl.modelAction;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.Serializable;
import java.util.Objects;
import org.gradle.tooling.model.BuildIdentifier;
import org.gradle.tooling.model.BuildModel;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.idea.IdeaModule;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class GradleModelId
implements Serializable {
    @NotNull
    private final String classId;
    @NotNull
    private final String buildId;
    @NotNull
    private final String projectId;

    public GradleModelId(@NotNull String classId, @NotNull String buildId, @NotNull String projectId) {
        if (classId == null) {
            GradleModelId.$$$reportNull$$$0(0);
        }
        if (buildId == null) {
            GradleModelId.$$$reportNull$$$0(1);
        }
        if (projectId == null) {
            GradleModelId.$$$reportNull$$$0(2);
        }
        this.classId = classId;
        this.buildId = buildId;
        this.projectId = projectId;
    }

    public boolean isForClass(@NotNull Class<?> modelClass) {
        if (modelClass == null) {
            GradleModelId.$$$reportNull$$$0(3);
        }
        return this.classId.equals(GradleModelId.createClassId(modelClass));
    }

    @NotNull
    public String getClassId() {
        String string = this.classId;
        if (string == null) {
            GradleModelId.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getBuildId() {
        String string = this.buildId;
        if (string == null) {
            GradleModelId.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getProjectId() {
        String string = this.projectId;
        if (string == null) {
            GradleModelId.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GradleModelId)) {
            return false;
        }
        GradleModelId id = (GradleModelId)o;
        return Objects.equals(this.classId, id.classId) && Objects.equals(this.buildId, id.buildId) && Objects.equals(this.projectId, id.projectId);
    }

    public int hashCode() {
        return Objects.hash(this.classId, this.buildId, this.projectId);
    }

    public String toString() {
        return this.classId + "/" + this.buildId + "/" + this.projectId;
    }

    @NotNull
    public static GradleModelId createBuildModelId(@NotNull BuildModel buildModel, @NotNull Class<?> modelClass) {
        if (buildModel == null) {
            GradleModelId.$$$reportNull$$$0(7);
        }
        if (modelClass == null) {
            GradleModelId.$$$reportNull$$$0(8);
        }
        BuildIdentifier buildIdentifier = buildModel.getBuildIdentifier();
        String classId = GradleModelId.createClassId(modelClass);
        String buildId = GradleModelId.createBuildId(buildIdentifier);
        String projectId = ":";
        return new GradleModelId(classId, buildId, projectId);
    }

    @NotNull
    public static GradleModelId createRootModelId(@NotNull Class<?> modelClass) {
        if (modelClass == null) {
            GradleModelId.$$$reportNull$$$0(9);
        }
        String classId = GradleModelId.createClassId(modelClass);
        String projectId = ":";
        return new GradleModelId(classId, "", projectId);
    }

    @NotNull
    public static GradleModelId createProjectModelId(@NotNull ProjectModel projectModel, @NotNull Class<?> modelClass) {
        if (projectModel == null) {
            GradleModelId.$$$reportNull$$$0(10);
        }
        if (modelClass == null) {
            GradleModelId.$$$reportNull$$$0(11);
        }
        ProjectIdentifier projectIdentifier = GradleModelId.getProjectIdentifier(projectModel);
        BuildIdentifier buildIdentifier = projectIdentifier.getBuildIdentifier();
        String classId = GradleModelId.createClassId(modelClass);
        String buildId = GradleModelId.createBuildId(buildIdentifier);
        String projectId = projectIdentifier.getProjectPath();
        return new GradleModelId(classId, buildId, projectId);
    }

    @NotNull
    private static String createClassId(@NotNull Class<?> modelClass) {
        if (modelClass == null) {
            GradleModelId.$$$reportNull$$$0(12);
        }
        String string = modelClass.getSimpleName() + modelClass.getName().hashCode();
        if (string == null) {
            GradleModelId.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static String createBuildId(@NotNull BuildIdentifier buildIdentifier) {
        if (buildIdentifier == null) {
            GradleModelId.$$$reportNull$$$0(14);
        }
        String path = buildIdentifier.getRootDir().getPath();
        String systemIndependentName = FileUtilRt.toSystemIndependentName((String)path);
        String string = String.valueOf(systemIndependentName.hashCode());
        if (string == null) {
            GradleModelId.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static ProjectIdentifier getProjectIdentifier(@NotNull ProjectModel project) {
        if (project == null) {
            GradleModelId.$$$reportNull$$$0(16);
        }
        ProjectIdentifier projectIdentifier = project instanceof IdeaModule ? ((IdeaModule)project).getGradleProject().getProjectIdentifier() : project.getProjectIdentifier();
        ProjectIdentifier projectIdentifier2 = projectIdentifier;
        if (projectIdentifier2 == null) {
            GradleModelId.$$$reportNull$$$0(17);
        }
        return projectIdentifier2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectId";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleModelId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectModel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildIdentifier";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gradle/toolingExtension/impl/modelAction/GradleModelId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildId";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassId";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuildId";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isForClass";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createBuildModelId";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createRootModelId";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProjectModelId";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createClassId";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createBuildId";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

