/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.storage.EntityChange;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/impl/ContentRootChangeListener;", "Lcom/intellij/platform/backend/workspace/WorkspaceModelChangeListener;", "skipFileChanges", "", "<init>", "(Z)V", "getSkipFileChanges", "()Z", "changed", "", "event", "Lcom/intellij/platform/workspace/storage/VersionedStorageChange;", "contentRootsChanged", "removed", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "added", "intellij.platform.vcs.impl"})
public abstract class ContentRootChangeListener
implements WorkspaceModelChangeListener {
    private final boolean skipFileChanges;

    public ContentRootChangeListener(boolean skipFileChanges) {
        this.skipFileChanges = skipFileChanges;
    }

    public final boolean getSkipFileChanges() {
        return this.skipFileChanges;
    }

    public void changed(@NotNull VersionedStorageChange event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Set removedUrls = new LinkedHashSet();
        Set addedUrls = new LinkedHashSet();
        List changes = event.getChanges(ContentRootEntity.class);
        for (EntityChange change : changes) {
            ContentRootEntity contentRootEntity = (ContentRootEntity)change.getOldEntity();
            VirtualFileUrl removedUrl = contentRootEntity != null ? contentRootEntity.getUrl() : null;
            ContentRootEntity contentRootEntity2 = (ContentRootEntity)change.getNewEntity();
            Object addedUrl = contentRootEntity2 != null ? contentRootEntity2.getUrl() : null;
            if (Intrinsics.areEqual((Object)removedUrl, (Object)addedUrl)) continue;
            if (removedUrl != null) {
                ((Collection)removedUrls).add(removedUrl);
            }
            if (addedUrl == null) continue;
            ((Collection)addedUrls).add(addedUrl);
        }
        Sequence removed = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)removedUrls), arg_0 -> ContentRootChangeListener.changed$lambda$0(addedUrls, arg_0)), ContentRootChangeListener::changed$lambda$1);
        Sequence added = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)addedUrls), arg_0 -> ContentRootChangeListener.changed$lambda$2(removedUrls, arg_0)), ContentRootChangeListener::changed$lambda$3);
        if (this.skipFileChanges) {
            removed = SequencesKt.filter((Sequence)removed, ContentRootChangeListener::changed$lambda$4);
            added = SequencesKt.filter((Sequence)added, ContentRootChangeListener::changed$lambda$5);
        }
        List removedList = SequencesKt.toList((Sequence)removed);
        List addedList = SequencesKt.toList((Sequence)added);
        if (!((Collection)removedList).isEmpty() || !((Collection)addedList).isEmpty()) {
            this.contentRootsChanged(removedList, addedList);
        }
    }

    public abstract void contentRootsChanged(@NotNull List<? extends VirtualFile> var1, @NotNull List<? extends VirtualFile> var2);

    private static final boolean changed$lambda$0(Set $addedUrls, VirtualFileUrl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$addedUrls.contains(it);
    }

    private static final VirtualFile changed$lambda$1(VirtualFileUrl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VirtualFileUrls.getVirtualFile((VirtualFileUrl)it);
    }

    private static final boolean changed$lambda$2(Set $removedUrls, VirtualFileUrl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !$removedUrls.contains(it);
    }

    private static final VirtualFile changed$lambda$3(VirtualFileUrl it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return VirtualFileUrls.getVirtualFile((VirtualFileUrl)it);
    }

    private static final boolean changed$lambda$4(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }

    private static final boolean changed$lambda$5(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }
}

