/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference;

import com.intellij.ide.BrowserUtil;
import com.intellij.model.Pointer;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.IssueDocumentationTargetProvider;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolProperty;
import com.intellij.polySymbols.references.PsiPolySymbolReferenceProvider;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainTextFile;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/psi/impl/source/resolve/reference/CommitMessageReferenceProvider;", "Lcom/intellij/polySymbols/references/PsiPolySymbolReferenceProvider;", "Lcom/intellij/psi/PsiPlainTextFile;", "<init>", "()V", "getOffsetsToReferencedSymbols", "", "", "Lcom/intellij/polySymbols/PolySymbol;", "psiElement", "LazyDocumentationIssueSymbol", "intellij.platform.vcs.impl"})
public final class CommitMessageReferenceProvider
implements PsiPolySymbolReferenceProvider<PsiPlainTextFile> {
    @NotNull
    public Map<Integer, PolySymbol> getOffsetsToReferencedSymbols(@NotNull PsiPlainTextFile psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!CommitMessage.isCommitMessage((PsiElement)psiElement)) {
            return MapsKt.emptyMap();
        }
        String text = psiElement.getText();
        CharSequence charSequence = StringUtil.newBombedCharSequence((CharSequence)text, (long)500L);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"newBombedCharSequence(...)");
        CharSequence bombedText = charSequence;
        Project project = psiElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)project2);
        List list = configuration.findIssueLinks(bombedText);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findIssueLinks(...)");
        List linkMatches = list;
        if (linkMatches.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map result2 = new LinkedHashMap();
        for (IssueNavigationConfiguration.LinkMatch linkMatch : linkMatches) {
            if (!linkMatch.isIssueMatch()) continue;
            Map map2 = result2;
            Integer n = linkMatch.getRange().getStartOffset();
            String string = linkMatch.getRange().substring(text);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            LazyDocumentationIssueSymbol lazyDocumentationIssueSymbol = new LazyDocumentationIssueSymbol(project2, string, linkMatch);
            map2.put(n, lazyDocumentationIssueSymbol);
        }
        return result2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0012H\u0016J\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J(\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\b\b\u0000\u0010\u0018*\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00180\u001bH\u0096\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"Lcom/intellij/psi/impl/source/resolve/reference/CommitMessageReferenceProvider$LazyDocumentationIssueSymbol;", "Lcom/intellij/polySymbols/PolySymbol;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "linkMatch", "Lcom/intellij/openapi/vcs/IssueNavigationConfiguration$LinkMatch;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vcs/IssueNavigationConfiguration$LinkMatch;)V", "getName", "()Ljava/lang/String;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "createPointer", "Lcom/intellij/model/Pointer;", "getDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "location", "Lcom/intellij/psi/PsiElement;", "get", "T", "", "property", "Lcom/intellij/polySymbols/PolySymbolProperty;", "(Lcom/intellij/polySymbols/PolySymbolProperty;)Ljava/lang/Object;", "presentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getPresentation", "()Lcom/intellij/platform/backend/presentation/TargetPresentation;", "getNavigationTargets", "", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "intellij.platform.vcs.impl"})
    private static final class LazyDocumentationIssueSymbol
    implements PolySymbol {
        @NotNull
        private final Project project;
        @NotNull
        private final String name;
        @NotNull
        private final IssueNavigationConfiguration.LinkMatch linkMatch;
        @NotNull
        private final PolySymbolKind kind;

        public LazyDocumentationIssueSymbol(@NotNull Project project, @NotNull String name, @NotNull IssueNavigationConfiguration.LinkMatch linkMatch) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)linkMatch, (String)"linkMatch");
            this.project = project;
            this.name = name;
            this.linkMatch = linkMatch;
            this.kind = PolySymbolKind.Companion.get("vcs", "issue");
        }

        @NotNull
        public String getName() {
            return this.name;
        }

        @NotNull
        public PolySymbolKind getKind() {
            return this.kind;
        }

        @NotNull
        public Pointer<? extends PolySymbol> createPointer() {
            Pointer pointer = Pointer.hardPointer((Object)this);
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
            return pointer;
        }

        @Nullable
        public DocumentationTarget getDocumentationTarget(@Nullable PsiElement location) {
            String string = this.getName();
            String string2 = this.linkMatch.getTargetUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTargetUrl(...)");
            return IssueDocumentationTargetProvider.Companion.getIssueDocumentationTarget(this.project, string, string2);
        }

        @Nullable
        public <T> T get(@NotNull PolySymbolProperty<T> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return (T)(Intrinsics.areEqual(property, (Object)PolySymbol.PROP_IJ_TEXT_ATTRIBUTES_KEY) ? property.tryCast((Object)EditorColors.REFERENCE_HYPERLINK_COLOR.getExternalName()) : null);
        }

        @NotNull
        public TargetPresentation getPresentation() {
            TargetPresentation targetPresentation = TargetPresentation.Companion.builder(this.getName()).presentation();
            Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
            return targetPresentation;
        }

        @NotNull
        public Collection<NavigationTarget> getNavigationTargets(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return CollectionsKt.listOf((Object)new NavigationTarget(this){
                final /* synthetic */ LazyDocumentationIssueSymbol this$0;
                {
                    this.this$0 = $receiver;
                }

                public Pointer<NavigationTarget> createPointer() {
                    Pointer pointer = Pointer.hardPointer((Object)this);
                    Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"hardPointer(...)");
                    return pointer;
                }

                public TargetPresentation computePresentation() {
                    return this.this$0.getPresentation();
                }

                public NavigationRequest navigationRequest() {
                    return new Navigatable(this.this$0){
                        final /* synthetic */ LazyDocumentationIssueSymbol this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public boolean canNavigate() {
                            return true;
                        }

                        public void navigate(boolean requestFocus) {
                            BrowserUtil.browse((String)LazyDocumentationIssueSymbol.access$getLinkMatch$p(this.this$0).getTargetUrl());
                        }
                    }.navigationRequest();
                }
            });
        }

        public static final /* synthetic */ IssueNavigationConfiguration.LinkMatch access$getLinkMatch$p(LazyDocumentationIssueSymbol $this) {
            return $this.linkMatch;
        }
    }
}

